/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.refactoring.RefactoringInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class GeneralRenameIDWizardPage
extends UserInputWizardPage {
    protected RefactoringInfo fInfo;
    private Text fNewId;
    private Button fUpdateReferences;

    public GeneralRenameIDWizardPage(String title, RefactoringInfo info) {
        super(title);
        this.fInfo = info;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Dialog.applyDialogFont((Control)composite);
        this.createMainControl(composite);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    protected void createMainControl(Composite parent) {
        this.createNewID(parent);
        this.createUpdateReferences(parent);
    }

    protected void createNewID(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(PDEUIMessages.RenamePluginWizardPage_newId);
        this.fNewId = new Text(composite, 2048);
        this.fNewId.setText(this.fInfo.getCurrentValue());
        this.fNewId.setLayoutData((Object)new GridData(768));
        this.fNewId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralRenameIDWizardPage.this.fInfo.setNewValue(GeneralRenameIDWizardPage.this.fNewId.getText());
                GeneralRenameIDWizardPage.this.validatePage();
            }
        });
    }

    protected void createUpdateReferences(Composite composite) {
        this.fUpdateReferences = new Button(composite, 32);
        this.fUpdateReferences.setText(PDEUIMessages.RenamePluginWizardPage_updateReferences);
        this.fUpdateReferences.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        this.fUpdateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralRenameIDWizardPage.this.fInfo.setUpdateReferences(GeneralRenameIDWizardPage.this.fUpdateReferences.getSelection());
            }
        });
        this.fUpdateReferences.setSelection(true);
    }

    protected void validatePage() {
        String text = this.fNewId.getText();
        String errorMessage = null;
        errorMessage = text.length() == 0 ? PDEUIMessages.RenamePluginWizardPage_idNotSet : this.validateId(text);
        if (errorMessage == null && text.equals(this.fInfo.getCurrentValue())) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(errorMessage == null ? new RefactoringStatus() : RefactoringStatus.createFatalErrorStatus((String)errorMessage));
        }
    }

    protected abstract String validateId(String var1);
}

