/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.jdt.internal.ui.navigator.OpenAndExpand;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class PackageExplorerOpenActionProvider
extends CommonActionProvider {
    private IAction fOpenAndExpand;
    private OpenEditorActionGroup fOpenGroup;
    private boolean fInViewPart = false;

    public void fillActionBars(IActionBars actionBars) {
        if (this.fInViewPart) {
            this.fOpenGroup.fillActionBars(actionBars);
            if (this.fOpenAndExpand == null && this.fOpenGroup.getOpenAction().isEnabled()) {
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.fOpenGroup.getOpenAction());
            } else if (this.fOpenAndExpand != null && this.fOpenAndExpand.isEnabled()) {
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.fOpenAndExpand);
            }
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.fInViewPart && this.fOpenGroup.getOpenAction().isEnabled()) {
            this.fOpenGroup.fillContextMenu(menu);
        }
    }

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchSite.getPart();
            this.fOpenGroup = new OpenEditorActionGroup(viewPart);
            if (site.getStructuredViewer() instanceof TreeViewer) {
                this.fOpenAndExpand = new OpenAndExpand((IWorkbenchSite)workbenchSite.getSite(), (OpenAction)this.fOpenGroup.getOpenAction(), (TreeViewer)site.getStructuredViewer());
            }
            this.fInViewPart = true;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (this.fInViewPart) {
            this.fOpenGroup.setContext(context);
        }
    }

    public void dispose() {
        if (this.fOpenGroup != null) {
            this.fOpenGroup.dispose();
        }
        super.dispose();
    }
}

