/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.SWTUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.preferences.ConfigurationEditorComponent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GlobalConfigurationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.egit.ui.internal.preferences.GlobalConfigurationPreferencePage";
    private FileBasedConfig userConfig;
    private FileBasedConfig sysConfig;
    private StackLayout repoConfigStackLayout;
    private List<Repository> repositories;
    private Map<Repository, ConfigurationEditorComponent> repoConfigEditors = new HashMap<Repository, ConfigurationEditorComponent>();
    private Set<Repository> dirtyRepositories = new HashSet<Repository>();
    private boolean userIsDirty;
    private boolean sysIsDirty;
    private ConfigurationEditorComponent userConfigEditor;
    private ConfigurationEditorComponent sysConfigEditor;
    private Composite repoConfigComposite;

    protected Control createContents(Composite parent) {
        Composite composite = SWTUtils.createHVFillComposite(parent, 0);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)SWTUtils.createHVFillGridData());
        this.userConfigEditor = new ConfigurationEditorComponent((Composite)tabFolder, (StoredConfig)this.userConfig, true){

            @Override
            protected void setErrorMessage(String message) {
                GlobalConfigurationPreferencePage.this.setErrorMessage(message);
            }

            @Override
            protected void setDirty(boolean dirty) {
                GlobalConfigurationPreferencePage.this.userIsDirty = dirty;
                GlobalConfigurationPreferencePage.this.updateApplyButton();
            }
        };
        this.sysConfigEditor = new ConfigurationEditorComponent((Composite)tabFolder, (StoredConfig)this.sysConfig, true){

            @Override
            protected void setErrorMessage(String message) {
                GlobalConfigurationPreferencePage.this.setErrorMessage(message);
            }

            @Override
            protected void setDirty(boolean dirty) {
                GlobalConfigurationPreferencePage.this.sysIsDirty = dirty;
                GlobalConfigurationPreferencePage.this.updateApplyButton();
            }
        };
        Control result = this.userConfigEditor.createContents();
        Dialog.applyDialogFont((Control)result);
        TabItem userTabItem = new TabItem(tabFolder, 4);
        userTabItem.setControl(result);
        userTabItem.setText(UIText.GlobalConfigurationPreferencePage_userSettingTabTitle);
        result = this.sysConfigEditor.createContents();
        Dialog.applyDialogFont((Control)result);
        TabItem sysTabItem = new TabItem(tabFolder, 4);
        sysTabItem.setControl(result);
        sysTabItem.setText(UIText.GlobalConfigurationPreferencePage_systemSettingTabTitle);
        Composite repoTab = new Composite((Composite)tabFolder, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(repoTab);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)repoTab);
        Composite repositoryComposite = new Composite(repoTab, 0);
        repositoryComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)repositoryComposite);
        Label repoLabel = new Label(repositoryComposite, 0);
        repoLabel.setText(UIText.GlobalConfigurationPreferencePage_repositorySettingRepositoryLabel);
        Combo repoCombo = new Combo(repositoryComposite, 8);
        repoCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.widget;
                GlobalConfigurationPreferencePage.this.showRepositoryConfiguration(combo.getSelectionIndex());
            }
        });
        repoCombo.setItems(this.getRepositoryComboItems());
        this.repoConfigComposite = new Composite(repoTab, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.repoConfigComposite);
        this.repoConfigStackLayout = new StackLayout();
        this.repoConfigComposite.setLayout((Layout)this.repoConfigStackLayout);
        TabItem repoTabItem = new TabItem(tabFolder, 4);
        repoTabItem.setControl((Control)repoTab);
        repoTabItem.setText(UIText.GlobalConfigurationPreferencePage_repositorySettingTabTitle);
        if (repoCombo.getItemCount() > 0) {
            repoCombo.select(0);
            this.showRepositoryConfiguration(0);
        } else {
            repoCombo.setItems(new String[]{UIText.GlobalConfigurationPreferencePage_repositorySettingNoRepositories});
            repoCombo.select(0);
            repoCombo.setEnabled(false);
        }
        return composite;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateApplyButton();
        }
        super.setVisible(visible);
    }

    protected void updateApplyButton() {
        if (this.getApplyButton() != null) {
            this.getApplyButton().setEnabled(this.userIsDirty || this.sysIsDirty || !this.dirtyRepositories.isEmpty());
        }
    }

    public boolean performOk() {
        Repository[] repos;
        boolean ok = true;
        if (this.userIsDirty) {
            try {
                this.userConfigEditor.save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                ok = false;
            }
        }
        if (this.sysIsDirty) {
            try {
                this.sysConfigEditor.save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                ok = false;
            }
        }
        Repository[] repositoryArray = repos = this.dirtyRepositories.toArray(new Repository[this.dirtyRepositories.size()]);
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repository = repositoryArray[n2];
            ConfigurationEditorComponent editor = this.repoConfigEditors.get(repository);
            try {
                editor.save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
                ok = false;
            }
            ++n2;
        }
        return ok;
    }

    protected void performDefaults() {
        try {
            this.userConfigEditor.restore();
            this.sysConfigEditor.restore();
            for (ConfigurationEditorComponent editor : this.repoConfigEditors.values()) {
                editor.restore();
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
        if (this.sysConfig == null) {
            this.sysConfig = SystemReader.getInstance().openSystemConfig(null, FS.DETECTED);
        }
        if (this.userConfig == null) {
            this.userConfig = SystemReader.getInstance().openUserConfig(null, FS.DETECTED);
        }
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
            List repoPaths = Activator.getDefault().getRepositoryUtil().getConfiguredRepositories();
            RepositoryCache repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
            for (String repoPath : repoPaths) {
                File gitDir = new File(repoPath);
                if (!gitDir.exists()) continue;
                try {
                    this.repositories.add(repositoryCache.lookupRepository(gitDir));
                }
                catch (IOException iOException) {}
            }
            this.sortRepositoriesByName();
        }
    }

    private String getName(Repository repo) {
        return Activator.getDefault().getRepositoryUtil().getRepositoryName(repo);
    }

    private void sortRepositoriesByName() {
        Collections.sort(this.repositories, new Comparator<Repository>(){

            @Override
            public int compare(Repository repo1, Repository repo2) {
                return GlobalConfigurationPreferencePage.this.getName(repo1).compareTo(GlobalConfigurationPreferencePage.this.getName(repo2));
            }
        });
    }

    private String[] getRepositoryComboItems() {
        ArrayList<String> items = new ArrayList<String>();
        for (Repository repository : this.repositories) {
            String repoName = this.getName(repository);
            if (repoName.length() <= 0) continue;
            items.add(repoName);
        }
        return items.toArray(new String[items.size()]);
    }

    private void showRepositoryConfiguration(int index) {
        Repository repository = this.repositories.get(index);
        ConfigurationEditorComponent editor = this.repoConfigEditors.get(repository);
        if (editor == null) {
            editor = this.createConfigurationEditor(repository);
            this.repoConfigEditors.put(repository, editor);
        }
        this.repoConfigStackLayout.topControl = editor.getContents();
        this.repoConfigComposite.layout();
    }

    private ConfigurationEditorComponent createConfigurationEditor(final Repository repository) {
        StoredConfig repositoryConfig;
        if (repository.getConfig() instanceof FileBasedConfig) {
            File configFile = ((FileBasedConfig)repository.getConfig()).getFile();
            repositoryConfig = new FileBasedConfig(configFile, repository.getFS());
            repositoryConfig.addChangeListener(new ConfigChangedListener(){

                public void onConfigChanged(ConfigChangedEvent event) {
                    repository.getListenerList().dispatch((RepositoryEvent)new ConfigChangedEvent());
                }
            });
        } else {
            repositoryConfig = repository.getConfig();
        }
        ConfigurationEditorComponent editorComponent = new ConfigurationEditorComponent(this.repoConfigComposite, repositoryConfig, true){

            @Override
            protected void setErrorMessage(String message) {
                GlobalConfigurationPreferencePage.this.setErrorMessage(message);
            }

            @Override
            protected void setDirty(boolean dirty) {
                if (dirty) {
                    GlobalConfigurationPreferencePage.this.dirtyRepositories.add(repository);
                } else {
                    GlobalConfigurationPreferencePage.this.dirtyRepositories.remove(repository);
                }
                GlobalConfigurationPreferencePage.this.updateApplyButton();
            }
        };
        editorComponent.createContents();
        return editorComponent;
    }
}

