/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.ui.IExtensionWizard;
import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewExtensionTemplateWizard
extends Wizard
implements IExtensionWizard {
    private ITemplateSection fSection;
    private IProject fProject;
    private IPluginModelBase fModel;
    private boolean fUpdatedDependencies;

    public NewExtensionTemplateWizard(ITemplateSection section) {
        Assert.isNotNull((Object)section);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEX_WIZ);
        this.setNeedsProgressMonitor(true);
        this.fSection = section;
    }

    @Override
    public void init(IProject project, IPluginModelBase model) {
        this.fProject = project;
        this.fModel = model;
    }

    public void addPages() {
        this.fSection.addPages(this);
        this.setWindowTitle(this.fSection.getLabel());
        if (this.fSection instanceof BaseOptionTemplateSection) {
            ((BaseOptionTemplateSection)this.fSection).initializeFields(this.fModel);
        }
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        int totalWork = NewExtensionTemplateWizard.this.fSection.getNumberOfWorkUnits();
                        monitor.beginTask(PDEUIMessages.NewExtensionTemplateWizard_generating, totalWork);
                        NewExtensionTemplateWizard.this.updateDependencies();
                        NewExtensionTemplateWizard.this.fSection.execute(NewExtensionTemplateWizard.this.fProject, NewExtensionTemplateWizard.this.fModel, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    private void updateDependencies() throws CoreException {
        IPluginReference[] refs = this.fSection.getDependencies(this.fModel.getPluginBase().getSchemaVersion());
        int i = 0;
        while (i < refs.length) {
            IPluginReference ref = refs[i];
            if (!this.modelContains(ref)) {
                IPluginImport iimport = this.fModel.getPluginFactory().createImport();
                iimport.setId(ref.getId());
                iimport.setMatch(ref.getMatch());
                iimport.setVersion(ref.getVersion());
                this.fModel.getPluginBase().add(iimport);
                this.fUpdatedDependencies = true;
            }
            ++i;
        }
    }

    private boolean modelContains(IPluginReference ref) {
        IPluginBase plugin = this.fModel.getPluginBase();
        IPluginImport[] imports = plugin.getImports();
        int i = 0;
        while (i < imports.length) {
            IPluginImport iimport = imports[i];
            if (iimport.getId().equals(ref.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean updatedDependencies() {
        return this.fUpdatedDependencies;
    }
}

