/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class PluginExportWizardPage
extends BaseExportWizardPage {
    public PluginExportWizardPage(IStructuredSelection selection) {
        super(selection, "pluginExport", PDEUIMessages.ExportWizard_Plugin_pageBlock);
        this.setTitle(PDEUIMessages.ExportWizard_Plugin_pageTitle);
    }

    @Override
    protected Object getInput() {
        return PDECore.getDefault().getModelManager();
    }

    @Override
    public Object[] getListElements() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < projects.length) {
            IPluginModelBase model;
            if (!WorkspaceModelManager.isBinaryProject((IProject)projects[i]) && WorkspaceModelManager.isPluginProject((IProject)projects[i]) && (model = PluginRegistry.findModel((IProject)projects[i])) != null && this.isValidModel((IModel)model) && this.hasBuildProperties(model)) {
                result.add(model);
            }
            ++i;
        }
        return result.toArray();
    }

    @Override
    protected void hookHelpContext(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.pde.doc.user.plugin_export_wizard");
    }

    private boolean hasBuildProperties(IPluginModelBase model) {
        File file = new File(model.getInstallLocation(), "build.properties");
        return file.exists();
    }

    @Override
    protected boolean isValidModel(IModel model) {
        return model != null && model instanceof IPluginModelBase;
    }

    @Override
    protected IModel findModelFor(IAdaptable object) {
        IPluginModelBase model;
        if (object instanceof IJavaProject) {
            object = ((IJavaProject)object).getProject();
        }
        if (object instanceof IProject) {
            return PluginRegistry.findModel((IProject)((IProject)object));
        }
        if (object instanceof PersistablePluginObject && (model = PluginRegistry.findModel((String)((PersistablePluginObject)object).getPluginID())) != null && model.getUnderlyingResource() != null) {
            return model;
        }
        return null;
    }

    protected boolean isEnableJarButton() {
        return this.getSelectedItems().length <= 1;
    }

    @Override
    protected void adjustAdvancedTabsVisibility() {
        this.adjustJARSigningTabVisibility();
        this.pageChanged();
    }
}

