/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class PerspectiveTagger {
    public static void tagPerspective(MPerspective perspective, EModelService modelService) {
        String id = perspective.getElementId();
        if (id == null) {
            return;
        }
        if (id.equals("org.eclipse.jdt.ui.JavaPerspective")) {
            PerspectiveTagger.tagJavaPerspective(perspective, modelService);
        } else if (id.equals("org.eclipse.team.cvs.ui.cvsPerspective")) {
            PerspectiveTagger.tagCVSPerspective(perspective, modelService);
        } else if (id.equals("org.eclipse.team.ui.TeamSynchronizingPerspective")) {
            PerspectiveTagger.tagTeamPerspective(perspective, modelService);
        } else if (id.equals("org.eclipse.debug.ui.DebugPerspective")) {
            PerspectiveTagger.tagDebugPerspective(perspective, modelService);
        } else if (id.equals("org.eclipse.ui.resourcePerspective")) {
            PerspectiveTagger.tagResourcePerspective(perspective, modelService);
        } else if (id.equals("org.eclipse.pde.ui.PDEPerspective")) {
            PerspectiveTagger.tagPluginDevelopmentPerspective(perspective, modelService);
        }
    }

    static void tagJavaPerspective(MPerspective perspective, EModelService modelService) {
        MUIElement element = modelService.find("left", (MUIElement)perspective);
        if (element != null) {
            element.getTags().add("org.eclipse.e4.primaryNavigationStack");
        }
        if ((element = modelService.find("bottom", (MUIElement)perspective)) != null) {
            element.getTags().add("org.eclipse.e4.secondaryDataStack");
        }
        if ((element = modelService.find("right", (MUIElement)perspective)) != null) {
            element.getTags().add("org.eclipse.e4.secondaryNavigationStack");
        }
    }

    static void tagCVSPerspective(MPerspective perspective, EModelService modelService) {
        MUIElement element = modelService.find("top", (MUIElement)perspective);
        if (element != null) {
            element.getTags().add("org.eclipse.e4.primaryNavigationStack");
        }
    }

    static void tagTeamPerspective(MPerspective perspective, EModelService modelService) {
        MUIElement element = modelService.find("top", (MUIElement)perspective);
        if (element != null) {
            element.getTags().add("org.eclipse.e4.primaryNavigationStack");
        }
        if ((element = modelService.find("top2", (MUIElement)perspective)) != null) {
            element.getTags().add("org.eclipse.e4.secondaryDataStack");
        }
    }

    static void tagDebugPerspective(MPerspective perspective, EModelService modelService) {
        MUIElement element = modelService.find("org.eclipse.debug.internal.ui.NavigatorFolderView", (MUIElement)perspective);
        if (element != null) {
            element.getTags().add("org.eclipse.e4.primaryNavigationStack");
        }
        if ((element = modelService.find("org.eclipse.debug.internal.ui.ConsoleFolderView", (MUIElement)perspective)) != null) {
            element.getTags().add("org.eclipse.e4.secondaryDataStack");
        }
        if ((element = modelService.find("org.eclipse.debug.internal.ui.OutlineFolderView", (MUIElement)perspective)) != null) {
            element.getTags().add("org.eclipse.e4.secondaryNavigationStack");
        }
    }

    static void tagResourcePerspective(MPerspective perspective, EModelService modelService) {
        MUIElement element = modelService.find("topLeft", (MUIElement)perspective);
        if (element != null) {
            element.getTags().add("org.eclipse.e4.primaryNavigationStack");
        }
        if ((element = modelService.find("bottomRight", (MUIElement)perspective)) != null) {
            element.getTags().add("org.eclipse.e4.secondaryDataStack");
        }
        if ((element = modelService.find("bottomLeft", (MUIElement)perspective)) != null) {
            element.getTags().add("org.eclipse.e4.secondaryNavigationStack");
        }
    }

    static void tagPluginDevelopmentPerspective(MPerspective perspective, EModelService modelService) {
        MUIElement element = modelService.find("topLeft", (MUIElement)perspective);
        if (element != null) {
            element.getTags().add("org.eclipse.e4.primaryNavigationStack");
        }
        if ((element = modelService.find("bottomRight", (MUIElement)perspective)) != null) {
            element.getTags().add("org.eclipse.e4.secondaryDataStack");
        }
    }
}

