/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.InputStream;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class StorageTypedElement
implements ITypedElement,
IEncodedStreamContentAccessor,
IAdaptable {
    private IStorage bufferedContents;
    private final String localEncoding;
    private ISharedDocumentAdapter sharedDocumentAdapter;
    static /* synthetic */ Class class$0;

    public StorageTypedElement(String localEncoding) {
        this.localEncoding = localEncoding;
    }

    public InputStream getContents() throws CoreException {
        if (this.bufferedContents == null) {
            this.cacheContents((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.bufferedContents != null) {
            return this.bufferedContents.getContents();
        }
        return null;
    }

    public void cacheContents(IProgressMonitor monitor) throws CoreException {
        this.bufferedContents = this.fetchContents(monitor);
    }

    protected abstract IStorage fetchContents(IProgressMonitor var1) throws CoreException;

    public IStorage getBufferedStorage() {
        return this.bufferedContents;
    }

    public Image getImage() {
        return CompareUI.getImage((String)this.getType());
    }

    public String getType() {
        String name = this.getName();
        if (name != null) {
            int index = name.lastIndexOf(46);
            if (index == -1) {
                return "";
            }
            if (index == name.length() - 1) {
                return "";
            }
            return name.substring(index + 1);
        }
        return "FOLDER";
    }

    public String getCharset() throws CoreException {
        if (this.localEncoding != null) {
            return this.localEncoding;
        }
        if (this.bufferedContents == null) {
            this.cacheContents((IProgressMonitor)new NullProgressMonitor());
        }
        if (this.bufferedContents instanceof IEncodedStorage) {
            String charset = ((IEncodedStorage)this.bufferedContents).getCharset();
            return charset;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.compare.ISharedDocumentAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            StorageTypedElement storageTypedElement = this;
            synchronized (storageTypedElement) {
                if (this.sharedDocumentAdapter == null) {
                    this.sharedDocumentAdapter = new SharedDocumentAdapter(){

                        public IEditorInput getDocumentKey(Object element) {
                            return StorageTypedElement.this.getDocumentKey(element);
                        }

                        public void flushDocument(IDocumentProvider provider, IEditorInput documentKey, IDocument document, boolean overwrite) throws CoreException {
                        }
                    };
                }
                return this.sharedDocumentAdapter;
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected abstract IEditorInput getDocumentKey(Object var1);

    public String getLocalEncoding() {
        return this.localEncoding;
    }
}

