/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpMessages;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpProfileManager;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanUpPreferenceUtil {
    public static final String SAVE_PARTICIPANT_KEY_PREFIX = "sp_";

    public static Map<String, String> loadOptions(IScopeContext context) {
        return CleanUpPreferenceUtil.loadOptions(context, "cleanup_profile", "org.eclipse.jdt.ui.default.eclipse_clean_up_profile");
    }

    private static Map<String, String> loadOptions(IScopeContext context, String profileIdKey, String defaultProfileId) {
        IEclipsePreferences contextNode = context.getNode("org.eclipse.jdt.ui");
        String id = contextNode.get(profileIdKey, null);
        if (id != null && "project".equals(context.getName())) {
            return CleanUpPreferenceUtil.loadFromProject(context);
        }
        IScopeContext instanceScope = InstanceScope.INSTANCE;
        if (id == null) {
            if ("project".equals(context.getName())) {
                id = instanceScope.getNode("org.eclipse.jdt.ui").get(profileIdKey, null);
            }
            if (id == null) {
                id = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.ui").get(profileIdKey, defaultProfileId);
            }
        }
        List<ProfileManager.Profile> builtInProfiles = CleanUpPreferenceUtil.getBuiltInProfiles();
        for (ProfileManager.Profile profile : builtInProfiles) {
            if (!id.equals(profile.getID())) continue;
            return profile.getSettings();
        }
        if (id.equals("org.eclipse.jdt.ui.default.save_participant_clean_up_profile")) {
            return JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(2).getMap();
        }
        CleanUpProfileVersioner versioner = new CleanUpProfileVersioner();
        ProfileStore profileStore = new ProfileStore("org.eclipse.jdt.ui.cleanupprofiles", versioner);
        List<ProfileManager.Profile> list = null;
        try {
            list = profileStore.readProfiles(instanceScope);
        }
        catch (CoreException e1) {
            JavaPlugin.log(e1);
        }
        if (list == null) {
            return null;
        }
        for (ProfileManager.Profile profile : list) {
            if (!id.equals(profile.getID())) continue;
            return profile.getSettings();
        }
        return null;
    }

    private static Map<String, String> loadFromProject(IScopeContext context) {
        HashMap<String, String> profileOptions = new HashMap<String, String>();
        IEclipsePreferences uiPrefs = context.getNode("org.eclipse.jdt.ui");
        CleanUpProfileVersioner versioner = new CleanUpProfileVersioner();
        MapCleanUpOptions defaultOptions = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1);
        ProfileManager.KeySet[] keySets = CleanUpProfileManager.KEY_SETS;
        boolean hasValues = false;
        int i = 0;
        while (i < keySets.length) {
            ProfileManager.KeySet keySet = keySets[i];
            IEclipsePreferences preferences = context.getNode(keySet.getNodeName());
            for (String key : keySet.getKeys()) {
                String val = preferences.get(key, null);
                if (val != null) {
                    hasValues = true;
                } else {
                    val = defaultOptions.getValue(key);
                }
                profileOptions.put(key, val);
            }
            ++i;
        }
        if (!hasValues) {
            return null;
        }
        int version = uiPrefs.getInt("cleanup_settings_version", versioner.getFirstVersion());
        if (version == versioner.getCurrentVersion()) {
            return profileOptions;
        }
        ProfileManager.CustomProfile profile = new ProfileManager.CustomProfile("tmp", profileOptions, version, versioner.getProfileKind());
        versioner.update(profile);
        return profile.getSettings();
    }

    public static Map<String, String> loadSaveParticipantOptions(IScopeContext context) {
        IEclipsePreferences node;
        if (CleanUpPreferenceUtil.hasSettingsInScope(context)) {
            node = context.getNode("org.eclipse.jdt.ui");
        } else {
            IScopeContext instanceScope = InstanceScope.INSTANCE;
            if (CleanUpPreferenceUtil.hasSettingsInScope(instanceScope)) {
                node = instanceScope.getNode("org.eclipse.jdt.ui");
            } else {
                return JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(2).getMap();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Set<String> keys = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(2).getKeys();
        for (String key : keys) {
            result.put(key, node.get(SAVE_PARTICIPANT_KEY_PREFIX + key, "false"));
        }
        return result;
    }

    public static void saveSaveParticipantOptions(IScopeContext context, Map<String, String> settings) {
        IEclipsePreferences node = context.getNode("org.eclipse.jdt.ui");
        for (String key : settings.keySet()) {
            node.put(SAVE_PARTICIPANT_KEY_PREFIX + key, settings.get(key));
        }
    }

    public static boolean hasSettingsInScope(IScopeContext context) {
        IEclipsePreferences node = context.getNode("org.eclipse.jdt.ui");
        Set<String> keys = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(2).getKeys();
        for (String key : keys) {
            if (node.get(SAVE_PARTICIPANT_KEY_PREFIX + key, null) == null) continue;
            return true;
        }
        return false;
    }

    public static List<ProfileManager.Profile> loadProfiles(IScopeContext scope) {
        CleanUpProfileVersioner versioner = new CleanUpProfileVersioner();
        ProfileStore profileStore = new ProfileStore("org.eclipse.jdt.ui.cleanupprofiles", versioner);
        List<ProfileManager.Profile> list = null;
        try {
            list = profileStore.readProfiles(scope);
        }
        catch (CoreException e1) {
            JavaPlugin.log(e1);
        }
        if (list == null) {
            list = CleanUpPreferenceUtil.getBuiltInProfiles();
        } else {
            list.addAll(CleanUpPreferenceUtil.getBuiltInProfiles());
        }
        return list;
    }

    public static List<ProfileManager.Profile> getBuiltInProfiles() {
        ArrayList<ProfileManager.Profile> result = new ArrayList<ProfileManager.Profile>();
        Map<String, String> settings = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1).getMap();
        ProfileManager.BuiltInProfile eclipseProfile = new ProfileManager.BuiltInProfile("org.eclipse.jdt.ui.default.eclipse_clean_up_profile", CleanUpMessages.CleanUpProfileManager_ProfileName_EclipseBuildIn, settings, 2, 2, "CleanUpProfile");
        result.add(eclipseProfile);
        return result;
    }
}

