/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.navigator;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorTreeViewer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.AnomalyUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

public class R4EUIElementDropAdapter
extends ViewerDropAdapter {
    public R4EUIElementDropAdapter(ReviewNavigatorTreeViewer viewer) {
        super((Viewer)viewer);
    }

    public boolean performDrop(Object aData) {
        R4EUIModelElement target;
        if (aData != null && (target = (R4EUIModelElement)this.getCurrentTarget()) != null) {
            Object[] sourceElements;
            Object[] objectArray = sourceElements = ((IStructuredSelection)aData).toArray();
            int n = sourceElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object sourceElement = objectArray[n2];
                if (target instanceof R4EUIContent && sourceElement instanceof R4EUIAnomalyBasic) {
                    if (AnomalyUtils.isAnomalyExist((R4EUIFileContext)target.getParent().getParent(), ((R4EUIContent)target).getPosition(), ((R4EUIAnomalyBasic)sourceElement).getAnomaly().getDescription()) == null) {
                        try {
                            AnomalyUtils.cloneLinkedAnomaly((R4EUIContent)target, (R4EUIAnomalyBasic)sourceElement);
                        }
                        catch (ResourceHandlingException e) {
                            UIUtils.displayResourceErrorDialog(e);
                        }
                        catch (OutOfSyncException e) {
                            UIUtils.displaySyncErrorDialog(e);
                        }
                    }
                } else if (target instanceof R4EUIAnomalyBasic && sourceElement instanceof R4EUIComment && AnomalyUtils.isCommentExist((R4EUIAnomalyBasic)target, ((R4EUIComment)sourceElement).getComment().getDescription()) == null) {
                    try {
                        IR4EUIModelElement newUIComment = ((R4EUIAnomalyBasic)target).createChildren((ReviewComponent)((R4EUIComment)sourceElement).getComment());
                        UIUtils.setNavigatorViewFocus(newUIComment, -1);
                    }
                    catch (ResourceHandlingException e) {
                        UIUtils.displayResourceErrorDialog(e);
                    }
                    catch (OutOfSyncException e) {
                        UIUtils.displaySyncErrorDialog(e);
                    }
                    catch (CompatibilityException e) {
                        UIUtils.displayCompatibilityErrorDialog(e);
                    }
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean validateDrop(Object aTarget, int aOperation, TransferData aTransferType) {
        IR4EUIModelElement elementSelected = (IR4EUIModelElement)((IStructuredSelection)R4EUIModelController.getNavigatorView().getTreeViewer().getSelection()).getFirstElement();
        if (aTarget instanceof R4EUIContent && elementSelected instanceof R4EUIAnomalyBasic || aTarget instanceof R4EUIAnomalyBasic && elementSelected instanceof R4EUIComment) {
            return LocalSelectionTransfer.getTransfer().isSupportedType(aTransferType);
        }
        return false;
    }

    public void dragOver(DropTargetEvent aEvent) {
        super.dragOver(aEvent);
        aEvent.feedback = 2;
    }
}

