/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.frame.core.utils.Tracer;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EContextType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.IRFSRegistry;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.RFSRegistryFactory;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EDeltaCompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIDeltaContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.Diff;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.DiffUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.MailServicesProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.versions.core.Change;
import org.eclipse.mylyn.versions.core.ChangeSet;
import org.eclipse.mylyn.versions.core.ScmArtifact;
import org.eclipse.mylyn.versions.ui.spi.ScmConnectorUi;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressConstants;

public class FindReviewItemsHandler
extends AbstractHandler {
    private static final String FETCH_JOB_FAMILY = "fetchFamily";
    private static final String DELTA_JOB_FAMILY = "deltaFamily";
    private static final String ADD_JOB_FAMILY = "addFamily";
    private static final String IMPORTING_FILES_MSG = "Importing Files...";
    private static final String FETCHING_FILES_MSG = "Fetching Files...";
    private static final String FETCHING_FILE_MSG = "Fetching File...";
    private static final String CALCULATE_DELTAS_MSG = "Computing differences...";
    private static final String CALCULATE_DELTAS_FILE_MSG = "Computing differences for file ";
    private static final String ADD_ELEMENT_MSG = "Adding Elements to R4E model...";
    private static final String ADD_REVIEW_ITEM_MSG = "Adding Review Item to R4E Model...";
    private static final int MAX_CONCURRRENT_JOBS = 20;
    private final ReentrantLock fLock = new ReentrantLock();
    private final AtomicInteger fRunningJobs = new AtomicInteger(0);
    private Exception fExceptionError;

    public Object execute(ExecutionEvent aEvent) {
        ISelection selection;
        this.fExceptionError = null;
        if (this.fLock.isLocked()) {
            this.fLock.unlock();
        }
        if ((selection = HandlerUtil.getCurrentSelection((ExecutionEvent)aEvent)) instanceof IStructuredSelection) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            IProject project = null;
            if (selectedElement instanceof IProject) {
                project = (IProject)selectedElement;
            } else if (R4EUIPlugin.isJDTAvailable() && selectedElement instanceof IJavaProject) {
                project = ((IJavaProject)selectedElement).getProject();
            } else if (R4EUIPlugin.isCDTAvailable() && selectedElement instanceof ICProject) {
                project = ((ICProject)selectedElement).getProject();
            } else if (selectedElement instanceof IPackageFragment || selectedElement instanceof IPackageFragmentRoot) {
                project = ((IJavaElement)selectedElement).getJavaProject().getProject();
            } else if (selectedElement instanceof IFolder) {
                project = ((IFolder)selectedElement).getProject();
            } else if (selectedElement instanceof IAdaptable) {
                IAdaptable adaptableProject = (IAdaptable)selectedElement;
                project = (IProject)adaptableProject.getAdapter(IProject.class);
            } else {
                R4EUIPlugin.Ftracer.traceError("No project defined for selection of class " + (selectedElement != null ? selectedElement.getClass() : ""));
                R4EUIPlugin.getDefault().logError("No project defined for selection of class " + (selectedElement != null ? selectedElement.getClass() : ""), null);
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Find Review Item Error", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "No project defined for selection", null), 4);
                dialog.open();
                return null;
            }
            Cursor cursor = new Cursor((Device)PlatformUI.getWorkbench().getDisplay(), 1);
            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            activeShell.setCursor(cursor);
            ScmConnectorUi uiConnector = R4EUIDialogFactory.getInstance().getScmUiConnector(project);
            if (uiConnector != null) {
                R4EUIPlugin.Ftracer.traceDebug("Resolved Scm Ui connector: " + uiConnector);
                ChangeSet changeSet = uiConnector.getChangeSet(null, (IResource)project);
                activeShell.setCursor(null);
                cursor.dispose();
                this.createReviewItem(aEvent, changeSet);
            } else {
                activeShell.setCursor(null);
                cursor.dispose();
                String strProject = project == null ? "(no project)" : project.getName();
                R4EUIPlugin.Ftracer.traceDebug("No Scm Ui connector found for project: " + strProject);
                ErrorDialog dialog = new ErrorDialog(null, "R4E Warning", "Cannot find new Review Items", (IStatus)new Status(2, "org.eclipse.mylyn.reviews.r4e.ui", 0, "No SCM Connector detected for Project " + strProject, null), 2);
                dialog.open();
            }
        }
        return null;
    }

    private void createReviewItem(ExecutionEvent aEvent, final ChangeSet aChangeSet) {
        if (aChangeSet == null) {
            R4EUIPlugin.Ftracer.traceInfo("Received null ChangeSet");
            return;
        }
        int size = aChangeSet.getChanges().size();
        R4EUIPlugin.Ftracer.traceInfo("Received ChangeSet with " + size + " elements");
        if (size == 0) {
            return;
        }
        final R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
        if (uiReview == null) {
            return;
        }
        for (R4EUIReviewItem uiItem : uiReview.getReviewItems()) {
            if (uiItem == null || !aChangeSet.getId().equals(uiItem.getItem().getRepositoryRef())) continue;
            R4EUIPlugin.Ftracer.traceWarning("Review Item already exists.  Ignoring");
            ErrorDialog dialog = new ErrorDialog(null, "R4E Warning", "Cannot add Review Item", (IStatus)new Status(2, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Review Item already exists", null), 2);
            dialog.open();
            return;
        }
        try {
            final IRFSRegistry localRepository = RFSRegistryFactory.getRegistry((R4EReview)R4EUIModelController.getActiveReview().getReview());
            final List filesToAddlist = Collections.synchronizedList(new ArrayList());
            Job mainJob = new Job(IMPORTING_FILES_MSG){

                public IStatus run(final IProgressMonitor aMonitor) {
                    Date jobEnd;
                    if (aMonitor == null) {
                        return Status.CANCEL_STATUS;
                    }
                    R4EUIModelController.setJobInProgress(true);
                    aMonitor.beginTask(FindReviewItemsHandler.IMPORTING_FILES_MSG, 3);
                    aMonitor.subTask(FindReviewItemsHandler.FETCHING_FILES_MSG);
                    Date startImportingTime = null;
                    Date startFetchTime = null;
                    if (Tracer.isInfo()) {
                        startImportingTime = new Date();
                        startFetchTime = new Date();
                    }
                    for (final Change change : aChangeSet.getChanges()) {
                        Job fetchJob = new Job(FindReviewItemsHandler.FETCHING_FILE_MSG){

                            public boolean belongsTo(Object aFamily) {
                                return FindReviewItemsHandler.FETCH_JOB_FAMILY.equals(aFamily);
                            }

                            public IStatus run(IProgressMonitor aFetchMonitor) {
                                if (aFetchMonitor == null) {
                                    return Status.CANCEL_STATUS;
                                }
                                if (aMonitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                aFetchMonitor.beginTask(FindReviewItemsHandler.FETCHING_FILE_MSG, 2);
                                try {
                                    TempFileContext file = FindReviewItemsHandler.this.fetchFiles(change, localRepository, aMonitor, aFetchMonitor);
                                    filesToAddlist.add(file);
                                    aFetchMonitor.done();
                                    return Status.OK_STATUS;
                                }
                                catch (ReviewsFileStorageException e) {
                                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                                    R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                                    if (FindReviewItemsHandler.this.fExceptionError == null) {
                                        FindReviewItemsHandler.this.fExceptionError = (Exception)((Object)e);
                                    }
                                    aFetchMonitor.done();
                                    return Status.CANCEL_STATUS;
                                }
                                catch (CoreException e) {
                                    if (!e.getMessage().equals("Operation cancelled by User")) {
                                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                                        if (FindReviewItemsHandler.this.fExceptionError == null) {
                                            FindReviewItemsHandler.this.fExceptionError = (Exception)((Object)e);
                                        }
                                    }
                                    aFetchMonitor.done();
                                    return Status.CANCEL_STATUS;
                                }
                            }
                        };
                        fetchJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void running(IJobChangeEvent aEvent) {
                                if (aEvent == null || aEvent.getResult() == null || !aEvent.getResult().equals(Status.CANCEL_STATUS)) {
                                    FindReviewItemsHandler.this.fRunningJobs.getAndIncrement();
                                }
                            }

                            public void done(IJobChangeEvent aEvent) {
                                FindReviewItemsHandler.this.fRunningJobs.decrementAndGet();
                            }
                        });
                        fetchJob.setRule((ISchedulingRule)new JobQueueSchedulingRule());
                        fetchJob.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
                        fetchJob.setUser(false);
                        fetchJob.schedule();
                    }
                    try {
                        Job.getJobManager().join((Object)FindReviewItemsHandler.FETCH_JOB_FAMILY, null);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (InterruptedException ex) {
                        R4EUIPlugin.getDefault().logError("Exception: " + ex.toString(), ex);
                        return Status.CANCEL_STATUS;
                    }
                    if (aMonitor.isCanceled()) {
                        aMonitor.done();
                        R4EUIModelController.setJobInProgress(false);
                        if (FindReviewItemsHandler.this.fExceptionError != null) {
                            if (FindReviewItemsHandler.this.fExceptionError instanceof ReviewsFileStorageException) {
                                UIUtils.displayReviewsFileStorageErrorDialog((ReviewsFileStorageException)((Object)FindReviewItemsHandler.this.fExceptionError));
                            } else if (FindReviewItemsHandler.this.fExceptionError instanceof CoreException) {
                                UIUtils.displayCoreErrorDialog((CoreException)((Object)FindReviewItemsHandler.this.fExceptionError));
                            }
                        }
                        return Status.CANCEL_STATUS;
                    }
                    aMonitor.worked(1);
                    if (startFetchTime != null) {
                        R4EUIPlugin.Ftracer.traceInfo("Total time to Import/Push files is: " + (new Date().getTime() - startFetchTime.getTime()));
                    }
                    Date startingComputeTime = null;
                    if (Tracer.isInfo()) {
                        startingComputeTime = new Date();
                    }
                    if (R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("useDeltasPreferences")) {
                        aMonitor.subTask(FindReviewItemsHandler.CALCULATE_DELTAS_MSG);
                        for (final TempFileContext file : filesToAddlist) {
                            if (file == null) continue;
                            Job deltaJob = new Job(FindReviewItemsHandler.CALCULATE_DELTAS_MSG){

                                public boolean belongsTo(Object aFamily) {
                                    return FindReviewItemsHandler.DELTA_JOB_FAMILY.equals(aFamily);
                                }

                                public IStatus run(IProgressMonitor aDeltaMonitor) {
                                    if (aDeltaMonitor == null) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    aDeltaMonitor.beginTask(FindReviewItemsHandler.CALCULATE_DELTAS_FILE_MSG + file.toString(), 1);
                                    try {
                                        FindReviewItemsHandler.this.updateFilesWithDeltas(file);
                                    }
                                    catch (CoreException e) {
                                        R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                                        R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                                    }
                                    aDeltaMonitor.worked(1);
                                    aDeltaMonitor.done();
                                    return Status.OK_STATUS;
                                }
                            };
                            deltaJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                                public void running(IJobChangeEvent aEvent) {
                                    if (aEvent == null || aEvent.getResult() == null || !aEvent.getResult().equals(Status.CANCEL_STATUS)) {
                                        FindReviewItemsHandler.this.fRunningJobs.getAndIncrement();
                                    }
                                }

                                public void done(IJobChangeEvent aEvent) {
                                    FindReviewItemsHandler.this.fRunningJobs.decrementAndGet();
                                }
                            });
                            deltaJob.setRule((ISchedulingRule)new JobQueueSchedulingRule());
                            deltaJob.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
                            deltaJob.setUser(false);
                            deltaJob.schedule();
                        }
                        try {
                            Job.getJobManager().join((Object)FindReviewItemsHandler.DELTA_JOB_FAMILY, null);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return Status.CANCEL_STATUS;
                        }
                        catch (InterruptedException ex) {
                            R4EUIPlugin.getDefault().logError("Exception: " + ex.toString(), ex);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    if (aMonitor.isCanceled()) {
                        aMonitor.done();
                        R4EUIModelController.setJobInProgress(false);
                        return Status.CANCEL_STATUS;
                    }
                    aMonitor.worked(1);
                    if (startingComputeTime != null) {
                        R4EUIPlugin.Ftracer.traceInfo("Total time to Compute changes is: " + (new Date().getTime() - startingComputeTime.getTime()));
                    }
                    Date startUpdatingModel = null;
                    if (Tracer.isInfo()) {
                        startUpdatingModel = new Date();
                    }
                    aMonitor.subTask(FindReviewItemsHandler.ADD_ELEMENT_MSG);
                    Job addJob = new Job(FindReviewItemsHandler.ADD_ELEMENT_MSG){

                        public boolean belongsTo(Object aFamily) {
                            return FindReviewItemsHandler.ADD_JOB_FAMILY.equals(aFamily);
                        }

                        /*
                         * Loose catch block
                         */
                        public IStatus run(IProgressMonitor aAddMonitor) {
                            if (aAddMonitor == null) {
                                return Status.CANCEL_STATUS;
                            }
                            try {
                                try {
                                    if (filesToAddlist.size() > 0) {
                                        aAddMonitor.beginTask(FindReviewItemsHandler.ADD_ELEMENT_MSG, filesToAddlist.size() + 1);
                                        aAddMonitor.subTask(FindReviewItemsHandler.ADD_REVIEW_ITEM_MSG);
                                        R4EUIReviewItem uiReviewItem = uiReview.createCommitReviewItem(aChangeSet, null);
                                        aAddMonitor.worked(1);
                                        Resource resource = uiReviewItem.getItem().eResource();
                                        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)uiReviewItem.getItem(), R4EUIModelController.getReviewer());
                                        R4EUIModelController.stopSerialization(resource);
                                        for (TempFileContext file : filesToAddlist) {
                                            if (file.getTarget() != null || file.getBase() != null) {
                                                FindReviewItemsHandler.this.addFileToModel(uiReviewItem, file, aAddMonitor);
                                                continue;
                                            }
                                            R4EUIPlugin.Ftracer.traceWarning("Warning No Base and NO target files, so no ADD");
                                        }
                                        R4EUIModelController.resetToDefaultSerialization();
                                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                                        UIUtils.setNavigatorViewFocus(uiReviewItem, 1);
                                        ArrayList<R4EReviewComponent> addedItems = new ArrayList<R4EReviewComponent>();
                                        addedItems.add((R4EReviewComponent)uiReviewItem.getItem());
                                        R4EReview review = uiReview.getReview();
                                        if (review.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL) && ((R4EFormalReview)review).getCurrent().getType().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_PREPARATION)) {
                                            MailServicesProxy.sendItemsAddedNotification(addedItems);
                                        }
                                    }
                                }
                                catch (CoreException e) {
                                    UIUtils.displayCoreErrorDialog(e);
                                    R4EUIModelController.resetToDefaultSerialization();
                                }
                                catch (ResourceHandlingException e) {
                                    UIUtils.displayResourceErrorDialog(e);
                                    R4EUIModelController.resetToDefaultSerialization();
                                }
                                catch (OutOfSyncException e) {
                                    UIUtils.displaySyncErrorDialog(e);
                                    {
                                        catch (Throwable throwable) {
                                            throw throwable;
                                        }
                                    }
                                    R4EUIModelController.resetToDefaultSerialization();
                                }
                            }
                            finally {
                                R4EUIModelController.resetToDefaultSerialization();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    addJob.setUser(false);
                    addJob.schedule();
                    try {
                        Job.getJobManager().join((Object)FindReviewItemsHandler.ADD_JOB_FAMILY, null);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return Status.CANCEL_STATUS;
                    }
                    catch (InterruptedException ex) {
                        R4EUIPlugin.getDefault().logError("Exception: " + ex.toString(), ex);
                        return Status.CANCEL_STATUS;
                    }
                    if (startUpdatingModel != null) {
                        jobEnd = new Date();
                        R4EUIPlugin.Ftracer.traceInfo("Total time to update model is: " + (jobEnd.getTime() - startUpdatingModel.getTime()));
                    }
                    if (startImportingTime != null) {
                        jobEnd = new Date();
                        R4EUIPlugin.Ftracer.traceInfo("Total time to fetch files, compute deltas and update model is: " + (jobEnd.getTime() - startImportingTime.getTime()));
                    }
                    aMonitor.worked(1);
                    aMonitor.done();
                    R4EUIModelController.setJobInProgress(false);
                    return Status.OK_STATUS;
                }
            };
            mainJob.setUser(true);
            mainJob.schedule();
        }
        catch (ReviewsFileStorageException e) {
            UIUtils.displayReviewsFileStorageErrorDialog(e);
        }
    }

    private TempFileContext fetchFiles(Change aChange, IRFSRegistry aLocalRepository, IProgressMonitor aMainMonitor, IProgressMonitor aSubMonitor) throws ReviewsFileStorageException, CoreException {
        R4EFileVersion baseLocalVersion = null;
        R4EFileVersion targetLocalVersion = null;
        ScmArtifact baseArt = aChange.getBase();
        if (baseArt != null) {
            aSubMonitor.subTask(FETCHING_FILE_MSG + baseArt.getPath() + " (base) from remote repository");
            baseLocalVersion = CommandUtils.copyRemoteFileToLocalRepository(this.fLock, aLocalRepository, baseArt, aMainMonitor);
        }
        aSubMonitor.worked(1);
        ScmArtifact targetArt = aChange.getTarget();
        if (targetArt != null) {
            aSubMonitor.subTask(FETCHING_FILE_MSG + targetArt.getPath() + " (target) from remote repository");
            targetLocalVersion = CommandUtils.copyRemoteFileToLocalRepository(this.fLock, aLocalRepository, targetArt, aMainMonitor);
        }
        aSubMonitor.worked(1);
        return new TempFileContext(aLocalRepository, baseLocalVersion, targetLocalVersion, CommandUtils.adaptType(aChange.getChangeType()));
    }

    private void updateFilesWithDeltas(TempFileContext aFile) throws CoreException {
        try {
            List<Diff> diffs;
            R4EDeltaCompareEditorInput input = new R4EDeltaCompareEditorInput(aFile.getTarget(), aFile.getBase());
            input.prepareCompareInput((IProgressMonitor)new NullProgressMonitor());
            DiffUtils diffUtils = new DiffUtils();
            this.fLock.lock();
            try {
                diffs = diffUtils.doDiff(false, true, input);
            }
            finally {
                this.fLock.unlock();
            }
            for (Diff diff : diffs) {
                R4EUITextPosition position = CommandUtils.getPosition(diff.getPosition('L').getOffset(), diff.getPosition('L').getLength(), diff.getDocument('L'));
                if (position == null || diff.getKind() == 0) continue;
                aFile.getPositions().add(position);
            }
        }
        catch (InvocationTargetException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.toString(), (Throwable)e));
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.mylyn.reviews.r4e.ui", 0, e.toString(), (Throwable)e));
        }
    }

    private void addFileToModel(R4EUIReviewItem aUiReviewItem, TempFileContext aFile, IProgressMonitor aMonitor) {
        try {
            String addedFilename = aFile.getTarget() != null ? aFile.getTarget().getName() : (aFile.getBase() != null ? aFile.getBase().getName() : "");
            aMonitor.subTask("Adding file " + addedFilename + " to R4E model");
            R4EUIFileContext uiFileContext = aUiReviewItem.createFileContext(aFile.getBase(), aFile.getTarget(), aFile.getType());
            for (IR4EUIPosition position : aFile.getPositions()) {
                R4EUIDeltaContainer deltaContainer = (R4EUIDeltaContainer)uiFileContext.getContentsContainerElement();
                deltaContainer.createDelta((R4EUITextPosition)position);
            }
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        aMonitor.worked(1);
    }

    class JobQueueSchedulingRule
    implements ISchedulingRule {
        JobQueueSchedulingRule() {
        }

        public boolean contains(ISchedulingRule aRule) {
            return aRule.equals(this);
        }

        public boolean isConflicting(ISchedulingRule aRule) {
            if (aRule.equals(this)) {
                return true;
            }
            if (!(aRule instanceof JobQueueSchedulingRule)) {
                return false;
            }
            return FindReviewItemsHandler.this.fRunningJobs.intValue() >= 20;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TempFileContext {
        private final R4EFileVersion fBase;
        private final R4EFileVersion fTarget;
        private final R4EContextType fType;
        private final List<IR4EUIPosition> fPositions;

        TempFileContext(IRFSRegistry aRepository, R4EFileVersion aBase, R4EFileVersion aTarget, R4EContextType aType) {
            IFileRevision fileRev;
            this.fBase = aBase;
            if (this.fBase != null && aRepository != null) {
                try {
                    fileRev = aRepository.getIFileRevision(null, this.fBase);
                    this.fBase.setFileRevision(fileRev);
                }
                catch (ReviewsFileStorageException e) {
                    R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
            this.fTarget = aTarget;
            if (this.fTarget != null && aRepository != null) {
                try {
                    fileRev = aRepository.getIFileRevision(null, this.fTarget);
                    this.fTarget.setFileRevision(fileRev);
                }
                catch (ReviewsFileStorageException e) {
                    R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
            this.fType = aType;
            this.fPositions = new ArrayList<IR4EUIPosition>();
        }

        public R4EFileVersion getBase() {
            return this.fBase;
        }

        public R4EFileVersion getTarget() {
            return this.fTarget;
        }

        public R4EContextType getType() {
            return this.fType;
        }

        public List<IR4EUIPosition> getPositions() {
            return this.fPositions;
        }
    }
}

