/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileTypedElement;

public class R4EFileContextNode
extends DiffNode {
    private IPath fPath;
    private String fName;

    public R4EFileContextNode(ITypedElement aTarget, ITypedElement aBase) {
        super(0);
        String basePath;
        R4EFileVersion targetVersion = null;
        R4EFileVersion baseVersion = null;
        targetVersion = aTarget instanceof R4EFileTypedElement ? ((R4EFileTypedElement)aTarget).getFileVersion() : ((R4EFileRevisionTypedElement)aTarget).getFileVersion();
        baseVersion = aBase instanceof R4EFileTypedElement ? ((R4EFileTypedElement)aBase).getFileVersion() : ((R4EFileRevisionTypedElement)aBase).getFileVersion();
        String targetPath = targetVersion.getRepositoryPath();
        int kind = 3;
        if (targetPath == null) {
            targetPath = baseVersion.getRepositoryPath();
            kind = 1;
        }
        if ((basePath = baseVersion.getRepositoryPath()) == null) {
            basePath = targetPath;
            kind = 2;
        }
        if (targetPath.equals("/COMMIT_MSG")) {
            kind = 0;
        }
        this.setLeft(aTarget);
        this.setRight(aBase);
        this.setKind(kind);
        IPath path = Path.fromPortableString((String)targetPath);
        this.setPath(path);
        this.setName(path.lastSegment());
    }

    public IPath getPath() {
        return this.fPath;
    }

    public void setPath(IPath path) {
        this.fPath = path;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }
}

