/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.text.MessageFormat;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareContentViewerSwitchingPane;
import org.eclipse.compare.internal.CompareEditorInputNavigator;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationModel;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotationSupport;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.commands.R4EAnnotationContributionItems;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotationModel;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileContextNode;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class R4ECompareEditorInput
extends SaveableCompareEditorInput {
    private final CompareConfiguration fConfig;
    private final ITypedElement fAncestor;
    private final ITypedElement fLeft;
    private final ITypedElement fRight;
    private IReviewAnnotationSupport fAnnotationSupport = null;

    public R4ECompareEditorInput(CompareConfiguration aConfig, ITypedElement aAncestor, ITypedElement aLeft, ITypedElement aRight) {
        super(aConfig, null);
        this.fConfig = aConfig;
        this.fAncestor = aAncestor;
        this.fLeft = aLeft;
        this.fRight = aRight;
    }

    public ITypedElement getAncestorElement() {
        return this.fAncestor;
    }

    public ITypedElement getLeftElement() {
        return this.fLeft;
    }

    public ITypedElement getRightElement() {
        return this.fRight;
    }

    public void prepareCompareInputNoEditor() {
        Differencer differencer = new Differencer();
        if (this.fLeft == null && this.fRight == null) {
            R4EUIPlugin.Ftracer.traceWarning("Nothing to compare, both sides are NULL");
        } else {
            differencer.findDifferences(false, null, null, (Object)this.fAncestor, (Object)this.fLeft, (Object)this.fRight);
        }
    }

    public String getToolTipText() {
        if (this.fLeft != null && this.fRight != null) {
            String format = null;
            StringBuilder leftLabel = null;
            if (this.fLeft != null) {
                leftLabel = new StringBuilder("Target: " + this.fLeft.getName());
                if (this.fLeft instanceof R4EFileRevisionTypedElement) {
                    leftLabel.append("_" + ((R4EFileRevisionTypedElement)this.fLeft).getFileVersion().getVersionID());
                }
                this.fConfig.setLeftLabel(leftLabel.toString());
            }
            StringBuilder rightLabel = null;
            if (this.fRight != null) {
                rightLabel = new StringBuilder("Base: " + this.fRight.getName());
                if (this.fRight instanceof R4EFileRevisionTypedElement) {
                    rightLabel.append("_" + ((R4EFileRevisionTypedElement)this.fRight).getFileVersion().getVersionID());
                }
                this.fConfig.setRightLabel(rightLabel.toString());
            }
            if (this.fAncestor != null) {
                format = CompareUI.getResourceBundle().getString("ResourceCompare.threeWay.tooltip");
                return MessageFormat.format(format, "", leftLabel, rightLabel);
            }
            format = CompareUI.getResourceBundle().getString("ResourceCompare.twoWay.tooltip");
            return MessageFormat.format(format, leftLabel, rightLabel);
        }
        return super.getToolTipText();
    }

    public Object getAdapter(Class aAdapter) {
        if (IFile.class.equals((Object)aAdapter)) {
            if (this.getWorkspaceElement() != null) {
                return this.getWorkspaceElement().getResource();
            }
            return null;
        }
        return super.getAdapter(aAdapter);
    }

    protected void fireInputChange() {
    }

    private R4EFileTypedElement getWorkspaceElement() {
        if (this.fLeft instanceof R4EFileTypedElement) {
            return (R4EFileTypedElement)this.fLeft;
        }
        return null;
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor aMonitor) {
        if (aMonitor != null) {
            aMonitor.beginTask("R4E Compare", -1);
        }
        this.initLabels();
        return new R4EFileContextNode(this.fLeft, this.fRight);
    }

    private void initLabels() {
        if (this.fLeft != null) {
            StringBuilder leftLabel = new StringBuilder("Target: " + this.fLeft.getName());
            if (this.fLeft instanceof R4EFileRevisionTypedElement) {
                leftLabel.append(" " + ((R4EFileRevisionTypedElement)this.fLeft).getFileVersion().getVersionID());
            }
            this.fConfig.setLeftLabel(leftLabel.toString());
        }
        if (this.fRight != null) {
            StringBuilder rightLabel = new StringBuilder("Base: " + this.fRight.getName());
            if (this.fRight instanceof R4EFileRevisionTypedElement) {
                rightLabel.append("_" + ((R4EFileRevisionTypedElement)this.fRight).getFileVersion().getVersionID());
            }
            this.fConfig.setRightLabel(rightLabel.toString());
        }
        if (this.fAncestor != null) {
            this.fConfig.setAncestorLabel(this.fAncestor.getName());
        }
    }

    public Control createContents(Composite aParent) {
        Control control = super.createContents(aParent);
        UIUtils.selectElementInEditor(this);
        if (this.fAnnotationSupport != null) {
            this.fAnnotationSupport.getTargetAnnotationModel().refreshAnnotations();
        }
        return control;
    }

    public Viewer findContentViewer(Viewer aOldViewer, ICompareInput aInput, Composite aParent) {
        ISelection selection;
        Viewer contentViewer = super.findContentViewer(aOldViewer, aInput, aParent);
        if (aInput instanceof R4EFileContextNode && (selection = R4EUIModelController.getNavigatorView().getTreeViewer().getSelection()) instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof R4EUIFileContext) {
                this.fAnnotationSupport = UIUtils.getCompareAnnotationSupport(contentViewer, element);
                this.insertAnnotationNavigationCommands((IToolBarManager)CompareViewerPane.getToolBarManager((Composite)aParent), this.fAnnotationSupport);
            } else if (element instanceof R4EUIContent || element instanceof R4EUIAnomalyBasic) {
                IReviewAnnotationSupport support = UIUtils.getCompareAnnotationSupport(contentViewer, ((IR4EUIModelElement)element).getParent().getParent());
                this.fAnnotationSupport = UIUtils.getCompareAnnotationSupport(contentViewer, element);
                this.insertAnnotationNavigationCommands((IToolBarManager)CompareViewerPane.getToolBarManager((Composite)aParent), support);
            }
        }
        return contentViewer;
    }

    public Viewer getContentViewer() {
        ICompareNavigator navigator = this.getNavigator();
        if (navigator instanceof CompareEditorInputNavigator) {
            Object[] panes;
            Object[] objectArray = panes = ((CompareEditorInputNavigator)navigator).getPanes();
            int n = panes.length;
            int n2 = 0;
            while (n2 < n) {
                Object pane = objectArray[n2];
                if (pane instanceof CompareContentViewerSwitchingPane) {
                    return ((CompareContentViewerSwitchingPane)pane).getViewer();
                }
                ++n2;
            }
        }
        return null;
    }

    private void insertAnnotationNavigationCommands(IToolBarManager aManager, IReviewAnnotationSupport aSupport) {
        IContributionItem[] items;
        aManager.add((IContributionItem)new Separator());
        R4EAnnotationContributionItems r4eItemsManager = new R4EAnnotationContributionItems();
        IContributionItem[] iContributionItemArray = items = r4eItemsManager.getR4EContributionItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            aManager.add(item);
            ++n2;
        }
        aManager.update(true);
    }

    public boolean isAnnotationsAvailable(String aType) {
        IReviewAnnotationModel model;
        return this.fAnnotationSupport != null && (model = this.fAnnotationSupport.getTargetAnnotationModel()) != null && model.isAnnotationsAvailable(aType);
    }

    public R4EAnnotation gotoNextAnnotation(String aType) {
        IReviewAnnotationModel model;
        ITextEditor editor;
        R4EAnnotation originalAnnotation = null;
        R4EAnnotation foundAnnotation = null;
        if (this.fAnnotationSupport != null && (editor = this.fAnnotationSupport.getTargetEditor()) != null && (model = this.fAnnotationSupport.getTargetAnnotationModel()) != null) {
            ICompareNavigator navigator = ((R4ECompareEditorInput)editor.getEditorInput()).getNavigator();
            originalAnnotation = (R4EAnnotation)model.getNextAnnotation(aType);
            if (originalAnnotation != null) {
                R4EAnnotation annotation = originalAnnotation;
                do {
                    IR4EUIPosition annotationPositon;
                    if (UIUtils.selectElementInEditorPane(navigator, annotationPositon = annotation.getR4EPosition(), true)) {
                        foundAnnotation = annotation;
                        break;
                    }
                    annotation = (R4EAnnotation)model.getNextAnnotation(aType);
                } while (!originalAnnotation.getR4EPosition().isSameAs(annotation.getR4EPosition()));
            }
        }
        return foundAnnotation;
    }

    public R4EAnnotation gotoPreviousAnnotation(String aType) {
        IReviewAnnotationModel model;
        ITextEditor editor;
        R4EAnnotation originalAnnotation = null;
        R4EAnnotation foundAnnotation = null;
        if (this.fAnnotationSupport != null && (editor = this.fAnnotationSupport.getTargetEditor()) != null && (model = this.fAnnotationSupport.getTargetAnnotationModel()) != null) {
            ICompareNavigator navigator = ((R4ECompareEditorInput)editor.getEditorInput()).getNavigator();
            originalAnnotation = (R4EAnnotation)model.getPreviousAnnotation(aType);
            if (originalAnnotation != null) {
                R4EAnnotation annotation = originalAnnotation;
                do {
                    IR4EUIPosition annotationPositon;
                    if (UIUtils.selectElementInEditorPane(navigator, annotationPositon = annotation.getR4EPosition(), true)) {
                        foundAnnotation = annotation;
                        break;
                    }
                    annotation = (R4EAnnotation)model.getPreviousAnnotation(aType);
                } while (!originalAnnotation.getR4EPosition().isSameAs(annotation.getR4EPosition()));
            }
        }
        return foundAnnotation;
    }

    public R4EAnnotationModel getAnnotationModel() {
        if (this.fAnnotationSupport == null) {
            return null;
        }
        return (R4EAnnotationModel)this.fAnnotationSupport.getTargetAnnotationModel();
    }
}

