/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

public class NewLinkedAnomalyHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Adding Linked Anomaly...";

    public Object execute(ExecutionEvent event) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "R4EUI";
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                IR4EUIModelElement element;
                R4EUIModelController.setJobInProgress(true);
                monitor.beginTask(NewLinkedAnomalyHandler.COMMAND_MESSAGE, -1);
                if (!selectedElements.isEmpty() && (element = (IR4EUIModelElement)selectedElements.get(0)) instanceof R4EUIContent) {
                    R4EUIPlugin.Ftracer.traceInfo("Adding Linked Anomaly to Element " + element.getName());
                    NewLinkedAnomalyHandler.this.addLinkedAnomaly((R4EUIContent)element);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
        return null;
    }

    private void addLinkedAnomaly(R4EUIContent aElement) {
        R4EUIFileContext fileContext = (R4EUIFileContext)aElement.getParent().getParent();
        R4EUIAnomalyContainer container = fileContext.getAnomalyContainerElement();
        container.createAnomaly(fileContext, (R4EUITextPosition)aElement.getPosition(), false);
    }
}

