/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.contentmergeviewer.TokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EDeltaCompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.Diff;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.DocLineComparator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffUtils {
    public static final double TOO_LONG = 1.0E7;
    private static final String DIFF_RANGE_CATEGORY = "org.eclipse.mylyn.reviews.r4e.ui.DIFF_RANGE_CATEGORY";
    private static final boolean USE_MERGING_TOKEN_DIFF = false;
    public static final String OPTIMIZED_ALGORITHM_USED = "OPTIMIZED_ALGORITHM_USED";

    public List<Diff> doDiff(boolean aIsThreeWay, boolean aIgnoreWhitespace, R4EDeltaCompareEditorInput input) throws CoreException {
        ArrayList<Diff> changeDiffs = new ArrayList<Diff>();
        IDocument lDoc = this.getDocument(input.getTargetElement());
        IDocument rDoc = this.getDocument(input.getBaseElement());
        CompareConfiguration config = input.getCompareConfiguration();
        if (lDoc == null || rDoc == null) {
            return changeDiffs;
        }
        IDocument aDoc = null;
        Position aRegion = null;
        if (aIsThreeWay && input.getAncestorElement() != null) {
            aDoc = this.getDocument(input.getAncestorElement());
        }
        this.resetPositions(lDoc);
        this.resetPositions(rDoc);
        this.resetPositions(aDoc);
        boolean ignoreWhiteSpace = aIgnoreWhitespace;
        DocLineComparator sright = new DocLineComparator(rDoc, null, ignoreWhiteSpace);
        DocLineComparator sleft = new DocLineComparator(lDoc, null, ignoreWhiteSpace);
        DocLineComparator sancestor = null;
        if (aDoc != null) {
            sancestor = new DocLineComparator(aDoc, null, ignoreWhiteSpace);
        }
        DocLineComparator sa = sancestor;
        DocLineComparator sl = sleft;
        DocLineComparator sr = sright;
        RangeDifference[] e = RangeDifferencer.findRanges(null, (IRangeComparator)sa, (IRangeComparator)sl, (IRangeComparator)sr);
        ArrayList<Diff> newAllDiffs = new ArrayList<Diff>();
        RangeDifference[] rangeDifferenceArray = e;
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference es = rangeDifferenceArray[n2];
            int ancestorStart = 0;
            int ancestorEnd = 0;
            if (sancestor != null) {
                ancestorStart = sancestor.getTokenStart(es.ancestorStart());
                ancestorEnd = DiffUtils.getTokenEnd2(sancestor, es.ancestorStart(), es.ancestorLength());
            }
            int leftStart = sleft.getTokenStart(es.leftStart());
            int leftEnd = DiffUtils.getTokenEnd2(sleft, es.leftStart(), es.leftLength());
            int rightStart = sright.getTokenStart(es.rightStart());
            int rightEnd = DiffUtils.getTokenEnd2(sright, es.rightStart(), es.rightLength());
            Diff diff = new Diff(null, es.kind(), aDoc, aRegion, ancestorStart, ancestorEnd, lDoc, null, leftStart, leftEnd, rDoc, null, rightStart, rightEnd, aIsThreeWay, config);
            newAllDiffs.add(diff);
            if (this.isPatchHunk()) {
                if (this.useChange(diff, config)) {
                    this.recordChangeDiff(diff, changeDiffs);
                }
            } else if (ignoreWhiteSpace || this.useChange(es.kind(), config)) {
                String a = null;
                if (sancestor != null) {
                    a = this.extract2(aDoc, sancestor, es.ancestorStart(), es.ancestorLength());
                }
                String s = this.extract2(lDoc, sleft, es.leftStart(), es.leftLength());
                String d = this.extract2(rDoc, sright, es.rightStart(), es.rightLength());
                if (ignoreWhiteSpace && (a == null || a.trim().length() == 0) && s.trim().length() == 0 && d.trim().length() == 0) {
                    diff.fIsWhitespace = true;
                }
                if (this.useChange(diff, config)) {
                    this.recordChangeDiff(diff, changeDiffs);
                    if (s.length() > 0 && d.length() > 0) {
                        if (a == null && sancestor != null) {
                            a = this.extract2(aDoc, sancestor, es.ancestorStart(), es.ancestorLength());
                        }
                        this.simpleTokenDiff(diff, aDoc, a, rDoc, d, lDoc, s, aIsThreeWay, config);
                    }
                }
            }
            ++n2;
        }
        changeDiffs = newAllDiffs;
        return changeDiffs;
    }

    private IDocument getDocument(ITypedElement aElement) throws CoreException {
        ISharedDocumentAdapter adapter = null;
        IEditorInput editorInput = null;
        if (aElement instanceof R4EFileTypedElement) {
            adapter = (ISharedDocumentAdapter)((R4EFileTypedElement)aElement).getAdapter(ISharedDocumentAdapter.class);
            if (adapter != null) {
                editorInput = adapter.getDocumentKey((Object)aElement);
            }
        } else if (aElement instanceof R4EFileRevisionTypedElement) {
            adapter = (ISharedDocumentAdapter)((R4EFileRevisionTypedElement)aElement).getAdapter(ISharedDocumentAdapter.class);
            if (adapter != null) {
                editorInput = adapter.getDocumentKey((Object)aElement);
            }
        } else {
            return null;
        }
        if (adapter == null || editorInput == null) {
            return null;
        }
        IDocumentProvider provider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)editorInput);
        if (provider == null) {
            return null;
        }
        adapter.connect(provider, editorInput);
        return provider.getDocument((Object)editorInput);
    }

    private void resetPositions(IDocument doc) {
        if (doc == null) {
            return;
        }
        try {
            doc.removePositionCategory(DIFF_RANGE_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        doc.addPositionCategory(DIFF_RANGE_CATEGORY);
    }

    private static int getTokenEnd2(ITokenComparator tc, int start, int length) {
        return tc.getTokenStart(start + length);
    }

    private String extract2(IDocument doc, ITokenComparator tc, int start, int length) {
        int count = tc.getRangeCount();
        if (length > 0 && count > 0) {
            int startPos = tc.getTokenStart(start);
            int endPos = 1 == length ? startPos + tc.getTokenLength(start) : tc.getTokenStart(start + length);
            try {
                return doc.get(startPos, endPos - startPos);
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    private boolean isPatchHunk() {
        return false;
    }

    public boolean useChange(Diff diff, CompareConfiguration aConfig) {
        if (diff.fIsWhitespace) {
            return false;
        }
        int kind = diff.getKind();
        return this.useChange(kind, aConfig);
    }

    private boolean useChange(int kind, CompareConfiguration aConfig) {
        if (kind == 0) {
            return false;
        }
        if (aConfig.isChangeIgnored(kind)) {
            return false;
        }
        return kind != 4;
    }

    private void recordChangeDiff(Diff diff, List<Diff> aChangeDiffs) {
        aChangeDiffs.add(diff);
    }

    private void mergingTokenDiff(Diff baseDiff, IDocument ancestorDoc, String a, IDocument rightDoc, String d, IDocument leftDoc, String s, boolean aIsThreeWay, CompareConfiguration aConfig) {
        ITokenComparator sa = null;
        int ancestorStart = 0;
        if (ancestorDoc != null) {
            sa = this.createTokenComparator(a);
            ancestorStart = baseDiff.fAncestorPos.getOffset();
        }
        int rightStart = baseDiff.fRightPos.getOffset();
        ITokenComparator sm = this.createTokenComparator(d);
        int leftStart = baseDiff.fLeftPos.getOffset();
        ITokenComparator sy = this.createTokenComparator(s);
        RangeDifference[] r = RangeDifferencer.findRanges((IRangeComparator)sa, (IRangeComparator)sy, (IRangeComparator)sm);
        int i = 0;
        while (i < r.length) {
            RangeDifference es = r[i];
            int start = i;
            int leftLine = -1;
            int rightLine = -1;
            try {
                leftLine = leftDoc.getLineOfOffset(leftStart + sy.getTokenStart(es.leftStart()));
                rightLine = rightDoc.getLineOfOffset(rightStart + sm.getTokenStart(es.rightStart()));
            }
            catch (BadLocationException badLocationException) {}
            ++i;
            while (i < r.length) {
                es = r[i];
                try {
                    if (leftLine != leftDoc.getLineOfOffset(leftStart + sy.getTokenStart(es.leftStart())) || rightLine != rightDoc.getLineOfOffset(rightStart + sm.getTokenStart(es.rightStart()))) {
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {}
                ++i;
            }
            int end = i;
            RangeDifference first = null;
            int ii = start;
            while (ii < end) {
                es = r[ii];
                if (this.useChange(es.kind(), aConfig)) {
                    first = es;
                    break;
                }
                ++ii;
            }
            RangeDifference last = null;
            int ii2 = end - 1;
            while (ii2 >= start) {
                es = r[ii2];
                if (this.useChange(es.kind(), aConfig)) {
                    last = es;
                    break;
                }
                --ii2;
            }
            if (first != null && last != null) {
                int ancestorStart2 = 0;
                int ancestorEnd2 = 0;
                if (ancestorDoc != null && sa != null) {
                    ancestorStart2 = ancestorStart + sa.getTokenStart(first.ancestorStart());
                    ancestorEnd2 = ancestorStart + this.getTokenEnd(sa, last.ancestorStart(), last.ancestorLength());
                }
                int leftStart2 = leftStart + sy.getTokenStart(first.leftStart());
                int leftEnd2 = leftStart + this.getTokenEnd(sy, last.leftStart(), last.leftLength());
                int rightStart2 = rightStart + sm.getTokenStart(first.rightStart());
                int rightEnd2 = rightStart + this.getTokenEnd(sm, last.rightStart(), last.rightLength());
                Diff diff = new Diff(baseDiff, first.kind(), ancestorDoc, null, ancestorStart2, ancestorEnd2, leftDoc, null, leftStart2, leftEnd2, rightDoc, null, rightStart2, rightEnd2, aIsThreeWay, aConfig);
                diff.fIsToken = true;
                baseDiff.add(diff);
            }
            ++i;
        }
    }

    private void simpleTokenDiff(Diff baseDiff, IDocument ancestorDoc, String a, IDocument rightDoc, String d, IDocument leftDoc, String s, boolean aIsThreeWay, CompareConfiguration aConfig) {
        RangeDifference[] e;
        int ancestorStart = 0;
        ITokenComparator sa = null;
        if (ancestorDoc != null) {
            ancestorStart = baseDiff.fAncestorPos.getOffset();
            sa = this.createTokenComparator(a);
        }
        int rightStart = baseDiff.fRightPos.getOffset();
        ITokenComparator sm = this.createTokenComparator(d);
        int leftStart = baseDiff.fLeftPos.getOffset();
        ITokenComparator sy = this.createTokenComparator(s);
        RangeDifference[] rangeDifferenceArray = e = RangeDifferencer.findRanges((IRangeComparator)sa, (IRangeComparator)sy, (IRangeComparator)sm);
        int n = e.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference es = rangeDifferenceArray[n2];
            int kind = es.kind();
            if (kind != 0) {
                int ancestorStart2 = ancestorStart;
                int ancestorEnd2 = ancestorStart;
                if (ancestorDoc != null && sa != null) {
                    ancestorStart2 += sa.getTokenStart(es.ancestorStart());
                    ancestorEnd2 += this.getTokenEnd(sa, es.ancestorStart(), es.ancestorLength());
                }
                int leftStart2 = leftStart + sy.getTokenStart(es.leftStart());
                int leftEnd2 = leftStart + this.getTokenEnd(sy, es.leftStart(), es.leftLength());
                int rightStart2 = rightStart + sm.getTokenStart(es.rightStart());
                int rightEnd2 = rightStart + this.getTokenEnd(sm, es.rightStart(), es.rightLength());
                Diff diff = new Diff(baseDiff, kind, ancestorDoc, null, ancestorStart2, ancestorEnd2, leftDoc, null, leftStart2, leftEnd2, rightDoc, null, rightStart2, rightEnd2, aIsThreeWay, aConfig);
                int leftS = baseDiff.fLeftPos.offset;
                int leftE = baseDiff.fLeftPos.offset + baseDiff.fLeftPos.length;
                int rightS = baseDiff.fRightPos.offset;
                int rightE = baseDiff.fRightPos.offset + baseDiff.fRightPos.length;
                if (leftS != leftStart2 || leftE != leftEnd2 || rightS != rightStart2 || rightE != rightEnd2) {
                    diff.fIsToken = true;
                    baseDiff.add(diff);
                }
            }
            ++n2;
        }
    }

    private ITokenComparator createTokenComparator(String s) {
        return new TokenComparator(s);
    }

    private int getTokenEnd(ITokenComparator tc, int start, int count) {
        if (count <= 0) {
            return tc.getTokenStart(start);
        }
        int index = start + count - 1;
        return tc.getTokenStart(index) + tc.getTokenLength(index);
    }
}

