/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRule;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleClass;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRuleRank;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IAnomalyInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.ICalendarDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EInputValidator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRule;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleArea;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleViolation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorContentProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorLabelProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorView;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class NewAnomalyInputDialog
extends FormDialog
implements IAnomalyInputDialog {
    private static final String ADD_ANOMALY_DIALOG_TITLE = "Enter Anomaly Details";
    private static final String BASIC_PARAMS_HEADER_MSG = "Enter the mandatory basic parameters for this anomaly";
    private static final String EXTRA_PARAMS_HEADER_MSG = "Enter the optional extra parameters for this anomaly";
    private static final String ADD_RULE_DIALOG_VALUE = "Rule Tree (Take note that the Anomaly will be created with values taken from the selected Design Rule)";
    private static final int DEFAULT_ELEMENT_COLUMN_WIDTH = 150;
    private static final int DEFAULT_TREE_COLUMN_WIDTH = 100;
    private String fAnomalyTitleValue = "";
    protected Text fAnomalyTitleInputTextField = null;
    private String fAnomalyDescriptionValue = "";
    protected Text fAnomalyDescriptionInputTextField;
    private R4EDesignRuleClass fAnomalyClassValue = null;
    protected CCombo fAnomalyClass = null;
    private R4EDesignRuleRank fAnomalyRankValue = null;
    protected CCombo fAnomalyRank = null;
    protected Text fDateText = null;
    private Date fAnomalyDueDateValue = null;
    protected TreeViewer fRuleTreeViewer = null;
    private R4EUIRule fRuleReferenceValue = null;
    private final IInputValidator fValidator;
    protected CCombo fAssignedToCombo = null;
    private String fAssignedToParticipant = null;
    private final List<R4EUIRuleSet> fOpenRuleSets = new ArrayList<R4EUIRuleSet>();
    R4EUIRule fSelectedRule = null;
    private String fRuleId = null;

    public NewAnomalyInputDialog(Shell aParentShell) {
        super(aParentShell);
        this.setBlockOnOpen(false);
        this.fValidator = new R4EInputValidator();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IStructuredSelection selection;
            String validateResult = this.validateEmptyInput(this.fAnomalyTitleInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Anomaly Title", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fAnomalyTitleValue = this.fAnomalyTitleInputTextField.getText().trim();
            validateResult = this.validateEmptyInput(this.fAnomalyDescriptionInputTextField);
            if (validateResult != null) {
                ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "No input given for Anomaly Comment", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                dialog.open();
                return;
            }
            this.fAnomalyDescriptionValue = this.fAnomalyDescriptionInputTextField.getText().trim();
            this.fRuleReferenceValue = null;
            if (this.fRuleTreeViewer.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)this.fRuleTreeViewer.getSelection()) != null) {
                this.fRuleReferenceValue = (R4EUIRule)selection.getFirstElement();
            }
            this.fAnomalyRankValue = UIUtils.getRankFromString(this.fAnomalyRank.getText());
            this.fAnomalyClassValue = UIUtils.getClassFromString(this.fAnomalyClass.getText());
            this.fAssignedToParticipant = this.fAssignedToCombo.getText();
        } else {
            this.fAnomalyTitleValue = null;
            this.fAnomalyDescriptionValue = null;
            this.fRuleReferenceValue = null;
            this.fAnomalyRankValue = null;
            this.fAnomalyClassValue = null;
            this.fAnomalyDueDateValue = null;
            this.fAssignedToParticipant = null;
        }
        for (R4EUIRuleSet ruleset : this.fOpenRuleSets) {
            ruleset.close();
        }
        ReviewNavigatorView view = R4EUIModelController.getNavigatorView();
        if (view != null) {
            view.getTreeViewer().refresh();
        }
        this.fOpenRuleSets.clear();
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADD_ANOMALY_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        GridData textGridData = null;
        Section basicSection = toolkit.createSection(composite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, false);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText("Basic Parameters");
        basicSection.setDescription(BASIC_PARAMS_HEADER_MSG);
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                NewAnomalyInputDialog.this.getShell().setSize(NewAnomalyInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = toolkit.createComposite((Composite)basicSection);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        Label label = toolkit.createLabel(basicSectionClient, "Anomaly Title: ");
        label.setToolTipText("A Title that Identifies this Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyTitleInputTextField = toolkit.createText(basicSectionClient, "", 2052);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAnomalyTitleInputTextField.setToolTipText("A Title that Identifies this Anomaly");
        this.fAnomalyTitleInputTextField.setLayoutData((Object)textGridData);
        this.fAnomalyTitleInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewAnomalyInputDialog.this.fAnomalyTitleInputTextField.getText().length() > 0 && NewAnomalyInputDialog.this.fAnomalyDescriptionInputTextField.getText().length() > 0) {
                    NewAnomalyInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    NewAnomalyInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        label = toolkit.createLabel(basicSectionClient, "Anomaly Description: ");
        label.setToolTipText("A Detailed Description of the Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyDescriptionInputTextField = toolkit.createText(basicSectionClient, "", 2562);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fAnomalyTitleInputTextField.getLineHeight() * 7;
        this.fAnomalyDescriptionInputTextField.setToolTipText("A Detailed Description of the Anomaly");
        this.fAnomalyDescriptionInputTextField.setLayoutData((Object)textGridData);
        this.fAnomalyDescriptionInputTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewAnomalyInputDialog.this.fAnomalyTitleInputTextField.getText().length() > 0 && NewAnomalyInputDialog.this.fAnomalyDescriptionInputTextField.getText().length() > 0) {
                    NewAnomalyInputDialog.this.getButton(0).setEnabled(true);
                } else {
                    NewAnomalyInputDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        Section extraSection = toolkit.createSection(composite, 386);
        GridData extraSectionGridData = new GridData(4, 4, true, true);
        extraSectionGridData.horizontalSpan = 4;
        extraSection.setLayoutData((Object)extraSectionGridData);
        extraSection.setText("Extra Parameters");
        extraSection.setDescription(EXTRA_PARAMS_HEADER_MSG);
        extraSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                NewAnomalyInputDialog.this.getShell().setSize(NewAnomalyInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite extraSectionClient = toolkit.createComposite((Composite)extraSection);
        extraSectionClient.setLayout((Layout)layout);
        extraSection.setClient((Control)extraSectionClient);
        label = toolkit.createLabel(extraSectionClient, "Class: ");
        label.setToolTipText("The Class of this Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyClass = new CCombo(extraSectionClient, 2056);
        this.fAnomalyClass.setItems(UIUtils.getClasses());
        int count = UIUtils.getClasses().length;
        this.fAnomalyClass.setVisibleItemCount(count);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAnomalyClass.setToolTipText("The Class of this Anomaly");
        this.fAnomalyClass.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(extraSectionClient, "Rank: ");
        label.setToolTipText("The Rank (or Severity) of this Anomaly");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fAnomalyRank = new CCombo(extraSectionClient, 2056);
        this.fAnomalyRank.setItems(UIUtils.getRanks());
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAnomalyRank.setToolTipText("The Class of this Anomaly");
        this.fAnomalyRank.setLayoutData((Object)textGridData);
        label = toolkit.createLabel(extraSectionClient, "Assigned to: ");
        textGridData = new GridData(4, 4, false, false);
        textGridData.horizontalSpan = 1;
        label.setLayoutData((Object)textGridData);
        this.fAssignedToCombo = new CCombo(extraSectionClient, 2056);
        String[] participants = R4EUIModelController.getActiveReview().getParticipantIDs().toArray(new String[R4EUIModelController.getActiveReview().getParticipantIDs().size()]);
        this.fAssignedToCombo.removeAll();
        this.fAssignedToCombo.add("");
        String[] stringArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            String participant = stringArray[n2];
            this.fAssignedToCombo.add(participant);
            ++n2;
        }
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fAssignedToCombo.setToolTipText("Participant assigned to Review this element.");
        this.fAssignedToCombo.setLayoutData((Object)textGridData);
        toolkit.setBorderStyle(0);
        label = toolkit.createLabel(extraSectionClient, "Due Date: ");
        textGridData = new GridData(4, 0x1000000, false, false);
        textGridData.horizontalSpan = 1;
        label.setLayoutData((Object)textGridData);
        Composite dateComposite = toolkit.createComposite(extraSectionClient);
        textGridData = new GridData(4, 0x1000000, true, true);
        textGridData.horizontalSpan = 3;
        dateComposite.setToolTipText("The Target Date to Address this Anomaly");
        dateComposite.setLayoutData((Object)textGridData);
        dateComposite.setLayout((Layout)new GridLayout(2, false));
        this.fDateText = toolkit.createText(dateComposite, "", 8);
        this.fDateText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fDateText.setEditable(false);
        toolkit.setBorderStyle(2048);
        Composite dateButtonComposite = toolkit.createComposite(dateComposite);
        textGridData = new GridData(4, 0x1000000, true, true);
        textGridData.horizontalSpan = 1;
        dateButtonComposite.setToolTipText("The Target Date to Address this Anomaly");
        dateButtonComposite.setLayoutData((Object)textGridData);
        dateButtonComposite.setLayout((Layout)new GridLayout(2, false));
        Button calendarButton = toolkit.createButton(dateButtonComposite, "Update...", 0);
        calendarButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        calendarButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ICalendarDialog dialog = R4EUIDialogFactory.getInstance().getCalendarDialog();
                int result = dialog.open();
                if (result == 0) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
                    Date dialogDate = dialog.getDate();
                    String dialogDateStr = dateFormat.format(dialogDate);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(new Date());
                    cal.add(6, -1);
                    if (dialogDate.after(cal.getTime())) {
                        NewAnomalyInputDialog.this.fDateText.setText(dialogDateStr);
                        NewAnomalyInputDialog.this.fAnomalyDueDateValue = dialogDate;
                    } else {
                        UIUtils.displayPastDateError(dialogDate, dialogDateStr);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button clearButton = toolkit.createButton(dateButtonComposite, "Clear", 0);
        clearButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        clearButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewAnomalyInputDialog.this.fDateText.setText("");
                NewAnomalyInputDialog.this.fAnomalyDueDateValue = null;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = toolkit.createLabel(extraSectionClient, ADD_RULE_DIALOG_VALUE);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 4;
        label.setLayoutData((Object)textGridData);
        this.fRuleTreeViewer = new TreeViewer(extraSectionClient, 68360);
        this.fRuleTreeViewer.setContentProvider((IContentProvider)new ReviewNavigatorContentProvider());
        this.fRuleTreeViewer.getTree().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fRuleTreeViewer, (int)2);
        TreeViewerColumn elementColumn = new TreeViewerColumn(this.fRuleTreeViewer, 0);
        elementColumn.getColumn().setText("Rule Tree");
        elementColumn.getColumn().setWidth(150);
        elementColumn.setLabelProvider((CellLabelProvider)new ReviewNavigatorLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getDescription();
                }
                return null;
            }

            public void update(ViewerCell cell) {
                IR4EUIModelElement element = (IR4EUIModelElement)cell.getElement();
                if (element instanceof R4EUIRuleSet && !element.isOpen()) {
                    cell.setForeground(NewAnomalyInputDialog.this.getShell().getDisplay().getSystemColor(3));
                } else {
                    cell.setForeground(NewAnomalyInputDialog.this.getShell().getDisplay().getSystemColor(2));
                }
                cell.setText(element.getName());
                cell.setImage(element.getImage(element.getImageLocation()));
            }
        });
        TreeViewerColumn titleColumn = new TreeViewerColumn(this.fRuleTreeViewer, 0);
        titleColumn.getColumn().setText("Title: ");
        titleColumn.getColumn().setWidth(100);
        titleColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getTitle();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getDescription();
                }
                return null;
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 250;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 10000;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof R4EUIRule) {
                    cell.setText(((R4EUIRule)element).getRule().getTitle());
                } else {
                    cell.setText(null);
                }
            }
        });
        TreeViewerColumn classColumn = new TreeViewerColumn(this.fRuleTreeViewer, 0);
        classColumn.getColumn().setText("Class: ");
        classColumn.getColumn().setWidth(100);
        classColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof R4EUIRule) {
                    return UIUtils.getClassStr(((R4EUIRule)element).getRule().getClass_());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getDescription();
                }
                return null;
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 250;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 10000;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof R4EUIRule) {
                    cell.setText(UIUtils.getClassStr(((R4EUIRule)element).getRule().getClass_()));
                } else {
                    cell.setText(null);
                }
            }
        });
        TreeViewerColumn rankColumn = new TreeViewerColumn(this.fRuleTreeViewer, 0);
        rankColumn.getColumn().setText("Rank: ");
        rankColumn.getColumn().setWidth(100);
        rankColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof R4EUIRule) {
                    return UIUtils.getRankStr(((R4EUIRule)element).getRule().getRank());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof R4EUIRule) {
                    return ((R4EUIRule)element).getRule().getDescription();
                }
                return null;
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 250;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 10000;
            }

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof R4EUIRule) {
                    cell.setText(UIUtils.getRankStr(((R4EUIRule)element).getRule().getRank()));
                } else {
                    cell.setText(null);
                }
            }
        });
        this.fRuleTreeViewer.setInput((Object)R4EUIModelController.getRootElement());
        this.fRuleTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof R4EUIRuleSet || element instanceof R4EUIRuleArea || element instanceof R4EUIRuleViolation || element instanceof R4EUIRule) {
                    IR4EUIModelElement parentRuleSetElement = (IR4EUIModelElement)element;
                    while (!(parentRuleSetElement instanceof R4EUIRuleSet) && parentRuleSetElement.getParent() != null) {
                        if (!parentRuleSetElement.isEnabled()) {
                            return false;
                        }
                        parentRuleSetElement = parentRuleSetElement.getParent();
                    }
                    if (((R4EUIReviewGroup)R4EUIModelController.getActiveReview().getParent()).getRuleSets().contains(parentRuleSetElement)) {
                        if (!parentRuleSetElement.isOpen()) {
                            try {
                                ((R4EUIRuleSet)parentRuleSetElement).openReadOnly();
                                NewAnomalyInputDialog.this.fOpenRuleSets.add((R4EUIRuleSet)parentRuleSetElement);
                            }
                            catch (ResourceHandlingException e) {
                                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                            }
                            catch (CompatibilityException e) {
                                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
                            }
                        }
                        return true;
                    }
                }
                return false;
            }
        });
        this.fRuleTreeViewer.expandAll();
        this.fRuleTreeViewer.refresh();
        textGridData = new GridData(4, 4, true, true);
        textGridData.horizontalSpan = 4;
        this.fRuleTreeViewer.getTree().setLayoutData((Object)textGridData);
        this.fRuleTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    R4EUIRule rule;
                    if (((IStructuredSelection)event.getSelection()).getFirstElement() == null) {
                        return;
                    }
                    if (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof R4EUIRule && !(rule = (R4EUIRule)((IStructuredSelection)event.getSelection()).getFirstElement()).equals(NewAnomalyInputDialog.this.fSelectedRule)) {
                        NewAnomalyInputDialog.this.fAnomalyTitleInputTextField.setText(rule.getRule().getTitle());
                        NewAnomalyInputDialog.this.fAnomalyDescriptionInputTextField.setText(rule.getRule().getDescription());
                        NewAnomalyInputDialog.this.fAnomalyClass.select(rule.getRule().getClass_().getValue());
                        NewAnomalyInputDialog.this.fAnomalyRank.select(rule.getRule().getRank().getValue());
                        NewAnomalyInputDialog.this.fAnomalyClass.setEnabled(false);
                        NewAnomalyInputDialog.this.fAnomalyRank.setEnabled(false);
                        NewAnomalyInputDialog.this.fAnomalyTitleInputTextField.setEnabled(false);
                        NewAnomalyInputDialog.this.fSelectedRule = rule;
                        NewAnomalyInputDialog.this.fRuleId = NewAnomalyInputDialog.this.buildRuleId();
                        return;
                    }
                }
                NewAnomalyInputDialog.this.fRuleTreeViewer.setSelection(null);
                NewAnomalyInputDialog.this.fAnomalyClass.setEnabled(true);
                NewAnomalyInputDialog.this.fAnomalyRank.setEnabled(true);
                NewAnomalyInputDialog.this.fAnomalyTitleInputTextField.setEnabled(true);
                NewAnomalyInputDialog.this.fSelectedRule = null;
            }
        });
        this.fAnomalyTitleInputTextField.setFocus();
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected boolean isResizable() {
        return true;
    }

    public String getAnomalyTitleValue() {
        return this.fAnomalyTitleValue;
    }

    public String getAnomalyDescriptionValue() {
        return this.fAnomalyDescriptionValue;
    }

    public R4EDesignRule getRuleReferenceValue() {
        R4EDesignRule rule = null;
        if (this.fRuleReferenceValue != null) {
            rule = this.fRuleReferenceValue.getRule();
        }
        return rule;
    }

    private String validateEmptyInput(Text aText) {
        return this.fValidator.isValid(aText.getText());
    }

    protected void setShellStyle(int newShellStyle) {
        int newstyle = newShellStyle & 0xFFFEFFFF;
        super.setShellStyle(newstyle |= 0);
    }

    public int open() {
        super.open();
        this.pumpMessages();
        return super.getReturnCode();
    }

    protected void pumpMessages() {
        Shell sh = this.getShell();
        Display disp = sh.getDisplay();
        while (!sh.isDisposed()) {
            if (disp.readAndDispatch()) continue;
            disp.sleep();
        }
        disp.update();
    }

    public void setClass_(R4EDesignRuleClass aClass) {
        this.fAnomalyClassValue = aClass;
        if (this.fAnomalyClassValue != null) {
            this.fAnomalyClass.setText(UIUtils.getClassStr(this.fAnomalyClassValue));
        }
    }

    public R4EDesignRuleClass getClass_() {
        return this.fAnomalyClassValue;
    }

    public void setRank(R4EDesignRuleRank aRank) {
        this.fAnomalyRankValue = aRank;
        if (this.fAnomalyRankValue != null) {
            this.fAnomalyRank.setText(UIUtils.getRankStr(this.fAnomalyRankValue));
        }
    }

    public R4EDesignRuleRank getRank() {
        return this.fAnomalyRankValue;
    }

    public void setDueDate(Date aDate) {
        this.fAnomalyDueDateValue = aDate;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd");
        if (this.fAnomalyDueDateValue != null) {
            this.fDateText.setText(dateFormat.format(this.fAnomalyDueDateValue));
        }
    }

    public Date getDueDate() {
        return this.fAnomalyDueDateValue;
    }

    public void setTitle(String aTitle) {
        this.fAnomalyTitleInputTextField.setText(aTitle);
    }

    public void setDescription(String aDescription) {
        this.fAnomalyDescriptionInputTextField.setText(aDescription);
    }

    public void setRuleID(String aId) {
        List<R4EUIRuleSet> ruleSets = R4EUIModelController.getRootElement().getRuleSets();
        String ruleId = null;
        String ruleViolation = null;
        String ruleArea = null;
        String ruleContainer = null;
        this.getAnomalyTitleValue();
        if (aId != null) {
            String[] ruleArray = aId.split("/");
            int size = ruleArray.length;
            if (aId.length() == 0) {
                return;
            }
            ruleId = ruleArray[size - 1];
            if (size > 1) {
                ruleViolation = ruleArray[size - 2];
            }
            if (size > 2) {
                ruleArea = ruleArray[size - 3];
            }
            if (size > 3) {
                ruleContainer = ruleArray[size - 4];
            }
        } else if (aId == null) {
            return;
        }
        for (R4EUIRuleSet ruleSet : ruleSets) {
            if (!ruleSet.getName().equals(ruleContainer) && ruleContainer != null) continue;
            IR4EUIModelElement[] iR4EUIModelElementArray = ruleSet.getChildren();
            int n = iR4EUIModelElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IR4EUIModelElement area = iR4EUIModelElementArray[n2];
                if (area.getName().equals(ruleArea) || ruleArea == null) {
                    IR4EUIModelElement[] iR4EUIModelElementArray2 = area.getChildren();
                    int n3 = iR4EUIModelElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IR4EUIModelElement violation = iR4EUIModelElementArray2[n4];
                        if (violation.getName().equals(ruleViolation) || ruleViolation == null) {
                            IR4EUIModelElement[] iR4EUIModelElementArray3 = violation.getChildren();
                            int n5 = iR4EUIModelElementArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IR4EUIModelElement rule = iR4EUIModelElementArray3[n6];
                                if (((R4EUIRule)rule).getRule().getId().equals(ruleId)) {
                                    this.fRuleTreeViewer.setSelection((ISelection)new StructuredSelection((Object)rule), true);
                                    return;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private String buildRuleId() {
        String ruleId = this.fSelectedRule.getName();
        String ruleViolation = this.fSelectedRule.getParent().getName();
        String ruleArea = this.fSelectedRule.getParent().getParent().getName();
        String ruleSet = this.fSelectedRule.getParent().getParent().getParent().getName();
        StringBuilder sb = new StringBuilder();
        sb.append(ruleSet);
        sb.append("/");
        sb.append(ruleArea);
        sb.append("/");
        sb.append(ruleViolation);
        sb.append("/");
        sb.append(ruleId);
        return sb.toString();
    }

    public String getRuleID() {
        return this.fRuleId;
    }

    public String getAssigned() {
        return this.fAssignedToParticipant;
    }

    public void setAssigned(String aParticipant) {
        this.fAssignedToCombo.setText(aParticipant);
    }
}

