/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedFile;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.AnomalyExtraProperties;
import org.eclipse.ui.views.properties.IPropertySource;

public class R4EUIAnomalyExtended
extends R4EUIAnomalyBasic {
    private static final String NEXT_STATE_ELEMENT_COMMAND_NAME = "Progress Anomaly...";
    private static final String NEXT_STATE_ELEMENT_COMMAND_TOOLTIP = "Progress Anomaly to Next State";
    private static final String PREVIOUS_STATE_ELEMENT_COMMAND_NAME = "Regress Anomaly";
    private static final String PREVIOUS_STATE_ELEMENT_COMMAND_TOOLTIP = "Regress Anomaly to Previous State";
    private static final String ANOMALY_STATE_CREATED = "CREATED";
    private static final String ANOMALY_STATE_ASSIGNED = "ASSIGNED";
    private static final String ANOMALY_STATE_ACCEPTED = "ACCEPTED";
    private static final String ANOMALY_STATE_DUPLICATED = "DUPLICATED";
    private static final String ANOMALY_STATE_REJECTED = "REJECTED";
    private static final String ANOMALY_STATE_POSTPONED = "POSTPONED";
    private static final String ANOMALY_STATE_FIXED = "FIXED";
    private static final String ANOMALY_STATE_VERIFIED = "VERIFIED";
    private static final String[] STATE_VALUES = new String[]{"ACCEPTED", "DUPLICATED", "REJECTED", "POSTPONED", "ASSIGNED", "CREATED", "VERIFIED", "FIXED"};

    public R4EUIAnomalyExtended(IR4EUIModelElement aParent, R4EAnomaly aAnomaly, IR4EUIPosition aPosition) {
        super(aParent, aAnomaly, aPosition);
    }

    public static String buildAnomalyExtName(R4EAnomaly aAnomaly, IR4EUIPosition aPosition) {
        StringBuilder sb = new StringBuilder(String.valueOf(R4EUIAnomalyExtended.getStateString(aAnomaly.getState())) + ": ");
        if (aPosition == null) {
            sb.append(aAnomaly.getTitle());
        } else {
            sb.append(String.valueOf(aPosition.toString()) + "->" + aAnomaly.getTitle());
        }
        return sb.toString();
    }

    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new AnomalyExtraProperties(this);
        }
        return null;
    }

    public void updateState(R4EAnomalyState aNewState) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fAnomaly, R4EUIModelController.getReviewer());
        this.fAnomaly.setState(aNewState);
        if (this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_FIXED) || this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED)) {
            if (this.getParent().getParent() instanceof R4EUIFileContext) {
                this.fAnomaly.setFixedInVersion(((R4EUIFileContext)this.getParent().getParent()).getTargetFileVersion());
            } else if (this.getParent() instanceof R4EUIPostponedFile) {
                this.fAnomaly.setFixedInVersion(((R4EUIPostponedFile)this.getParent()).getTargetFileVersion());
            }
        }
        this.updateDecider(aNewState);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        String nameLabel = null;
        nameLabel = this.getPosition() == null ? R4EUIAnomalyExtended.adjustTitleLength(this.fAnomaly) : String.valueOf(this.getPosition().toString()) + "->" + R4EUIAnomalyExtended.adjustTitleLength(this.fAnomaly);
        this.setName(String.valueOf(R4EUIAnomalyExtended.getStateString(aNewState)) + ": " + nameLabel);
    }

    private void updateDecider(R4EAnomalyState aNewState) {
        if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED) || aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED) || aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED) || aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED)) {
            this.fAnomaly.setDecidedByID(R4EUIModelController.getReviewer());
        } else if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_FIXED)) {
            this.fAnomaly.setFixedByID(R4EUIModelController.getReviewer());
        } else if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED)) {
            this.fAnomaly.setFollowUpByID(R4EUIModelController.getReviewer());
        }
    }

    public boolean isNextStateElementCmd() {
        return this.isEnabled() && !this.isReadOnly() && this.getNextAvailableStates().length > 0;
    }

    public String getNextStateElementCmdName() {
        return NEXT_STATE_ELEMENT_COMMAND_NAME;
    }

    public String getNextStateElementCmdTooltip() {
        return NEXT_STATE_ELEMENT_COMMAND_TOOLTIP;
    }

    public boolean isPreviousStateElementCmd() {
        return this.isEnabled() && !this.isReadOnly() && this.getPreviousState() != null;
    }

    public String getPreviousStateElementCmdName() {
        return PREVIOUS_STATE_ELEMENT_COMMAND_NAME;
    }

    public String getPreviousStateElementCmdTooltip() {
        return PREVIOUS_STATE_ELEMENT_COMMAND_TOOLTIP;
    }

    public static String getStateString(R4EAnomalyState aNewState) {
        if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_CREATED)) {
            return ANOMALY_STATE_CREATED;
        }
        if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED)) {
            return ANOMALY_STATE_ASSIGNED;
        }
        if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED)) {
            return ANOMALY_STATE_ACCEPTED;
        }
        if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED)) {
            return ANOMALY_STATE_DUPLICATED;
        }
        if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED)) {
            return ANOMALY_STATE_REJECTED;
        }
        if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED)) {
            return ANOMALY_STATE_POSTPONED;
        }
        if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_FIXED)) {
            return ANOMALY_STATE_FIXED;
        }
        if (aNewState.equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED)) {
            return ANOMALY_STATE_VERIFIED;
        }
        return "";
    }

    public static R4EAnomalyState getStateFromString(String aNewState) {
        if (aNewState.equals(ANOMALY_STATE_CREATED)) {
            return R4EAnomalyState.R4E_ANOMALY_STATE_CREATED;
        }
        if (aNewState.equals(ANOMALY_STATE_ASSIGNED)) {
            return R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED;
        }
        if (aNewState.equals(ANOMALY_STATE_ACCEPTED)) {
            return R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED;
        }
        if (aNewState.equals(ANOMALY_STATE_DUPLICATED)) {
            return R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED;
        }
        if (aNewState.equals(ANOMALY_STATE_REJECTED)) {
            return R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED;
        }
        if (aNewState.equals(ANOMALY_STATE_POSTPONED)) {
            return R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED;
        }
        if (aNewState.equals(ANOMALY_STATE_FIXED)) {
            return R4EAnomalyState.R4E_ANOMALY_STATE_FIXED;
        }
        if (aNewState.equals(ANOMALY_STATE_VERIFIED)) {
            return R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED;
        }
        return null;
    }

    public static String[] getStates() {
        return STATE_VALUES;
    }

    public String[] getAvailableStates() {
        R4EAnomalyState[] states = this.getAllowedStates(this.getAnomaly().getState());
        ArrayList<String> stateStrings = new ArrayList<String>();
        R4EAnomalyState[] r4EAnomalyStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            R4EAnomalyState state = r4EAnomalyStateArray[n2];
            stateStrings.add(R4EUIAnomalyExtended.getStateString(state));
            ++n2;
        }
        return stateStrings.toArray(new String[stateStrings.size()]);
    }

    public String[] getNextAvailableStates() {
        R4EAnomalyState[] states = this.getNextAllowedStates(this.getAnomaly().getState());
        ArrayList<String> stateStrings = new ArrayList<String>();
        R4EAnomalyState[] r4EAnomalyStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            R4EAnomalyState state = r4EAnomalyStateArray[n2];
            stateStrings.add(R4EUIAnomalyExtended.getStateString(state));
            ++n2;
        }
        return stateStrings.toArray(new String[stateStrings.size()]);
    }

    public R4EAnomalyState getPreviousState() {
        R4EAnomalyState currentState = this.getAnomaly().getState();
        if (R4EUIModelController.getActiveReview() != null) {
            if (R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_INFORMAL)) {
                switch (currentState.getValue()) {
                    case 3: {
                        return R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED;
                    }
                    case 1: {
                        return R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED;
                    }
                    case 2: {
                        return R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED;
                    }
                    case 7: {
                        return R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED;
                    }
                    case 6: {
                        return R4EAnomalyState.R4E_ANOMALY_STATE_FIXED;
                    }
                }
                return null;
            }
            R4EReviewPhase phase = ((R4EFormalReview)R4EUIModelController.getActiveReview().getReview()).getCurrent().getType();
            switch (currentState.getValue()) {
                case 3: {
                    if (!phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION) && !phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) break;
                    return R4EAnomalyState.R4E_ANOMALY_STATE_CREATED;
                }
                case 1: {
                    if (!phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION) && !phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) break;
                    return R4EAnomalyState.R4E_ANOMALY_STATE_CREATED;
                }
                case 2: {
                    if (!phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION) && !phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) break;
                    return R4EAnomalyState.R4E_ANOMALY_STATE_CREATED;
                }
                case 0: {
                    if (!phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION) && !phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) break;
                    return R4EAnomalyState.R4E_ANOMALY_STATE_CREATED;
                }
                case 7: {
                    if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION)) {
                        return R4EAnomalyState.R4E_ANOMALY_STATE_CREATED;
                    }
                    if (!phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) break;
                    return R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED;
                }
                case 6: {
                    if (!phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) break;
                    return R4EAnomalyState.R4E_ANOMALY_STATE_FIXED;
                }
            }
        }
        return null;
    }

    public int mapStateToIndex(R4EAnomalyState aState) {
        R4EAnomalyState[] states = this.getAllowedStates(this.getAnomaly().getState());
        int i = 0;
        while (i < states.length) {
            if (states[i].getValue() == aState.getValue()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isDecidedByEnabled() {
        if (R4EUIModelController.getActiveReview() != null) {
            if (R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_INFORMAL)) {
                if (this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED) || this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED) || this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED) || this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_FIXED) || this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED)) {
                    return true;
                }
            } else {
                R4EReviewPhase phase = ((R4EFormalReview)R4EUIModelController.getActiveReview().getReview()).getCurrent().getType();
                if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION)) {
                    if (this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED) || this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED) || this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED) || this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED)) {
                        return true;
                    }
                    if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK) && (this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_FIXED) || this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isFixedByEnabled() {
        return this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
    }

    public boolean isFollowUpByEnabled() {
        return this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED);
    }

    public boolean isNotAcceptedReasonEnabled() {
        return this.fAnomaly.getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
    }

    private R4EAnomalyState[] getAllowedStates(R4EAnomalyState aCurrentState) {
        ArrayList<R4EAnomalyState> states = new ArrayList<R4EAnomalyState>();
        if (R4EUIModelController.getActiveReview() != null) {
            if (R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_INFORMAL)) {
                switch (aCurrentState.getValue()) {
                    case 4: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                        break;
                    }
                    case 3: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                        break;
                    }
                    case 1: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                        break;
                    }
                    case 2: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                        break;
                    }
                    case 7: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED);
                        break;
                    }
                    case 6: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED);
                    }
                }
            } else if (R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
                R4EReviewPhase phase = ((R4EFormalReview)R4EUIModelController.getActiveReview().getReview()).getCurrent().getType();
                switch (aCurrentState.getValue()) {
                    case 5: {
                        if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION) || phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) {
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_CREATED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                            break;
                        }
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_CREATED);
                        break;
                    }
                    case 3: {
                        if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION) || phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) {
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                            break;
                        }
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                        break;
                    }
                    case 1: {
                        if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION) || phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) {
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                            break;
                        }
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                        break;
                    }
                    case 2: {
                        if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION) || phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) {
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                            break;
                        }
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                        break;
                    }
                    case 0: {
                        if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_DECISION)) {
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_CREATED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                            break;
                        }
                        if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) {
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_CREATED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                            break;
                        }
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                        break;
                    }
                    case 7: {
                        if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) {
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                            states.add(R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED);
                            break;
                        }
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                        break;
                    }
                    case 6: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED);
                    }
                }
            }
        }
        return states.toArray(new R4EAnomalyState[states.size()]);
    }

    private R4EAnomalyState[] getNextAllowedStates(R4EAnomalyState aCurrentState) {
        ArrayList<R4EAnomalyState> states = new ArrayList<R4EAnomalyState>();
        if (R4EUIModelController.getActiveReview() != null) {
            if (R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_INFORMAL)) {
                switch (aCurrentState.getValue()) {
                    case 4: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                        break;
                    }
                    case 7: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED);
                    }
                }
            } else {
                R4EReviewPhase phase = ((R4EFormalReview)R4EUIModelController.getActiveReview().getReview()).getCurrent().getType();
                switch (aCurrentState.getValue()) {
                    case 5: {
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DEFERRED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_DUPLICATED);
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_REJECTED);
                        break;
                    }
                    case 0: {
                        if (!phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) break;
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_FIXED);
                        break;
                    }
                    case 7: {
                        if (!phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_REWORK)) break;
                        states.add(R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED);
                    }
                }
            }
        }
        return states.toArray(new R4EAnomalyState[states.size()]);
    }
}

