/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.text.MessageFormat;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;

public class R4ECompareEditorInput
extends SaveableCompareEditorInput {
    private final CompareConfiguration fConfig;
    private final ITypedElement fAncestor;
    private final ITypedElement fLeft;
    private final ITypedElement fRight;

    public R4ECompareEditorInput(CompareConfiguration aConfig, ITypedElement aAncestor, ITypedElement aLeft, ITypedElement aRight) {
        super(aConfig, null);
        this.fConfig = aConfig;
        this.fAncestor = aAncestor;
        this.fLeft = aLeft;
        this.fRight = aRight;
    }

    public ITypedElement getAncestorElement() {
        return this.fAncestor;
    }

    public ITypedElement getLeftElement() {
        return this.fLeft;
    }

    public ITypedElement getRightElement() {
        return this.fRight;
    }

    public void prepareCompareInputNoEditor() {
        this.prepareCompareInput(null);
    }

    public String getToolTipText() {
        if (this.fLeft != null && this.fRight != null) {
            String format = null;
            StringBuilder leftLabel = null;
            if (this.fLeft != null) {
                leftLabel = new StringBuilder("Target: " + this.fLeft.getName());
                if (this.fLeft instanceof R4EFileRevisionTypedElement) {
                    leftLabel.append("_" + ((R4EFileRevisionTypedElement)this.fLeft).getFileVersion().getVersionID());
                }
                this.fConfig.setLeftLabel(leftLabel.toString());
            }
            StringBuilder rightLabel = null;
            if (this.fRight != null) {
                rightLabel = new StringBuilder("Base: " + this.fRight.getName());
                if (this.fRight instanceof R4EFileRevisionTypedElement) {
                    rightLabel.append("_" + ((R4EFileRevisionTypedElement)this.fRight).getFileVersion().getVersionID());
                }
                this.fConfig.setRightLabel(rightLabel.toString());
            }
            if (this.fAncestor != null) {
                format = CompareUI.getResourceBundle().getString("ResourceCompare.threeWay.tooltip");
                return MessageFormat.format(format, "", leftLabel, rightLabel);
            }
            format = CompareUI.getResourceBundle().getString("ResourceCompare.twoWay.tooltip");
            return MessageFormat.format(format, leftLabel, rightLabel);
        }
        return super.getToolTipText();
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.equals((Object)adapter)) {
            if (this.getWorkspaceElement() != null) {
                return this.getWorkspaceElement().getResource();
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    protected void fireInputChange() {
    }

    private R4EFileTypedElement getWorkspaceElement() {
        if (this.fLeft instanceof R4EFileTypedElement) {
            return (R4EFileTypedElement)this.fLeft;
        }
        return null;
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor aMonitor) {
        if (aMonitor != null) {
            aMonitor.beginTask("R4E Compare", -1);
        }
        this.initLabels();
        Differencer differencer = new Differencer();
        Object differences = differencer.findDifferences(false, aMonitor, null, (Object)this.fAncestor, (Object)this.fLeft, (Object)this.fRight);
        return (ICompareInput)differences;
    }

    private void initLabels() {
        if (this.fLeft != null) {
            StringBuilder leftLabel = new StringBuilder("Target: " + this.fLeft.getName());
            if (this.fLeft instanceof R4EFileRevisionTypedElement) {
                leftLabel.append(" " + ((R4EFileRevisionTypedElement)this.fLeft).getFileVersion().getVersionID());
            }
            this.fConfig.setLeftLabel(leftLabel.toString());
        }
        if (this.fRight != null) {
            StringBuilder rightLabel = new StringBuilder("Base: " + this.fRight.getName());
            if (this.fRight instanceof R4EFileRevisionTypedElement) {
                rightLabel.append("_" + ((R4EFileRevisionTypedElement)this.fRight).getFileVersion().getVersionID());
            }
            this.fConfig.setRightLabel(rightLabel.toString());
        }
        if (this.fAncestor != null) {
            this.fConfig.setAncestorLabel(this.fAncestor.getName());
        }
    }

    public Control createContents(Composite aParent) {
        Control control = super.createContents(aParent);
        UIUtils.selectElementInEditor(this);
        return control;
    }
}

