/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ModelElementProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class R4EUIModelElement
implements IR4EUIModelElement,
IAdaptable {
    public static final String REVIEWED_OVERLAY_ICON_FILE = "icons/ovr16/revovr_tsk.gif";
    public static final String DISABLED_OVERLAY_ICON_FILE = "icons/ovr16/dsbldovr_tsk.gif";
    public static final String BOLD_ICON_FILE = "icons/ovr16/bold_icon.gif";
    public static final String ITALIC_ICON_FILE = "icons/ovr16/italics_icon.gif";
    public static final String READONLY_OVERLAY_ICON_FILE = "icons/ovr16/readonlyovr_tsk.gif";
    public static final String SET_IMAGE_MESSAGE = "Setting Images";
    private String fName;
    protected Image fImage;
    protected Image fDisabledImage;
    private final IR4EUIModelElement fParent;
    protected boolean fUserReviewed = false;
    protected boolean fOpen = true;
    protected boolean fReadOnly = false;

    protected R4EUIModelElement(IR4EUIModelElement aParent, String aName) {
        this.fName = aName;
        this.fParent = aParent;
        this.fOpen = true;
    }

    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new ModelElementProperties(this);
        }
        return null;
    }

    @Override
    public void setName(String aName) {
        this.fName = aName;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getToolTip() {
        return null;
    }

    @Override
    public Image getImage() {
        if (this.isEnabled()) {
            return this.fImage;
        }
        return this.fDisabledImage;
    }

    @Override
    public final void setImage(String aLocation) {
        this.fImage = UIUtils.loadIcon(aLocation);
        this.fDisabledImage = UIUtils.loadDisabledIcon(aLocation);
    }

    @Override
    public boolean isUserReviewed() {
        return this.fUserReviewed;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    @Override
    public boolean isAssigned(String aUserName, boolean aCheckChildren) {
        return false;
    }

    @Override
    public void close() {
        this.fOpen = false;
    }

    @Override
    public void open() throws CompatibilityException, ResourceHandlingException, FileNotFoundException {
        this.fOpen = true;
    }

    @Override
    public boolean isOpen() {
        return this.fOpen;
    }

    @Override
    public Image getUserReviewedImage() {
        return UIUtils.loadIcon(REVIEWED_OVERLAY_ICON_FILE);
    }

    @Override
    public Image getDisabledImage() {
        return UIUtils.loadIcon(DISABLED_OVERLAY_ICON_FILE);
    }

    @Override
    public Image getReadOnlyImage() {
        return UIUtils.loadIcon(READONLY_OVERLAY_ICON_FILE);
    }

    @Override
    public void setUserReviewed(boolean aReviewed, boolean aSetChildren, boolean aUpdateModel) throws OutOfSyncException, ResourceHandlingException {
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
    }

    @Override
    public void addAssignees(List<R4EParticipant> aParticipants) {
    }

    @Override
    public void removeAssignees(List<R4EParticipant> aParticipants) {
    }

    @Override
    public void setChildUserReviewed(boolean aReviewed, boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
    }

    @Override
    public void checkToSetUserReviewed(boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        return null;
    }

    @Override
    public void setModelData(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
    }

    @Override
    public void setInput() {
    }

    @Override
    public IR4EUIModelElement getParent() {
        return this.fParent;
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return new IR4EUIModelElement[0];
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws OutOfSyncException, CompatibilityException, ResourceHandlingException {
        return null;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
    }

    @Override
    public void restore() throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        this.setEnabled(true);
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
    }

    @Override
    public boolean isAddLinkedAnomalyCmd() {
        return false;
    }

    @Override
    public boolean isOpenEditorCmd() {
        return false;
    }

    @Override
    public boolean isChangeUserReviewStateCmd() {
        return false;
    }

    @Override
    public boolean isAssignToCmd() {
        return false;
    }

    @Override
    public boolean isUnassignToCmd() {
        return false;
    }

    @Override
    public boolean isOpenElementCmd() {
        return false;
    }

    @Override
    public String getOpenElementCmdName() {
        return "Open Element";
    }

    @Override
    public String getOpenElementCmdTooltip() {
        return "Open and Load Data for this Element";
    }

    @Override
    public boolean isReportElementCmd() {
        return false;
    }

    @Override
    public String getReportElementCmdName() {
        return "Generate Report";
    }

    @Override
    public String getReportElementCmdTooltip() {
        return "Generate a Report for this Element";
    }

    @Override
    public boolean isCloseElementCmd() {
        return false;
    }

    @Override
    public String getCloseElementCmdName() {
        return "Close Element";
    }

    @Override
    public String getCloseElementCmdTooltip() {
        return "Close and Unload Data for this Element";
    }

    @Override
    public boolean isNextStateElementCmd() {
        return false;
    }

    @Override
    public String getNextStateElementCmdName() {
        return "Close Element";
    }

    @Override
    public String getNextStateElementCmdTooltip() {
        return "Close and Unload Data for this Element";
    }

    @Override
    public boolean isPreviousStateElementCmd() {
        return false;
    }

    @Override
    public String getPreviousStateElementCmdName() {
        return "Close Element";
    }

    @Override
    public String getPreviousStateElementCmdTooltip() {
        return "Close and Unload Data for this Element";
    }

    @Override
    public boolean isNewChildElementCmd() {
        return false;
    }

    @Override
    public String getNewChildElementCmdName() {
        return "New Child Element";
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return "Add a New Child Element";
    }

    @Override
    public boolean isRemoveElementCmd() {
        return false;
    }

    @Override
    public String getRemoveElementCmdName() {
        return "Disable Element";
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return "Disable (and Optionally Remove) this Element";
    }

    @Override
    public boolean isRestoreElementCmd() {
        return false;
    }

    @Override
    public String getRestoreElementCmdName() {
        return "Restore Element";
    }

    @Override
    public String getRestoreElementCmdTooltip() {
        return "Restore this Disabled Element";
    }

    @Override
    public boolean isSendEmailCmd() {
        return false;
    }

    @Override
    public boolean isImportPostponedCmd() {
        return false;
    }

    @Override
    public boolean isShowPropertiesCmd() {
        return true;
    }
}

