/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import oshi.hardware.common.AbstractFirmware;
import oshi.jna.platform.windows.WbemcliUtil;
import oshi.util.platform.windows.WmiUtil;

final class WindowsFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;

    WindowsFirmware() {
        this.init();
    }

    private void init() {
        WbemcliUtil.WmiQuery<BiosProperty> biosQuery = WbemcliUtil.createQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WbemcliUtil.WmiResult<BiosProperty> win32BIOS = WmiUtil.queryWMI(biosQuery);
        if (win32BIOS.getResultCount() > 0) {
            this.setManufacturer(win32BIOS.getString(BiosProperty.MANUFACTURER, 0));
            this.setName(win32BIOS.getString(BiosProperty.NAME, 0));
            this.setDescription(win32BIOS.getString(BiosProperty.DESCRIPTION, 0));
            this.setVersion(win32BIOS.getString(BiosProperty.VERSION, 0));
            String releaseDate = win32BIOS.getString(BiosProperty.RELEASEDATE, 0);
            StringBuilder sb = new StringBuilder(releaseDate.substring(0, 4));
            sb.append('-').append(releaseDate.substring(4, 6));
            sb.append('-').append(releaseDate.substring(6, 8));
            this.setReleaseDate(sb.toString());
        }
    }

    static enum BiosProperty {
        MANUFACTURER,
        NAME,
        DESCRIPTION,
        VERSION,
        RELEASEDATE;

    }
}

