/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.io.UnsupportedEncodingException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.internal.jface.i18n.AgreementsDialogMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class AgreementPage
extends WizardPage {
    private final AgreementToAccept agreement;

    protected AgreementPage(AgreementToAccept agreement) {
        super(agreement.acceptance().name());
        this.agreement = agreement;
        this.setPageComplete(false);
        this.setMessage(AgreementsDialogMessages.AgreementPage_title);
    }

    public void createControl(Composite parent) {
        Composite container = this.container(parent);
        this.installContentView(container);
        this.installOptions(container);
        this.setControl((Control)container);
    }

    private Composite container(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        return container;
    }

    private void installContentView(Composite parent) {
        Text content = new Text(parent, 2634);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        try {
            content.setText(new String(this.agreement.acceptance().content(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            content.setText(e.getLocalizedMessage());
        }
    }

    private void installOptions(Composite parent) {
        Composite options = new Composite(parent, 0);
        options.setLayout((Layout)new GridLayout(1, false));
        Button accept = this.option(parent, AgreementsDialogMessages.AgreementPage_accept);
        accept.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::updatePageComplete));
    }

    private void updatePageComplete(SelectionEvent e) {
        boolean accepted = ((Button)e.getSource()).getSelection();
        this.setPageComplete(accepted);
    }

    private Button option(Composite parent, String text) {
        Button option = new Button(parent, 16416);
        option.setText(text);
        option.setSelection(false);
        option.setLayoutData((Object)new GridData(4, 0, true, false));
        return option;
    }
}

