/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.access;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.inspection.RuntimeEnvironment;
import org.eclipse.passage.lic.equinox.Environments;
import org.eclipse.passage.lic.equinox.access.BaseOption;
import org.eclipse.passage.lic.equinox.access.CoverageCheckOptionDecision;
import org.eclipse.passage.lic.equinox.access.Interaction;

final class OptionRequest
extends BaseOption<CoverageCheckOptionDecision> {
    OptionRequest(Interaction.Smart interaction) {
        super('r', "Request License", "Collect information necessary for a license issuing", interaction);
    }

    @Override
    public CoverageCheckOptionDecision run() {
        this.interaction.head("gather environment information");
        Object envs = new Environments().get();
        this.reportEnvironmentsDiscovered((Collection<RuntimeEnvironment>)envs);
        Iterator iterator = envs.iterator();
        while (iterator.hasNext()) {
            RuntimeEnvironment env = (RuntimeEnvironment)iterator.next();
            try {
                this.reportAssessment(env);
            }
            catch (LicensingException e) {
                this.interaction.prompt(String.format("%s environment assessment failed", ((EvaluationType)env.id()).identifier()));
                this.interaction.swear(e);
            }
        }
        return CoverageCheckOptionDecision.reassess;
    }

    private void reportEnvironmentsDiscovered(Collection<RuntimeEnvironment> envs) {
        this.interaction.prompt(String.format("\nTo request a license send demanded particles of these %d environments (%s) assessment to your licensing operator:\n", envs.size(), envs.stream().map(env -> ((EvaluationType)env.id()).identifier()).collect(Collectors.joining(", "))));
    }

    private void reportAssessment(RuntimeEnvironment env) throws LicensingException {
        this.interaction.prompt(String.format("\n==== %s ====\n%s\n", ((EvaluationType)env.id()).identifier(), env.state()));
    }
}

