/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net.handle;

import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;

public abstract class Failure
implements NetResponse {
    private final int code;
    private final String message;

    protected Failure(int code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public final boolean failed() {
        return true;
    }

    @Override
    public final boolean carriesPayload() {
        return false;
    }

    @Override
    public final NetResponse.Error error() {
        return new Err();
    }

    @Override
    public final byte[] payload() {
        throw new IllegalStateException("Is not intended to be called for failed response: no valid output");
    }

    @Override
    public final ContentType contentType() {
        return new ContentType.Xml();
    }

    public static final class BadRequestInvalidProduct
    extends Failure {
        public BadRequestInvalidProduct() {
            super(604, "Bad Request: licensed product identifier and/or version information is absent");
        }
    }

    public static final class BadRequestInvalidServerAuthInstructions
    extends Failure {
        public BadRequestInvalidServerAuthInstructions() {
            super(602, "Bad Requets: floating server authentication instructions (evaluation type and exrpressions) are absent or incomplete");
        }
    }

    public static final class BadRequestNoAlgo
    extends Failure {
        public BadRequestNoAlgo() {
            super(606, "Bad Request: no encoding algorithm identifier");
        }
    }

    public static final class BadRequestNoFeature
    extends Failure {
        public BadRequestNoFeature() {
            super(607, "Bad Request: no feature identifier");
        }
    }

    public static final class BadRequestNoUser
    extends Failure {
        public BadRequestNoUser() {
            super(605, "Bad Request: no user identifier");
        }
    }

    public static final class BadRequestUnknownAction
    extends Failure {
        public BadRequestUnknownAction(String actual) {
            super(603, String.format("Bad Requets: 'action' %s is not supported", actual));
        }
    }

    public static final class BadRequestUnkonwnProduct
    extends Failure {
        public BadRequestUnkonwnProduct(LicensedProduct product) {
            super(608, String.format("Bad Request: product %s is not known to the server", product));
        }
    }

    private final class Err
    implements NetResponse.Error {
        private Err() {
        }

        @Override
        public int code() {
            return Failure.this.code;
        }

        @Override
        public String message() {
            return Failure.this.message;
        }
    }

    public static final class ForeignServer
    extends Failure {
        public ForeignServer(String error) {
            super(600, String.format("Server authentication failed: %s", error));
        }
    }

    public static final class OperationFailed
    extends Failure {
        public OperationFailed(String name, String details) {
            super(610, String.format("Operation %s failed: \n%s", name, details));
        }
    }
}

