/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.api.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.io.DigestExpectation;
import org.eclipse.passage.lic.internal.api.io.EncryptionAlgorithm;
import org.eclipse.passage.lic.internal.api.io.EncryptionKeySize;
import org.eclipse.passage.lic.internal.api.registry.Service;

public interface StreamCodec
extends Service<LicensedProduct> {
    public EncryptionAlgorithm algorithm();

    public EncryptionKeySize keySize();

    public void createKeyPair(OutputStream var1, OutputStream var2, String var3, String var4) throws LicensingException;

    public void encode(InputStream var1, OutputStream var2, InputStream var3, String var4, String var5) throws LicensingException;

    public void decode(InputStream var1, OutputStream var2, InputStream var3, DigestExpectation var4) throws LicensingException;

    public static final class Smart
    implements StreamCodec {
        private final StreamCodec delegate;

        public Smart(StreamCodec delegate) {
            Objects.requireNonNull(delegate, "StreamCodec.Smart::delegate");
            this.delegate = delegate;
        }

        @Override
        public LicensedProduct id() {
            return (LicensedProduct)this.delegate.id();
        }

        @Override
        public EncryptionAlgorithm algorithm() {
            return this.delegate.algorithm();
        }

        @Override
        public EncryptionKeySize keySize() {
            return this.delegate.keySize();
        }

        @Override
        public void createKeyPair(OutputStream publicKey, OutputStream privateKey, String username, String password) throws LicensingException {
            this.delegate.createKeyPair(publicKey, privateKey, username, password);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void createKeyPair(Path publicKey, Path privateKey, String username, String password) throws LicensingException {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try {
                    FileOutputStream pub = new FileOutputStream(publicKey.toFile());
                    try {
                        try (FileOutputStream scr = new FileOutputStream(privateKey.toFile());){
                            this.delegate.createKeyPair(pub, scr, username, password);
                        }
                        if (pub == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (pub == null) throw throwable;
                        pub.close();
                        throw throwable;
                    }
                    pub.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new LicensingException("failed to create encryption keys", e);
            }
        }

        @Override
        public void encode(InputStream input, OutputStream output, InputStream key, String username, String password) throws LicensingException {
            this.delegate.encode(input, output, key, username, password);
        }

        @Override
        public void decode(InputStream input, OutputStream output, InputStream key, DigestExpectation digest) throws LicensingException {
            this.delegate.decode(input, output, key, digest);
        }
    }
}

