/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.seal.internal.demo;

import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.internal.api.AccessCycleConfiguration;
import org.eclipse.passage.lic.internal.api.Framework;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.base.BaseFramework;
import org.eclipse.passage.lic.internal.base.InvalidLicensedProduct;
import org.eclipse.passage.lic.internal.base.logging.Logging;
import org.eclipse.passage.lic.internal.equinox.LicensedApplication;
import org.eclipse.passage.lic.internal.equinox.io.FileFromBundle;
import org.eclipse.passage.seal.internal.demo.FocusedAccessCycleConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

final class DemoFramework
extends BaseFramework {
    static final Framework demo = new DemoFramework();
    private final Logger log;

    private DemoFramework() {
        this.configureLogging();
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.logConfiguration();
    }

    protected final LicensedProduct productRead() {
        LicensedProduct prod;
        try {
            prod = new LicensedApplication().product();
        }
        catch (LicensingException e) {
            prod = new InvalidLicensedProduct();
        }
        return prod;
    }

    protected AccessCycleConfiguration configuration(LicensedProduct product) {
        return new FocusedAccessCycleConfiguration.Wide(() -> product);
    }

    private void configureLogging() {
        new Logging(this::logConfig).configure();
    }

    private InputStream logConfig() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        return new FileFromBundle(bundle, "config/log4j2.xml").get();
    }

    private void logConfiguration() {
        this.log.debug(String.format("%s runs for %s", ((Object)((Object)this)).getClass().getName(), this.product()));
    }
}

