/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.emf.EObjectFromBytes;
import org.eclipse.passage.lic.internal.hc.i18n.AccessMessages;
import org.eclipse.passage.lic.internal.hc.remote.RequestContext;
import org.eclipse.passage.lic.internal.hc.remote.ResponseHandler;
import org.eclipse.passage.lic.internal.hc.remote.impl.Equipment;
import org.eclipse.passage.lic.internal.hc.remote.impl.ResultsTransfered;
import org.eclipse.passage.lic.internal.net.io.SafePayload;

public final class EObjectFromXmiResponse<T extends EObject>
implements ResponseHandler<T> {
    private final Class<T> expected;
    private final Equipment equipment;

    public EObjectFromXmiResponse(Class<T> expected, Equipment equipment) {
        this.expected = expected;
        this.equipment = equipment;
    }

    @Override
    public T read(ResultsTransfered results, RequestContext context) throws LicensingException {
        this.contentTypeIsExpected(results);
        return (T)new EObjectFromBytes(this.decoded(results.data(), context), this.expected).get();
    }

    private byte[] decoded(byte[] raw, RequestContext context) throws LicensingException {
        return new SafePayload(this.equipment.keeper(context.product()), this.equipment.hash(context.hash())).decode(raw);
    }

    private void contentTypeIsExpected(ResultsTransfered results) throws LicensingException {
        ContentType.Xml xml = new ContentType.Xml();
        if (!xml.equals((Object)results.contentType())) {
            throw new LicensingException(String.format(AccessMessages.EObjectFromXmiResponse_unexpected_content_type, results.contentType(), xml.contentType()));
        }
    }
}

