/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.jetty;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.passage.lbc.internal.api.FloatingResponse;
import org.eclipse.passage.lbc.internal.api.FloatingState;
import org.eclipse.passage.lbc.internal.api.RawRequest;
import org.eclipse.passage.lbc.internal.base.BaseFlotingRequestHandled;
import org.eclipse.passage.lbc.internal.base.EagerFloatingState;
import org.eclipse.passage.lbc.internal.jetty.JettyRequest;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;

final class JettyHandler
extends AbstractHandler {
    private final FloatingState state = new EagerFloatingState();

    JettyHandler() {
    }

    public void handle(String target, Request request, HttpServletRequest wrapper, HttpServletResponse envelope) throws IOException, ServletException {
        this.write(this.response(wrapper), envelope);
        request.setHandled(true);
    }

    private FloatingResponse response(HttpServletRequest request) {
        return new BaseFlotingRequestHandled((RawRequest)new JettyRequest(request, this.state)).get();
    }

    private void write(FloatingResponse response, HttpServletResponse envelope) throws IOException {
        envelope.setContentType(new ContentType.Xml().contentType());
        envelope.setCharacterEncoding("UTF-8");
        if (response.failed()) {
            envelope.sendError(response.error().code(), response.error().message());
            return;
        }
        envelope.setStatus(200);
        if (response.carriesPayload()) {
            byte[] payload;
            try {
                payload = response.payload();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            envelope.setContentLength(payload.length);
            Throwable throwable = null;
            Object var5_7 = null;
            try (PrintWriter out = envelope.getWriter();){
                out.write(new String(payload, Charset.forName("UTF-8")));
                out.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            envelope.flushBuffer();
        }
    }
}

