/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransport;
import org.eclipse.passage.lic.internal.api.conditions.mining.ConditionTransportRegistry;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.api.registry.Registry;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.base.conditions.BaseConditionPack;
import org.eclipse.passage.lic.internal.hc.i18n.HcMessages;
import org.eclipse.passage.lic.internal.hc.remote.ResponseHandler;

final class DecryptedConditions
implements ResponseHandler {
    private final ConditionTransportRegistry transports;

    DecryptedConditions(ConditionTransportRegistry transports) {
        this.transports = transports;
    }

    @Override
    public Collection<ConditionPack> read(byte[] raw, String contentType) throws LicensingException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(this.keyDecoded(this.base64Decoded(raw)));){
                return Collections.singleton(new BaseConditionPack("net", this.transport((ContentType)new ContentType.Of(contentType)).read((InputStream)stream)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LicensingException(HcMessages.DecryptedConditions_reading_error, (Throwable)e);
        }
    }

    private byte[] base64Decoded(byte[] raw) throws LicensingException {
        return raw;
    }

    private byte[] keyDecoded(byte[] data) throws LicensingException {
        return data;
    }

    private ConditionTransport transport(ContentType contentType) throws LicensingException {
        if (!((Registry)this.transports.get()).hasService((ServiceId)contentType)) {
            throw new LicensingException(String.format(HcMessages.DecryptedConditions_no_transport_for_content_type, contentType.contentType()));
        }
        return (ConditionTransport)((Registry)this.transports.get()).service((ServiceId)contentType);
    }
}

