/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.util.Objects;
import org.eclipse.passage.lbc.internal.api.persistence.BoundLicense;
import org.eclipse.passage.lbc.internal.base.ConditionIdentifier;
import org.eclipse.passage.lbc.internal.base.LicenseCapacity;
import org.eclipse.passage.lbc.internal.base.LicenseTaken;

public final class BaseBoundLicense
implements BoundLicense {
    private final ConditionIdentifier identifier;
    private final LicenseCapacity capacity;
    private final LicenseTaken taken;

    public BaseBoundLicense(ConditionIdentifier identifier, LicenseTaken taken, LicenseCapacity capacity) {
        Objects.requireNonNull(identifier, "BaseBoundLicense::identifier");
        Objects.requireNonNull(capacity, "BaseBoundLicense::capacity");
        Objects.requireNonNull(taken, "BaseBoundLicense::taken");
        this.identifier = identifier;
        this.capacity = capacity;
        this.taken = taken;
    }

    public ConditionIdentifier identifier() {
        return this.identifier;
    }

    public LicenseCapacity capacity() {
        return this.capacity;
    }

    public LicenseTaken taken() {
        return this.taken;
    }

    public boolean takeable() {
        return (Integer)this.taken().get().get() < (Integer)this.capacity().get().get();
    }

    public boolean releasable() {
        return (Integer)this.taken().get().get() > 0;
    }
}

