/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.base.BaseNamedData;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceCannotOperate;
import org.eclipse.passage.lic.internal.equinox.requirements.LicCapabilityNamespace;
import org.eclipse.passage.lic.internal.equinox.requirements.RequirementFromCapability;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;

final class RequirementsFromBundle
extends BaseNamedData<ServiceInvocationResult<Collection<Requirement>>> {
    public RequirementsFromBundle(Bundle bundle) {
        super(key -> new FromBondle(bundle).read((String)key));
    }

    public String key() {
        return new LicCapabilityNamespace().get();
    }

    private static final class FromBondle {
        private final Bundle bundle;

        FromBondle(Bundle bundle) {
            this.bundle = bundle;
        }

        ServiceInvocationResult<Collection<Requirement>> read(String key) {
            Optional<List> capabilities = Optional.ofNullable((BundleWiring)this.bundle.adapt(BundleWiring.class)).map(wiring -> wiring.getCapabilities(key));
            if (!capabilities.isPresent()) {
                return this.fail();
            }
            return capabilities.get().stream().map(capability -> new RequirementFromCapability(this.bundle, (BundleCapability)capability)).map(RequirementFromCapability::get).reduce((BinaryOperator<ServiceInvocationResult>)new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfCollections())).orElseGet(BaseServiceInvocationResult::new);
        }

        private ServiceInvocationResult<Collection<Requirement>> fail() {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceCannotOperate(), "Requirements-from-bundles resolver cannot operate as cannot get bundle wiring"));
        }
    }
}

