/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.lic.emf.edit.EditingDomainRegistryAccess;
import org.eclipse.passage.lic.internal.api.MandatoryService;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.loc.internal.workbench.CreateRoot;
import org.eclipse.passage.loc.internal.workbench.MandatoryEclipseContext;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.passage.loc.jface.dialogs.FilteredSelectionDialog;
import org.eclipse.passage.loc.jface.dialogs.LabelSearchFilter;
import org.eclipse.passage.loc.workbench.viewers.DomainRegistryLabelProvider;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class LocWokbench {
    public static final String BUNDLE_SYMBOLIC_NAME = "org.eclipse.passage.loc.workbench";
    public static final String COMMAND_VIEW_PERSPECTIVE = "org.eclipse.passage.loc.workbench.command.view.perspective";
    public static final String COMMANDPARAMETER_VIEW_PERSPECTIVE_ID = "org.eclipse.passage.loc.workbench.commandparameter.perspective.id";
    public static final String TOPIC_SHOW = "org/eclipse/passage/loc/workbench/show";

    public static String selectSavePath(Shell shell, String extension) {
        String[] array = LocWokbench.maskFilters(extension, new String[0]);
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setFilterExtensions(array);
        return fileDialog.open();
    }

    public static String selectLoadPath(Shell shell, String extension, String ... others) {
        String[] array = LocWokbench.maskFilters(extension, others);
        FileDialog fileDialog = new FileDialog(shell, 4096);
        fileDialog.setFilterExtensions(array);
        return fileDialog.open();
    }

    private static String[] maskFilters(String extension, String ... others) {
        ArrayList<String> filters = new ArrayList<String>();
        filters.add(LocWokbench.maskExtension(extension));
        String[] stringArray = others;
        int n = others.length;
        int n2 = 0;
        while (n2 < n) {
            String other = stringArray[n2];
            filters.add(LocWokbench.maskExtension(other));
            ++n2;
        }
        String[] array = filters.toArray(new String[filters.size()]);
        return array;
    }

    private static String maskExtension(String extension) {
        return "*." + extension;
    }

    public static void createDomainResource(IEclipseContext context, String domain, String perspectiveId) {
        EditingDomainRegistryAccess registryAccess = (EditingDomainRegistryAccess)context.get(EditingDomainRegistryAccess.class);
        EditingDomainRegistry registry = registryAccess.getDomainRegistry(domain);
        if (((Optional)new CreateRoot((MandatoryService)new MandatoryEclipseContext(context), domain, registry.getContentClass()).get()).isPresent()) {
            LocWokbench.switchPerspective(context, perspectiveId);
        }
    }

    public static void loadDomainResource(IEclipseContext eclipseContext, String domain, String perspectiveId) {
        EditingDomainRegistryAccess access = (EditingDomainRegistryAccess)eclipseContext.get(EditingDomainRegistryAccess.class);
        EditingDomainRegistry registry = access.getDomainRegistry(domain);
        String fileExtension = String.valueOf(domain) + "_xmi";
        Shell shell = (Shell)eclipseContext.get(Shell.class);
        String selected = LocWokbench.selectLoadPath(shell, fileExtension, "lic_" + domain);
        if (selected == null) {
            return;
        }
        LocWokbench.switchPerspective(eclipseContext, perspectiveId);
        registry.registerSource(selected);
    }

    public static void switchPerspective(IEclipseContext eclipseContext, String perspectiveId) {
        EPartService partService = (EPartService)eclipseContext.get(EPartService.class);
        Optional switched = partService.switchPerspective(perspectiveId);
        if (switched.isPresent()) {
            MPerspective perspective = (MPerspective)switched.get();
            String label = perspective.getLocalizedLabel();
            IApplicationContext applicationContext = (IApplicationContext)eclipseContext.get(IApplicationContext.class);
            String brandingName = applicationContext.getBrandingName();
            String title = String.valueOf(brandingName) + ' ' + '-' + ' ' + label;
            MWindow window = (MWindow)eclipseContext.get(MWindow.class);
            window.setLabel(title);
        }
    }

    public static <C> Object selectClassifier(IEclipseContext context, String classifier, String title, Iterable<C> input, C initial) {
        Shell shell = (Shell)context.get(Shell.class);
        ComposedAdapterFactoryProvider provider = (ComposedAdapterFactoryProvider)context.get(ComposedAdapterFactoryProvider.class);
        ComposedAdapterFactory factory = provider.getComposedAdapterFactory();
        return LocWokbench.selectClassifier(shell, factory, classifier, title, input, initial);
    }

    public static <C> C selectClassifier(Shell shell, ComposedAdapterFactory factory, String classifier, String title, Iterable<? extends C> input, C initial, Class<C> clazz) {
        Object selected = LocWokbench.selectClassifier(shell, factory, classifier, title, input, initial);
        if (clazz.isInstance(selected)) {
            return clazz.cast(selected);
        }
        return null;
    }

    public static <C> Object selectClassifier(Shell shell, ComposedAdapterFactory factory, String classifier, String title, Iterable<? extends C> input, C initial) {
        if (input == null) {
            return null;
        }
        long count = StreamSupport.stream(input.spliterator(), false).count();
        if (count == 0L) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)WorkbenchMessages.LocWokbench_e_nothing_to_select);
            return null;
        }
        if (count == 1L) {
            return input.iterator().next();
        }
        LabelSearchFilter filter = new LabelSearchFilter();
        FilteredSelectionDialog dialog = new FilteredSelectionDialog(shell, false, filter);
        dialog.setTitle(title);
        dialog.setImage(LicensingImages.getImage((String)classifier));
        dialog.setLabelProvider(new DomainRegistryLabelProvider((AdapterFactory)factory));
        dialog.setInput(input);
        if (initial != null) {
            dialog.setInitialSelection(Collections.singletonList(initial));
        }
        if (dialog.open() == 0) {
            return dialog.getFirstResult().orElse(null);
        }
        return null;
    }

    public static IStatus save(Resource resource) {
        try {
            resource.save(null);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            return new Status(4, BUNDLE_SYMBOLIC_NAME, WorkbenchMessages.LocWokbench_e_saving, (Throwable)e);
        }
    }

    public static EditingDomain extractEditingDomain(IEclipseContext context) {
        EditingDomain editingDomain = (EditingDomain)context.get(EditingDomain.class);
        if (editingDomain != null) {
            return editingDomain;
        }
        IEditingDomainProvider provider = (IEditingDomainProvider)context.get(IEditingDomainProvider.class);
        if (provider != null) {
            return provider.getEditingDomain();
        }
        EditingDomainRegistry registry = (EditingDomainRegistry)context.get(EditingDomainRegistry.class);
        if (registry instanceof IEditingDomainProvider) {
            provider = (IEditingDomainProvider)registry;
            return provider.getEditingDomain();
        }
        return null;
    }
}

