/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.equinox.app.ApplicationBranding;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AboutDialog
extends Dialog {
    private static final String PRODUCT_NAME = "%product.name";
    private static final String ABOUT_IMAGE = "aboutImage";
    private static final String ABOUT_TITLE = "%aboutTitle";
    private static final String PRODUCT_BUNDLE_URL = "platform:/plugin/%s";
    private static final String PRODUCT_BUNDLE_ABOUT_IMAGE = "%s//%s";
    private Image productLogo;
    private final TranslationService translations;
    private final IApplicationContext applicationContext;
    private final String bundleUrl;

    public AboutDialog(Shell parentShell, IEclipseContext context) {
        super(parentShell);
        this.translations = (TranslationService)context.get(TranslationService.class);
        this.applicationContext = (IApplicationContext)context.get(IApplicationContext.class);
        this.bundleUrl = String.format(PRODUCT_BUNDLE_URL, this.applicationContext.getBrandingBundle().getSymbolicName());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String pattern = this.translations.translate(ABOUT_TITLE, this.bundleUrl);
        String name = this.translations.translate(PRODUCT_NAME, this.bundleUrl);
        newShell.setText(NLS.bind((String)pattern, (Object)name));
        newShell.setImage(LicensingImages.getImage((String)"IMG_DEFAULT"));
    }

    protected Control createDialogArea(Composite parent) {
        ImageDescriptor imgDescriptor;
        URL url;
        GridLayout workLayout = this.getLayoutDialogArea();
        Composite base = new Composite(parent, 2048);
        base.setLayout((Layout)workLayout);
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        String productImg = this.applicationContext.getBrandingProperty(ABOUT_IMAGE);
        if (productImg != null && (url = this.getUrl(productImg)) != null && (imgDescriptor = ImageDescriptor.createFromURL((URL)url)) != null) {
            this.productLogo = imgDescriptor.createImage();
        }
        GridData lblGridData = new GridData(4, 4, true, true);
        Label lblProductLogo = new Label(base, 2048);
        if (this.productLogo != null) {
            lblProductLogo.setImage(this.productLogo);
        }
        lblProductLogo.setLayoutData((Object)lblGridData);
        GridData txtData = new GridData(4, 4, true, true);
        String aboutText = ApplicationBranding.getAboutText((IApplicationContext)this.applicationContext);
        StyledText txtProductDescription = new StyledText(base, 74);
        txtProductDescription.setLayoutData((Object)txtData);
        txtProductDescription.setText(aboutText);
        txtProductDescription.setEditable(false);
        return parent;
    }

    private GridLayout getLayoutDialogArea() {
        GridLayout workLayout = new GridLayout(2, false);
        workLayout.marginHeight = 0;
        workLayout.marginWidth = 0;
        workLayout.verticalSpacing = 0;
        workLayout.horizontalSpacing = 5;
        return workLayout;
    }

    private URL getUrl(String productImg) {
        try {
            URL url = new URL(String.format(PRODUCT_BUNDLE_ABOUT_IMAGE, this.bundleUrl, productImg));
            URL found = FileLocator.find((URL)url);
            return found;
        }
        catch (MalformedURLException e) {
            Logger.getLogger(AboutDialog.class.getName()).log(Level.INFO, e.getMessage(), e);
            return null;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData btnData = new GridData(131072, 4, true, false, 1, 1);
        Button btnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        btnOk.setLayoutData((Object)btnData);
    }

    public boolean close() {
        if (this.productLogo != null) {
            this.productLogo.dispose();
            this.productLogo = null;
        }
        return super.close();
    }
}

