/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.base.condition;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.passage.lbc.base.condition.ConditionTimerTask;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;

public class ServerConditionsArbitr {
    List<LicensingCondition> reservedConditions = new ArrayList<LicensingCondition>();
    List<LicensingCondition> leaseConditions = new ArrayList<LicensingCondition>();
    List<ConditionTimerTask> reservedConditionTasks = new ArrayList<ConditionTimerTask>();
    List<ConditionTimerTask> leasedConditionTasks = new ArrayList<ConditionTimerTask>();
    Logger logger = Logger.getLogger(ServerConditionsArbitr.class.getName());

    public boolean addConditionToReserv(LicensingCondition condition) {
        boolean isReserved = false;
        if (this.leaseConditions.contains(condition)) {
            this.logger.info("Condition in lease");
            return isReserved;
        }
        if (this.reservedConditions.contains(condition)) {
            this.logger.info("Condition in reserv");
            return isReserved;
        }
        isReserved = this.createTaskForReserving(condition);
        if (isReserved) {
            isReserved = this.reservedConditions.add(condition);
        }
        return isReserved;
    }

    public boolean addConditionToLease(LicensingCondition condition) {
        boolean isLeased = false;
        if (this.leaseConditions.contains(condition)) {
            this.logger.info("Condition already in lease");
            return isLeased;
        }
        if (this.reservedConditions.contains(condition)) {
            isLeased = this.createTaskForLeasing(condition);
            if (isLeased) {
                isLeased = this.leaseConditions.add(condition);
            }
        } else {
            this.logger.info("Condition was not reserved");
        }
        return isLeased;
    }

    private boolean createTaskForLeasing(final LicensingCondition condition) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nowPlusDay = now.plusDays(1L);
        ConditionTimerTask task = new ConditionTimerTask(nowPlusDay.toString()){

            @Override
            void timeExpired() {
                ServerConditionsArbitr.this.leasedConditionTasks.remove(this);
                ServerConditionsArbitr.this.leaseConditions.remove(condition);
            }
        };
        return this.leasedConditionTasks.add(task);
    }

    private boolean createTaskForReserving(final LicensingCondition condition) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nowPlusMinute = now.plusMinutes(1L);
        ConditionTimerTask task = new ConditionTimerTask(nowPlusMinute.toString()){

            @Override
            void timeExpired() {
                ServerConditionsArbitr.this.reservedConditionTasks.remove(this);
                ServerConditionsArbitr.this.reservedConditions.remove(condition);
            }
        };
        return this.reservedConditionTasks.add(task);
    }

    public LicensingCondition checkoutReservedCondition(LicensingCondition condition) {
        if (this.reservedConditions.contains(condition) && this.reservedConditions.remove(condition)) {
            this.leaseConditions.add(condition);
            return condition;
        }
        return null;
    }
}

