/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.nebula.cwt.v.IControlPainter;
import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VLayout;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.nebula.cwt.v.VTracker;
import org.eclipse.nebula.widgets.cdatetime.AnalogClockPainter;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.nebula.widgets.cdatetime.DatePicker;
import org.eclipse.nebula.widgets.cdatetime.Resources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Listener;

class AnalogTimePicker
extends VPanel {
    VPanel dialPanel;
    VButton timeNow;
    VButton timeAmPm;
    CDateTime digitalClock;
    int dialRadius;
    Point dialCenter = new Point(0, 0);
    boolean setH = false;
    boolean setM = false;
    boolean setS = false;
    boolean overHour = false;
    boolean overMin = false;
    boolean overSec = false;
    boolean is24Hour;
    boolean hourHand;
    boolean minHand;
    boolean secHand;
    boolean am_pm;
    boolean compact;
    private int[] snap = new int[]{1, 1};
    long increment = 300000L;
    private CDateTime cdt;
    String pattern;
    private Listener tapl;

    public AnalogTimePicker(CDateTime parent) {
        super(parent.pickerPanel, parent.style);
        this.cdt = parent;
        this.compact = (this.cdt.style & 0x8000) != 0;
        this.createContents();
    }

    public AnalogTimePicker(CDateTime cdt, DatePicker parent) {
        super((VPanel)parent, 0);
        this.cdt = cdt;
        this.compact = (cdt.style & 0x8000) != 0;
        this.createContents();
    }

    protected void createContents() {
        this.setLayout(new BaseLayout());
        this.dialPanel = new VPanel((VPanel)this, 0);
        this.dialPanel.setLayout((VLayout)new DialLayout());
        this.timeAmPm = new VButton(this.dialPanel, 524288);
        this.timeAmPm.setText("PM");
        this.timeAmPm.setForeground(this.getDisplay().getSystemColor(10));
        this.timeAmPm.setMargins(4, 4);
        this.timeAmPm.setEnabled(!this.dialPanel.hasStyle(8192));
        this.tapl = event -> {
            if (event.widget == null) {
                Calendar tmpcal;
                tmpcal.set(9, (tmpcal = this.cdt.getCalendarInstance()).get(9) == 0 ? 1 : 0);
                this.setSelection(tmpcal.getTime());
                this.cdt.fireSelectionChanged(9);
            }
        };
        this.timeAmPm.addListener(13, this.tapl);
        this.timeAmPm.addListener(37, this.tapl);
        Listener listener = event -> {
            if (this.cdt.getEditable()) {
                switch (event.type) {
                    case 27: {
                        if (!VTracker.isMouseDown()) break;
                        this.handleMouseUp();
                        this.overSec = false;
                        this.overMin = false;
                        this.overHour = false;
                        this.redraw();
                        break;
                    }
                    case 3: {
                        this.handleMouseDown();
                        break;
                    }
                    case 5: {
                        this.handleMouseMove(event.x, event.y);
                        break;
                    }
                    case 4: {
                        this.handleMouseUp();
                        break;
                    }
                    case 37: {
                        this.handleMouseWheel(event.count);
                    }
                }
            }
        };
        this.dialPanel.addListener(27, listener);
        this.dialPanel.addListener(3, listener);
        this.dialPanel.addListener(5, listener);
        this.dialPanel.addListener(4, listener);
        this.dialPanel.addListener(37, listener);
        this.dialPanel.setPainter((IControlPainter)new AnalogClockPainter(this.cdt, this));
    }

    public int[] getFields() {
        return new int[]{11, 10, 12, 13, 9};
    }

    long getIncrement() {
        return this.increment;
    }

    int[] getSnap() {
        return this.snap;
    }

    private void handleMouseDown() {
        if (this.overHour) {
            this.setH = true;
        } else if (this.overMin) {
            this.setM = true;
        } else if (this.overSec) {
            this.setS = true;
        }
        if (this.setH || this.setM || this.setS) {
            this.dialPanel.getComposite().setCursor(this.getDisplay().getSystemCursor(5));
            if (this.timeAmPm != null) {
                this.timeAmPm.setEnabled(false);
            }
        }
    }

    private void handleMouseMove(int x, int y) {
        double val;
        Calendar tmpcal = this.cdt.getCalendarInstance();
        int dx = x - this.dialCenter.x;
        int dy = y - this.dialCenter.y;
        if (dx == 0) {
            val = dy > 0 ? 30.0 : 0.0;
        } else if (dy == 0) {
            val = dx > 0 ? 15.0 : 45.0;
        } else {
            val = 30.0 * Math.atan((double)dy / (double)dx) / Math.PI + 15.0;
            if (dx < 0) {
                val += 30.0;
            }
        }
        if (this.setH) {
            val = this.is24Hour ? val / 2.5 : val / 5.0;
            int v = (int)(val - (double)tmpcal.get(12) / 60.0 + 0.5);
            if (this.is24Hour && v > 23) {
                v = 23;
            }
            if (!this.is24Hour && v > 11) {
                v = 11;
            }
            int field = this.is24Hour ? 11 : 10;
            tmpcal.set(field, v);
            this.setSelection(tmpcal.getTime());
        } else if (this.setM) {
            int v = (int)(val + 0.5);
            if (v > 59) {
                v = 59;
            }
            tmpcal.set(12, v);
            this.setSelection(tmpcal.getTime());
        } else if (this.setS) {
            int v = (int)(val + 0.5);
            if (v > 59) {
                v = 59;
            }
            tmpcal.set(13, v);
            this.setSelection(tmpcal.getTime());
        } else {
            boolean rd = false;
            if (this.overHour || this.overMin || this.overSec) {
                rd = true;
            }
            this.overHour = false;
            this.overMin = false;
            this.overSec = false;
            if (Math.sqrt(dx * dx + dy * dy) < (double)this.dialRadius) {
                double h = ((double)tmpcal.get(this.is24Hour ? 11 : 10) + (double)tmpcal.get(12) / 60.0) * (this.is24Hour ? 2.5 : 5.0);
                int m = tmpcal.get(12);
                int s = tmpcal.get(13);
                if (this.hourHand && val - 1.0 < h && h <= val + 1.0) {
                    this.overHour = true;
                    rd = true;
                } else if (this.minHand && val - 1.0 < (double)m && (double)m <= val + 1.0) {
                    this.overMin = true;
                    rd = true;
                } else if (this.secHand && val - 1.0 < (double)s && (double)s <= val + 1.0) {
                    this.overSec = true;
                    rd = true;
                }
            }
            if (rd) {
                this.dialPanel.redraw();
            }
        }
    }

    private void handleMouseUp() {
        this.dialPanel.getComposite().setCursor(this.getDisplay().getSystemCursor(0));
        if (this.timeAmPm != null) {
            this.timeAmPm.setEnabled(true);
        }
        if (this.setH) {
            int field = this.is24Hour ? 11 : 10;
            this.cdt.fireSelectionChanged(field);
        } else if (this.setM) {
            this.cdt.fireSelectionChanged(12);
        } else if (this.setS) {
            this.cdt.fireSelectionChanged(13);
        }
        this.setS = false;
        this.setM = false;
        this.setH = false;
    }

    private void handleMouseWheel(int count) {
        long time = this.cdt.getCalendarTimeInMillis();
        this.setSelection(this.snap(new Date(time += count > 0 ? this.increment : -this.increment), true));
        this.cdt.fireSelectionChanged();
    }

    public void setFields(int[] calendarFields) {
        this.is24Hour = false;
        this.hourHand = false;
        this.minHand = false;
        this.secHand = false;
        this.am_pm = false;
        int[] nArray = calendarFields;
        int n = calendarFields.length;
        int n2 = 0;
        while (n2 < n) {
            int field = nArray[n2];
            if (field == 11) {
                this.is24Hour = true;
            } else if (field == 10) {
                this.hourHand = true;
            } else if (field == 12) {
                this.minHand = true;
            } else if (field == 13) {
                this.secHand = true;
            } else if (field == 9) {
                this.am_pm = true;
            }
            ++n2;
        }
        if ((this.cdt.style & 0x10000000) != 0) {
            this.is24Hour = false;
            this.hourHand = true;
            this.am_pm = true;
        } else if ((this.cdt.style & 0x20000000) != 0) {
            this.is24Hour = true;
        }
        if (this.is24Hour) {
            this.hourHand = true;
            this.am_pm = false;
        }
        this.timeAmPm.setVisible(this.am_pm);
        boolean sepOK = false;
        this.pattern = "";
        String cdtPattern = this.cdt.getPattern();
        int i = 0;
        while (i < cdtPattern.length()) {
            char c = cdtPattern.charAt(i);
            if ("Hhmsa".indexOf(c) > -1) {
                this.pattern = String.valueOf(this.pattern) + c;
                sepOK = true;
            } else {
                if (sepOK && ":., ".indexOf(c) > -1) {
                    this.pattern = String.valueOf(this.pattern) + c;
                }
                sepOK = false;
            }
            ++i;
        }
        if (this.digitalClock != null) {
            this.digitalClock.setPattern(this.pattern);
        }
        this.updateLabels();
    }

    public boolean setFocus() {
        if (this.timeNow != null) {
            return this.timeNow.setFocus();
        }
        return this.getComposite().forceFocus();
    }

    void setIncrement(long millis) {
        this.increment = millis;
    }

    private void setSelection(Date date) {
        this.cdt.setSelection(this.snap(date));
    }

    void setSnap(int min, int sec) {
        this.snap[0] = min < 0 ? 1 : min;
        this.snap[1] = sec < 0 ? 1 : sec;
    }

    public boolean setStyle(int style, boolean set) {
        if ((style & 8) != 0) {
            if (this.timeAmPm != null && !this.timeAmPm.isDisposed()) {
                this.timeAmPm.setEnabled(!set);
            }
            if (this.timeNow != null && !this.timeNow.isDisposed()) {
                this.timeNow.setEnabled(!set);
            }
        }
        return super.setStyle(style, set);
    }

    private Date snap(Date date) {
        return this.snap(date, false);
    }

    private Date snap(Date date, boolean toIncrement) {
        Calendar tmpcal = this.cdt.getCalendarInstance();
        tmpcal.setTime(date);
        int msnap = toIncrement ? (int)(this.increment / 60000L) : this.snap[0];
        int v = tmpcal.get(12);
        int m = v % msnap;
        if (m != 0) {
            if ((v += m > msnap / 2 ? msnap - m : -m) > 59) {
                v = 0;
            }
            tmpcal.set(12, v);
        }
        if (!toIncrement && (m = (v = tmpcal.get(13)) % this.snap[1]) != 0) {
            if ((v += m > this.snap[1] / 2 ? this.snap[1] - m : -m) > 59) {
                v = 0;
            }
            tmpcal.set(13, v);
        }
        return tmpcal.getTime();
    }

    void updateLabels() {
        if (this.timeNow != null) {
            this.timeNow.setToolTipText(Resources.getString("nav_current_time", this.cdt.getLocale()));
        }
    }

    void updateView() {
        if (this.digitalClock != null) {
            this.digitalClock.setSelection(new Date(this.cdt.getCalendarTimeInMillis()));
        }
        if (this.timeAmPm != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("a");
            sdf.setTimeZone(this.cdt.getTimeZone());
            this.timeAmPm.setText(sdf.format(this.cdt.getCalendarTime()));
        }
        this.dialPanel.redraw();
        this.dialPanel.update();
    }

    class BaseLayout
    extends VLayout {
        BaseLayout() {
        }

        protected Point computeSize(VPanel panel, int wHint, int hHint, boolean flushCache) {
            Point size = AnalogTimePicker.this.dialPanel.computeSize(wHint, hHint, flushCache);
            if (AnalogTimePicker.this.digitalClock != null) {
                size.y += AnalogTimePicker.this.digitalClock.computeSize((int)wHint, (int)hHint, (boolean)flushCache).y;
            }
            return size;
        }

        protected void layout(VPanel panel, boolean flushCache) {
            Rectangle clientArea = panel.getClientArea();
            Point dclockSize = AnalogTimePicker.this.digitalClock != null ? AnalogTimePicker.this.digitalClock.computeSize(-1, -1, flushCache) : new Point(0, 0);
            int dwidth = clientArea.width;
            int dheight = Math.min(dwidth, clientArea.height - dclockSize.y);
            if (dheight < dwidth) {
                dwidth = dheight;
            }
            int dx = clientArea.x + (clientArea.width - dwidth) / 2;
            int dy = clientArea.y + (clientArea.height - dheight - dclockSize.y) / 2;
            AnalogTimePicker.this.dialPanel.setBounds(dx, dy, dwidth, dheight);
            if (AnalogTimePicker.this.digitalClock != null) {
                AnalogTimePicker.this.digitalClock.setBounds(clientArea.x + (clientArea.width - dclockSize.x) / 2, dy + dheight, dclockSize.x, dclockSize.y);
            }
        }
    }

    class DialLayout
    extends VLayout {
        DialLayout() {
        }

        protected Point computeSize(VPanel panel, int wHint, int hHint, boolean flushCache) {
            return new Point(200, 200);
        }

        protected void layout(VPanel panel, boolean flushCache) {
            Rectangle r = panel.getClientArea();
            AnalogTimePicker.this.dialRadius = (Math.min(r.width, r.height) - 10) / 2;
            AnalogTimePicker.this.dialCenter.x = r.x + r.width / 2;
            AnalogTimePicker.this.dialCenter.y = r.y + r.height / 2;
            if (AnalogTimePicker.this.timeNow != null) {
                AnalogTimePicker.this.timeNow.setBounds(AnalogTimePicker.this.dialCenter.x - 11, AnalogTimePicker.this.dialCenter.y - 11, 22, 22);
            }
            if (AnalogTimePicker.this.timeAmPm != null) {
                Point size = AnalogTimePicker.this.timeAmPm.computeSize(-1, -1);
                AnalogTimePicker.this.timeAmPm.setBounds(AnalogTimePicker.this.dialCenter.x - size.x / 2, AnalogTimePicker.this.dialCenter.y + AnalogTimePicker.this.dialRadius / 3 - size.y / 4, size.x, size.y);
            }
        }
    }
}

