/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.manipulation;

import java.util.Objects;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.manipulation.FileBuffersMessages;
import org.eclipse.core.filebuffers.manipulation.MultiTextEditWithProgress;
import org.eclipse.core.filebuffers.manipulation.TextFileBufferOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertLineDelimitersOperation
extends TextFileBufferOperation {
    private String fLineDelimiter;

    public ConvertLineDelimitersOperation(String lineDelimiter) {
        super(FileBuffersMessages.ConvertLineDelimitersOperation_name);
        this.fLineDelimiter = lineDelimiter;
    }

    @Override
    protected MultiTextEditWithProgress computeTextEdit(ITextFileBuffer fileBuffer, IProgressMonitor progressMonitor) throws CoreException {
        IDocument document = fileBuffer.getDocument();
        int lineCount = document.getNumberOfLines();
        try {
            String original = document.get();
            int newLengthGuess = original.length() + (this.fLineDelimiter.length() - 1) * lineCount;
            StringBuilder sb = new StringBuilder(newLengthGuess);
            int i = 0;
            while (i < lineCount) {
                int offset = document.getLineOffset(i);
                int length = document.getLineLength(i);
                String delim = document.getLineDelimiter(i);
                sb.append(original, offset, offset + length - (delim == null ? 0 : delim.length()));
                if (delim != null) {
                    sb.append(this.fLineDelimiter);
                }
                ++i;
            }
            String replaced = sb.toString();
            MultiTextEditWithProgress multiEdit = new MultiTextEditWithProgress(FileBuffersMessages.ConvertLineDelimitersOperation_task_applyingChanges);
            multiEdit.addChild((TextEdit)new ReplaceEdit(0, document.getLength(), replaced));
            return Objects.equals(replaced, original) ? null : multiEdit;
        }
        catch (IndexOutOfBoundsException | BadLocationException x) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 1, "", x));
        }
    }

    @Override
    protected DocumentRewriteSessionType getDocumentRewriteSessionType() {
        return DocumentRewriteSessionType.SEQUENTIAL;
    }
}

