/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.setup.Argument;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.MacroTask;
import org.eclipse.oomph.setup.Parameter;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.util.StringUtil;

public class ArgumentItemProvider
extends ModelElementItemProvider {
    public ArgumentItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addParameterPropertyDescriptor(object);
            this.addValuePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addParameterPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Argument_parameter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Argument_parameter_feature", "_UI_Argument_type"), (EStructuralFeature)SetupPackage.Literals.ARGUMENT__PARAMETER, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptor createItemPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
        if (feature == SetupPackage.Literals.ARGUMENT__PARAMETER) {
            return new ModelElementItemProvider.HierarchicalPropertyDescriptor(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags){

                protected IItemLabelProvider createLabelProvider() {
                    return new ModelElementItemProvider.HierarchicalItemLabelProvider(this.itemDelegator){

                        public String getText(Object object) {
                            String description;
                            String text = super.getText(object);
                            Parameter parameter = (Parameter)object;
                            if (parameter != null && !StringUtil.isEmpty((String)(description = parameter.getDescription()))) {
                                text = String.valueOf(text) + " - " + description;
                            }
                            return text;
                        }

                        protected Object getParent(Object object) {
                            return null;
                        }
                    };
                }

                public Collection<?> getChoiceOfValues(Object object) {
                    return ArgumentItemProvider.this.filterChoices(super.getChoiceOfValues(object), this.feature, object);
                }
            };
        }
        return super.createItemPropertyDescriptor(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags);
    }

    protected Collection<?> filterChoices(Collection<?> choices, EStructuralFeature feature, Object object) {
        Macro macro;
        Argument argument;
        MacroTask macroTask;
        if (feature == SetupPackage.Literals.ARGUMENT__PARAMETER && (macroTask = (argument = (Argument)object).getMacroTask()) != null && (macro = macroTask.getMacro()) != null) {
            ArrayList result = new ArrayList(macro.getParameters());
            EList arguments = macroTask.getArguments();
            for (Argument otherArgument : arguments) {
                if (otherArgument == argument) continue;
                result.remove(otherArgument.getParameter());
            }
            return result;
        }
        return super.filterChoices(choices, feature, object);
    }

    protected void addValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Argument_value_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Argument_value_feature", "_UI_Argument_type"), (EStructuralFeature)SetupPackage.Literals.ARGUMENT__VALUE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Argument"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String value;
        String label;
        Argument argument = (Argument)object;
        Parameter parameter = argument.getParameter();
        String string = label = parameter == null ? null : parameter.getName();
        if (StringUtil.isEmpty((String)label)) {
            label = "<no-parameter>";
        }
        if ((value = argument.getValue()) != null) {
            label = value.length() == 0 ? String.valueOf(label) + " = \"\"" : String.valueOf(label) + " = " + value;
        } else {
            String defaultValue;
            String string2 = defaultValue = parameter == null ? null : parameter.getDefaultValue();
            if (defaultValue != null) {
                label = defaultValue.length() == 0 ? String.valueOf(label) + " (default: \"\")" : String.valueOf(label) + " (default: " + defaultValue + ")";
            }
        }
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Argument.class)) {
            case 3: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

