/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.impl;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.predicates.NaturePredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.impl.PredicateImpl;

public class NaturePredicateImpl
extends PredicateImpl
implements NaturePredicate {
    protected static final String NATURE_EDEFAULT = null;
    protected String nature = NATURE_EDEFAULT;

    protected NaturePredicateImpl() {
    }

    protected EClass eStaticClass() {
        return PredicatesPackage.Literals.NATURE_PREDICATE;
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String newNature) {
        String oldNature = this.nature;
        this.nature = newNature;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldNature, (Object)this.nature));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matches(IResource resource) {
        if (resource == null) return false;
        try {
            String[] natureIds;
            IProject project = resource.getProject();
            String[] stringArray = natureIds = project.getDescription().getNatureIds();
            int n = natureIds.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String natureId = stringArray[n2];
                if (natureId.equals(this.nature)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getNature();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setNature((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setNature(NATURE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return NATURE_EDEFAULT == null ? this.nature != null : !NATURE_EDEFAULT.equals(this.nature);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (nature: ");
        result.append(this.nature);
        result.append(')');
        return result.toString();
    }
}

