/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.p2.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.CertificateConfirmer;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileCreator;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.CacheUsageConfirmer;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.setup.LicenseInfo;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.internal.p2.SetupP2Plugin;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Package;
import org.eclipse.oomph.setup.p2.util.P2TaskUISevices;
import org.eclipse.oomph.util.Confirmer;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2TaskImpl
extends SetupTaskImpl
implements P2Task {
    private static final boolean SKIP = PropertiesUtil.isProperty((String)"oomph.setup.p2.skip");
    private static final boolean FORCE = PropertiesUtil.isProperty((String)"oomph.setup.p2.force");
    private static final Object FIRST_CALL_DETECTION_KEY = new Object();
    protected static final String LABEL_EDEFAULT = null;
    protected String label = LABEL_EDEFAULT;
    protected EList<Requirement> requirements;
    protected EList<Repository> repositories;
    protected static final boolean LICENSE_CONFIRMATION_DISABLED_EDEFAULT = false;
    protected boolean licenseConfirmationDisabled = false;
    protected static final boolean MERGE_DISABLED_EDEFAULT = false;
    protected boolean mergeDisabled = false;

    protected P2TaskImpl() {
    }

    protected EClass eStaticClass() {
        return SetupP2Package.Literals.P2_TASK;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String newLabel) {
        String oldLabel = this.label;
        this.label = newLabel;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLabel, (Object)this.label));
        }
    }

    @Override
    public EList<Requirement> getRequirements() {
        if (this.requirements == null) {
            this.requirements = new EObjectContainmentEList(Requirement.class, (InternalEObject)this, 11);
        }
        return this.requirements;
    }

    @Override
    public EList<Repository> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new EObjectContainmentEList(Repository.class, (InternalEObject)this, 12);
        }
        return this.repositories;
    }

    @Override
    public boolean isLicenseConfirmationDisabled() {
        return this.licenseConfirmationDisabled;
    }

    @Override
    public void setLicenseConfirmationDisabled(boolean newLicenseConfirmationDisabled) {
        boolean oldLicenseConfirmationDisabled = this.licenseConfirmationDisabled;
        this.licenseConfirmationDisabled = newLicenseConfirmationDisabled;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldLicenseConfirmationDisabled, this.licenseConfirmationDisabled));
        }
    }

    @Override
    public boolean isMergeDisabled() {
        return this.mergeDisabled;
    }

    @Override
    public void setMergeDisabled(boolean newMergeDisabled) {
        boolean oldMergeDisabled = this.mergeDisabled;
        this.mergeDisabled = newMergeDisabled;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldMergeDisabled, this.mergeDisabled));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 11: {
                return ((InternalEList)this.getRequirements()).basicRemove((Object)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getRepositories()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getLabel();
            }
            case 11: {
                return this.getRequirements();
            }
            case 12: {
                return this.getRepositories();
            }
            case 13: {
                return this.isLicenseConfirmationDisabled();
            }
            case 14: {
                return this.isMergeDisabled();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setLabel((String)newValue);
                return;
            }
            case 11: {
                this.getRequirements().clear();
                this.getRequirements().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getRepositories().clear();
                this.getRepositories().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.setLicenseConfirmationDisabled((Boolean)newValue);
                return;
            }
            case 14: {
                this.setMergeDisabled((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setLabel(LABEL_EDEFAULT);
                return;
            }
            case 11: {
                this.getRequirements().clear();
                return;
            }
            case 12: {
                this.getRepositories().clear();
                return;
            }
            case 13: {
                this.setLicenseConfirmationDisabled(false);
                return;
            }
            case 14: {
                this.setMergeDisabled(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return LABEL_EDEFAULT == null ? this.label != null : !LABEL_EDEFAULT.equals(this.label);
            }
            case 11: {
                return this.requirements != null && !this.requirements.isEmpty();
            }
            case 12: {
                return this.repositories != null && !this.repositories.isEmpty();
            }
            case 13: {
                return this.licenseConfirmationDisabled;
            }
            case 14: {
                return this.mergeDisabled;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (label: ");
        result.append(this.label);
        result.append(", licenseConfirmationDisabled: ");
        result.append(this.licenseConfirmationDisabled);
        result.append(", mergeDisabled: ");
        result.append(this.mergeDisabled);
        result.append(')');
        return result.toString();
    }

    public int getPriority() {
        return 200;
    }

    public Object getOverrideToken() {
        if (this.isMergeDisabled()) {
            return super.getOverrideToken();
        }
        return this.getClass();
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        P2Task overriddenP2Task = (P2Task)overriddenSetupTask;
        this.getRequirements().addAll(overriddenP2Task.getRequirements());
        this.getRepositories().addAll(overriddenP2Task.getRepositories());
        String overriddenLabel = overriddenP2Task.getLabel();
        if (!StringUtil.isEmpty((String)overriddenLabel)) {
            String label = this.getLabel();
            if (!StringUtil.isEmpty((String)label)) {
                UniqueEList labelSegments = new UniqueEList((Collection)SegmentSequence.create((String)" + ", (String)overriddenLabel).segmentsList());
                labelSegments.addAll(SegmentSequence.create((String)" + ", (String)label).segmentsList());
                overriddenLabel = SegmentSequence.create((String)" + ", (String[])labelSegments.toArray(new String[labelSegments.size()])).toString();
            }
            this.setLabel(overriddenLabel);
        }
    }

    public void consolidate() {
        HashSet<String> installableUnitKeys = new HashSet<String>();
        Iterator it = this.getRequirements().iterator();
        while (it.hasNext()) {
            Requirement requirement = (Requirement)it.next();
            String name = requirement.getName();
            if (!StringUtil.isEmpty((String)name) && installableUnitKeys.add(String.valueOf(name) + "->" + requirement.getVersionRange().toString())) continue;
            it.remove();
        }
        EList<Repository> repositories = this.getRepositories();
        HashSet<String> repositoryKeys = new HashSet<String>();
        HashSet<Repository> releaseTrainAlternates = new HashSet<Repository>();
        boolean containsReleaseTrain = false;
        Iterator it2 = repositories.iterator();
        while (it2.hasNext()) {
            String url;
            Repository repository = (Repository)it2.next();
            if (repository.getAnnotation("http://www.eclipse.org/oomph/setup/ReleaseTrain") != null) {
                containsReleaseTrain = true;
            }
            if (StringUtil.isEmpty((String)(url = repository.getURL())) || !repositoryKeys.add(url)) {
                it2.remove();
                continue;
            }
            if (repository.getAnnotation("http://www.eclipse.org/oomph/setup/ReleaseTrainAlternate") == null) continue;
            releaseTrainAlternates.add(repository);
        }
        if (containsReleaseTrain) {
            repositories.removeAll(releaseTrainAlternates);
        }
    }

    public int getProgressMonitorWork() {
        return 100;
    }

    private void addUnknownRepository(IRepositoryManager<?> repositoryManager, Set<String> knownRepositories, String url) {
        if (!knownRepositories.contains(url)) {
            try {
                repositoryManager.addRepository(new URI(url));
            }
            catch (Exception ex) {
                SetupP2Plugin.INSTANCE.log(ex);
            }
        }
    }

    private boolean isInstalled(Set<IInstallableUnit> installedUnits, String id, VersionRange versionRange) {
        for (IInstallableUnit installedUnit : installedUnits) {
            if (!id.equals(installedUnit.getId()) || !versionRange.isIncluded(installedUnit.getVersion())) continue;
            return true;
        }
        return false;
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        if (SKIP) {
            return FORCE;
        }
        Trigger trigger = context.getTrigger();
        if (trigger == Trigger.BOOTSTRAP) {
            return true;
        }
        if (context.isSelfHosting()) {
            return false;
        }
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        Profile profile = agent.getCurrentProfile();
        if (profile == null) {
            return FORCE;
        }
        IMetadataRepositoryManager metadataRepositoryManager = agent.getMetadataRepositoryManager();
        IArtifactRepositoryManager artifactRepositoryManager = agent.getArtifactRepositoryManager();
        Set knownMetadataRepositories = P2Util.getKnownRepositories((IRepositoryManager)metadataRepositoryManager);
        Set knownArtifactRepositories = P2Util.getKnownRepositories((IRepositoryManager)artifactRepositoryManager);
        for (Repository repository : this.getRepositories()) {
            String url = repository.getURL();
            this.addUnknownRepository((IRepositoryManager<?>)metadataRepositoryManager, knownMetadataRepositories, url);
            this.addUnknownRepository((IRepositoryManager<?>)artifactRepositoryManager, knownArtifactRepositories, url);
        }
        if (trigger == Trigger.MANUAL) {
            return true;
        }
        Set<IInstallableUnit> installedUnits = P2TaskImpl.getInstalledUnits(agent);
        LinkedHashSet<Requirement> unsatisifiedRequirements = new LinkedHashSet<Requirement>();
        for (Requirement requirement : this.getRequirements()) {
            if (!context.matchesFilterContext(requirement.getFilter()) || requirement.isOptional()) continue;
            String id = requirement.getName();
            VersionRange versionRange = requirement.getVersionRange();
            if (versionRange == null) {
                versionRange = VersionRange.emptyRange;
            }
            if (this.isInstalled(installedUnits, id, versionRange)) continue;
            unsatisifiedRequirements.add(requirement);
        }
        P2TaskUISevices p2TaskUISevices = (P2TaskUISevices)context.get(P2TaskUISevices.class);
        if (trigger == Trigger.STARTUP && !unsatisifiedRequirements.isEmpty() && p2TaskUISevices != null) {
            return p2TaskUISevices.handleUnsatisfiedRequirements(unsatisifiedRequirements, installedUnits);
        }
        return !unsatisifiedRequirements.isEmpty();
    }

    public void perform(final SetupTaskContext context) throws Exception {
        File eclipseDir = context.getProductLocation();
        boolean offline = context.isOffline();
        context.log("Offline = " + offline);
        boolean mirrors = context.isMirrors();
        context.log("Mirrors = " + mirrors);
        EList<Requirement> requirements = this.getRequirements();
        EList<Repository> repositories = this.getRepositories();
        context.log("Resolving " + requirements.size() + (requirements.size() == 1 ? " requirement" : " requirements") + " from " + repositories.size() + (repositories.size() == 1 ? " repository" : " repositories") + " to " + eclipseDir.getAbsolutePath());
        for (Requirement requirement : requirements) {
            context.log("Requirement " + requirement);
        }
        for (Repository repository : repositories) {
            context.log("Repository " + repository);
        }
        String profileID = IOUtil.encodeFileName((String)eclipseDir.toString());
        Profile profile = this.getProfile(context, profileID);
        ProfileTransaction transaction = profile.change();
        ProfileDefinition profileDefinition = transaction.getProfileDefinition();
        profileDefinition.setRequirements(requirements);
        profileDefinition.setRepositories(repositories);
        ProfileTransaction.CommitContext commitContext = new ProfileTransaction.CommitContext(){

            public boolean handleProvisioningPlan(ProfileTransaction.CommitContext.ResolutionInfo info) throws CoreException {
                try {
                    P2TaskImpl.this.processLicenses(context, info.getProvisioningPlan(), context.getProgressMonitor(false));
                }
                catch (Exception ex) {
                    SetupP2Plugin.INSTANCE.coreException(ex);
                }
                return true;
            }

            public Confirmer getUnsignedContentConfirmer() {
                return (Confirmer)context.get(Certificate.class);
            }

            public CertificateConfirmer getCertficateConfirmer() {
                return (CertificateConfirmer)context.get(CertificateConfirmer.class);
            }
        };
        transaction.setMirrors(mirrors);
        IProvisioningAgent provisioningAgent = profile.getAgent().getProvisioningAgent();
        CacheUsageConfirmer cacheUsageConfirmer = (CacheUsageConfirmer)context.get(CacheUsageConfirmer.class);
        CacheUsageConfirmer oldCacheUsageConfirmer = (CacheUsageConfirmer)provisioningAgent.getService(CacheUsageConfirmer.SERVICE_NAME);
        IProvisioningEventBus eventBus = null;
        ProvisioningListener provisioningListener = (ProvisioningListener)context.get(ProvisioningListener.class);
        if (provisioningListener != null && (eventBus = (IProvisioningEventBus)provisioningAgent.getService(IProvisioningEventBus.SERVICE_NAME)) != null) {
            eventBus.addListener(provisioningListener);
        }
        boolean originalBetterMirrorSelection = CachingRepositoryManager.enableBetterMirrorSelection();
        try {
            if (cacheUsageConfirmer != null) {
                provisioningAgent.registerService(CacheUsageConfirmer.SERVICE_NAME, (Object)cacheUsageConfirmer);
            }
            boolean profileChanged = transaction.commit(commitContext, context.getProgressMonitor(true));
            if (context.getTrigger() != Trigger.BOOTSTRAP) {
                if (profileChanged) {
                    context.setRestartNeeded("New software has been installed.");
                } else {
                    context.log("No software updates are available");
                }
            } else {
                context.put(Profile.class, (Object)profile);
            }
        }
        finally {
            CachingRepositoryManager.setBetterMirrorSelection((boolean)originalBetterMirrorSelection);
            if (eventBus != null) {
                eventBus.removeListener(provisioningListener);
            }
            if (cacheUsageConfirmer != null) {
                provisioningAgent.unregisterService(CacheUsageConfirmer.SERVICE_NAME, (Object)cacheUsageConfirmer);
                if (oldCacheUsageConfirmer != null) {
                    provisioningAgent.registerService(CacheUsageConfirmer.SERVICE_NAME, (Object)oldCacheUsageConfirmer);
                }
            }
        }
    }

    private Profile getProfile(SetupTaskContext context, String profileID) throws Exception {
        if (context.getTrigger() == Trigger.BOOTSTRAP) {
            UIServices uiServices;
            BundlePool bundlePool;
            boolean sharedPool;
            String bundlePoolLocation = (String)context.get((Object)"oomph.p2.pool");
            if (bundlePoolLocation != null && !"@none".equalsIgnoreCase(bundlePoolLocation)) {
                sharedPool = true;
                bundlePool = P2Util.getAgentManager().getBundlePool(new File(bundlePoolLocation));
                File eclipseExtensionFeaturesFolder = new File(bundlePoolLocation, ".eclipseextension/features");
                eclipseExtensionFeaturesFolder.mkdirs();
            } else {
                sharedPool = false;
                File agentLocation = new File(context.getProductLocation(), "p2");
                Agent agent = P2Util.createAgent((File)agentLocation);
                bundlePool = agent.addBundlePool(agentLocation.getParentFile());
            }
            IProvisioningAgent currentAgent = P2Util.getCurrentProvisioningAgent();
            bundlePool.getAgent().getProvisioningAgent().registerService("org.eclipse.equinox.p2.installer.agent", (Object)currentAgent);
            Profile profile = bundlePool.getProfile(profileID);
            if (profile != null && context.put(FIRST_CALL_DETECTION_KEY, (Object)Boolean.TRUE) == null) {
                profile.delete(true);
                profile = null;
            }
            if (profile == null) {
                OS os = context.getOS();
                ProfileCreator profileCreator = bundlePool.addProfile(profileID, "Installation");
                profileCreator.setInstallFeatures(true);
                profileCreator.setInstallFolder(context.getProductLocation());
                profileCreator.addOS(os.getOsgiOS());
                profileCreator.addWS(os.getOsgiWS());
                profileCreator.addArch(os.getOsgiArch());
                profileCreator.setRoaming(true);
                profileCreator.set("org.eclipse.oomph.p2.profile.shared.pool", sharedPool);
                profile = profileCreator.create();
            }
            if ((uiServices = (UIServices)context.get(UIServices.class)) != null) {
                IProvisioningAgent provisioningAgent = profile.getAgent().getProvisioningAgent();
                provisioningAgent.registerService(UIServices.SERVICE_NAME, (Object)uiServices);
            }
            return profile;
        }
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        Profile profile = agent.getCurrentProfile();
        return profile;
    }

    private void processLicenses(SetupTaskContext context, IProvisioningPlan provisioningPlan, IProgressMonitor monitor) throws Exception {
        if (this.isLicenseConfirmationDisabled()) {
            return;
        }
        User user = context.getUser();
        Confirmer licenseConfirmer = (Confirmer)context.get(ILicense.class);
        P2TaskImpl.processLicenses(provisioningPlan, licenseConfirmer, user, false, monitor);
    }

    public static void processLicenses(IProvisioningPlan provisioningPlan, Confirmer licenseConfirmer, User user, boolean saveChangedUser, IProgressMonitor monitor) {
        HashSet acceptedLicenses = new HashSet();
        if (user != null) {
            acceptedLicenses.addAll(user.getAcceptedLicenses());
        }
        HashMap<ILicense, ArrayList<IInstallableUnit>> licensesToIUs = new HashMap<ILicense, ArrayList<IInstallableUnit>>();
        HashSet<Pair> set = new HashSet<Pair>();
        IQueryable queryable = provisioningPlan.getAdditions();
        IQueryResult result = queryable.query(QueryUtil.ALL_UNITS, monitor);
        for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)result)) {
            Collection licenses = iu.getLicenses(null);
            for (ILicense license : licenses) {
                String uuid;
                if ("license".equals(license.getBody()) || acceptedLicenses.contains(new LicenseInfo(uuid = license.getUUID(), null))) continue;
                String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
                if (name == null) {
                    name = iu.getId();
                }
                if (!set.add(Pair.create((Object)license, (Object)name))) continue;
                ArrayList<IInstallableUnit> ius = (ArrayList<IInstallableUnit>)licensesToIUs.get(license);
                if (ius == null) {
                    ius = new ArrayList<IInstallableUnit>();
                    licensesToIUs.put(license, ius);
                }
                ius.add(iu);
            }
        }
        if (!licensesToIUs.isEmpty()) {
            Confirmer.Confirmation confirmation;
            if (licenseConfirmer == null) {
                licenseConfirmer = Confirmer.DECLINE;
            }
            if (!(confirmation = licenseConfirmer.confirm(false, licensesToIUs)).isConfirmed()) {
                throw new OperationCanceledException("Licenses have been declined");
            }
            if (user != null && confirmation.isRemember()) {
                for (ILicense license : licensesToIUs.keySet()) {
                    String uuid = license.getUUID();
                    String name = LicenseInfo.getFirstLine((String)license.getBody());
                    LicenseInfo licenseInfo = new LicenseInfo(uuid, name);
                    user.getAcceptedLicenses().add((Object)licenseInfo);
                }
                if (saveChangedUser) {
                    try {
                        XMLResource xmlResource = (XMLResource)user.eResource();
                        xmlResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                    }
                    catch (IOException ex) {
                        SetupP2Plugin.INSTANCE.log(ex);
                    }
                }
            }
        }
    }

    private static Set<IInstallableUnit> getInstalledUnits(Agent agent) {
        HashSet<IInstallableUnit> result = new HashSet<IInstallableUnit>();
        IProfileRegistry profileRegistry = agent.getProfileRegistry();
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile != null) {
            IQueryResult queryResult = profile.query(QueryUtil.createIUAnyQuery(), null);
            for (IInstallableUnit requirement : P2Util.asIterable((IQueryResult)queryResult)) {
                result.add(requirement);
            }
        }
        return result;
    }

    public static void saveConfigIni(File file, Map<String, String> properties, Class<?> caller) {
        PropertiesUtil.saveProperties((File)file, properties, (boolean)false, (boolean)true, (String)("This configuration file was written by: " + caller.getName()));
    }
}

