/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AgentAnalyzer {
    private final Agent agent;
    private final Map<File, BundlePool> bundlePools = new HashMap<File, BundlePool>();
    private final List<Job> analyzeProfileJobs = new ArrayList<Job>();
    private Set<URI> repositoryURIs;
    private Handler handler;

    public AgentAnalyzer(Agent agent, Handler handler) {
        this.agent = agent;
        this.handler = handler;
        IProfileRegistry profileRegistry = agent.getProfileRegistry();
        IProfile[] iProfileArray = profileRegistry.getProfiles();
        int n = iProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProfile p2Profile = iProfileArray[n2];
            String installFolder = p2Profile.getProperty("org.eclipse.equinox.p2.installFolder");
            String cache = p2Profile.getProperty("org.eclipse.equinox.p2.cache");
            if (cache != null && !cache.equals(installFolder)) {
                File location = new File(cache);
                BundlePool bundlePool = this.bundlePools.get(location);
                if (bundlePool == null) {
                    bundlePool = new BundlePool(this, location);
                    this.bundlePools.put(location, bundlePool);
                }
                bundlePool.addProfile(p2Profile, installFolder);
            }
            ++n2;
        }
        handler.analyzerChanged(this);
        for (BundlePool bundlePool : this.bundlePools.values()) {
            Job job = bundlePool.analyze();
            this.analyzeProfileJobs.add(job);
        }
    }

    public void dispose() {
        this.handler = null;
        for (Job job : this.analyzeProfileJobs) {
            job.cancel();
        }
        this.analyzeProfileJobs.clear();
        this.bundlePools.clear();
    }

    public Map<File, BundlePool> getBundlePools() {
        return this.bundlePools;
    }

    public Set<URI> getRepositoryURIs() {
        if (this.repositoryURIs == null) {
            this.repositoryURIs = new HashSet<URI>();
            IArtifactRepositoryManager repositoryManager = this.agent.getArtifactRepositoryManager();
            this.addURIs(this.repositoryURIs, repositoryManager, 2);
            for (BundlePool bundlePool : this.bundlePools.values()) {
                this.repositoryURIs.remove(bundlePool.getLocation().toURI());
            }
        }
        return this.repositoryURIs;
    }

    private void analyzerChanged(AgentAnalyzer analyzer) {
        if (this.handler != null) {
            this.handler.analyzerChanged(analyzer);
        }
    }

    private void bundlePoolChanged(BundlePool bundlePool, boolean artifacts, boolean profiles) {
        if (this.handler != null) {
            this.handler.bundlePoolChanged(bundlePool, artifacts, profiles);
        }
    }

    private void profileChanged(Profile profile) {
        if (this.handler != null) {
            this.handler.profileChanged(profile);
        }
    }

    private void artifactChanged(Artifact artifact) {
        if (this.handler != null) {
            this.handler.artifactChanged(artifact);
        }
    }

    private void addURIs(Set<URI> repos, IArtifactRepositoryManager repositoryManager, int flag) {
        URI[] uRIArray = repositoryManager.getKnownRepositories(flag);
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            repos.add(uri);
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Artifact
    implements Comparable<Artifact> {
        public static final String REPAIR_TASK_NAME = "Repairing artifacts";
        public static final String TYPE_FEATURE = "Feature";
        public static final String TYPE_PLUGIN = "Plugin";
        public static final String TYPE_BINARY = "Binary";
        private final BundlePool bundlePool;
        private final IArtifactKey key;
        private final String type;
        private final File file;
        private final List<Profile> profiles = new ArrayList<Profile>();
        private boolean damaged;

        public Artifact(BundlePool bundlePool, IArtifactKey key, File file) {
            this.bundlePool = bundlePool;
            this.key = key;
            this.file = file;
            String classifier = key.getClassifier();
            this.type = "org.eclipse.update.feature".equals(classifier) ? TYPE_FEATURE : ("osgi.bundle".equals(classifier) ? TYPE_PLUGIN : TYPE_BINARY);
        }

        public boolean isUnused() {
            return this.profiles.isEmpty();
        }

        public boolean isDamaged() {
            return this.damaged;
        }

        public BundlePool getBundlePool() {
            return this.bundlePool;
        }

        public IArtifactKey getKey() {
            return this.key;
        }

        public String getType() {
            return this.type;
        }

        public String getID() {
            return this.key.getId();
        }

        public String getVersion() {
            return this.key.getVersion().toString();
        }

        public File getFile() {
            return this.file;
        }

        public List<Profile> getProfiles() {
            return this.profiles;
        }

        @Override
        public int compareTo(Artifact o) {
            int result = this.key.getId().compareTo(o.key.getId());
            if (result == 0 && (result = this.key.getVersion().compareTo((Object)o.key.getVersion())) == 0) {
                result = this.type.compareTo(o.type);
            }
            return result;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Artifact other = (Artifact)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String toString() {
            return String.valueOf(this.key.getId()) + " " + this.key.getVersion();
        }

        void addProfile(Profile profile) {
            this.profiles.add(profile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDamaged() {
            this.damaged = true;
            for (Profile profile : this.profiles) {
                BundlePool bundlePool = this.bundlePool;
                synchronized (bundlePool) {
                    profile.damagedArtifacts.add(this);
                    profile.damagedArtifactsArray = null;
                }
                this.bundlePool.analyzer.handler.profileChanged(profile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void delete(IProgressMonitor monitor) {
            if (this.isUnused()) {
                this.deleteUnused(monitor);
            } else {
                monitor.subTask("Deleting " + this);
                IOUtil.deleteBestEffort((File)this.file);
                this.damaged = true;
                BundlePool bundlePool = this.bundlePool;
                synchronized (bundlePool) {
                    this.bundlePool.damagedArtifacts.add(this);
                    this.bundlePool.damagedArtifactsArray = null;
                }
                this.bundlePool.analyzer.bundlePoolChanged(this.bundlePool, false, false);
                this.bundlePool.analyzer.artifactChanged(this);
                for (Profile profile : this.profiles) {
                    BundlePool bundlePool2 = this.bundlePool;
                    synchronized (bundlePool2) {
                        profile.damagedArtifacts.add(this);
                        profile.damagedArtifactsArray = null;
                    }
                    this.bundlePool.analyzer.profileChanged(profile);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteUnused(IProgressMonitor monitor) {
            monitor.subTask("Deleting " + this);
            IFileArtifactRepository p2BundlePool = this.bundlePool.getP2BundlePool(monitor);
            p2BundlePool.removeDescriptor(this.key, monitor);
            this.damaged = false;
            BundlePool bundlePool = this.bundlePool;
            synchronized (bundlePool) {
                this.bundlePool.artifacts.remove(this.key);
                this.bundlePool.artifactsArray = null;
                this.bundlePool.unusedArtifacts.remove(this);
                this.bundlePool.unusedArtifactsArray = null;
                this.bundlePool.damagedArtifacts.remove(this);
                this.bundlePool.damagedArtifactsArray = null;
            }
            this.bundlePool.analyzer.bundlePoolChanged(this.bundlePool, true, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean repair(Set<URI> repositoryURIs, IProgressMonitor monitor) {
            if (!this.damaged) {
                return false;
            }
            if (this.isUnused()) {
                this.deleteUnused(monitor);
                return true;
            }
            monitor.subTask("Repairing " + this);
            if (repositoryURIs == null ? this.doRepair(monitor) : this.doRepair(repositoryURIs, monitor)) {
                this.damaged = false;
                this.bundlePool.analyzer.artifactChanged(this);
                BundlePool bundlePool = this.bundlePool;
                synchronized (bundlePool) {
                    this.bundlePool.damagedArtifacts.remove(this);
                    this.bundlePool.damagedArtifactsArray = null;
                }
                for (Profile profile : this.profiles) {
                    BundlePool bundlePool2 = this.bundlePool;
                    synchronized (bundlePool2) {
                        profile.damagedArtifacts.remove(this);
                        profile.damagedArtifactsArray = null;
                    }
                    this.bundlePool.analyzer.profileChanged(profile);
                }
                this.bundlePool.analyzer.bundlePoolChanged(this.bundlePool, false, false);
                return true;
            }
            return false;
        }

        private boolean doRepair(IProgressMonitor monitor) {
            Set<URI> repositoryURIs = this.bundlePool.getRepositoryURIs();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + repositoryURIs.size())).detectCancelation();
            HashSet<URI> poolURIs = new HashSet<URI>();
            for (BundlePool pool : this.bundlePool.analyzer.getBundlePools().values()) {
                Artifact otherArtifact;
                if (pool == this.bundlePool || (otherArtifact = pool.getArtifact(this.key)) == null || otherArtifact.isDamaged()) continue;
                URI uri = pool.getLocation().toURI();
                poolURIs.add(uri);
            }
            if (!poolURIs.isEmpty() && this.doRepair(poolURIs, (IProgressMonitor)progress)) {
                return true;
            }
            return !repositoryURIs.isEmpty() && this.doRepair(repositoryURIs, (IProgressMonitor)progress);
        }

        private boolean doRepair(Set<URI> repositoryURIs, IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)repositoryURIs.size()).detectCancelation();
            for (URI uri : repositoryURIs) {
                if (!this.doRepair(uri, progress.newChild())) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean doRepair(URI repositoryURI, SubMonitor progress) {
            IFileArtifactRepository p2BundlePool = this.bundlePool.getP2BundlePool((IProgressMonitor)progress.newChild());
            IArtifactDescriptor[] localDescriptors = null;
            try {
                IArtifactDescriptor[] remoteDescriptors;
                localDescriptors = p2BundlePool.getArtifactDescriptors(this.key);
                if (localDescriptors == null) return false;
                if (localDescriptors.length == 0) {
                    return false;
                }
                p2BundlePool.removeDescriptors(localDescriptors, (IProgressMonitor)progress.newChild());
                IArtifactRepositoryManager repositoryManager = this.bundlePool.analyzer.agent.getArtifactRepositoryManager();
                IArtifactRepository repository = repositoryManager.loadRepository(repositoryURI, (IProgressMonitor)progress.newChild());
                progress.setTaskName(REPAIR_TASK_NAME);
                IArtifactDescriptor[] iArtifactDescriptorArray = remoteDescriptors = repository.getArtifactDescriptors(this.key);
                int n = remoteDescriptors.length;
                int n2 = 0;
                while (true) {
                    OutputStream destination;
                    block9: {
                        if (n2 >= n) {
                            return false;
                        }
                        IArtifactDescriptor remoteDescriptor = iArtifactDescriptorArray[n2];
                        destination = null;
                        try {
                            destination = p2BundlePool.getOutputStream(localDescriptors[0]);
                            IStatus status = repository.getArtifact(remoteDescriptor, destination, (IProgressMonitor)progress.newChild());
                            if (status.getSeverity() != 0) break block9;
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(destination);
                            throw throwable;
                        }
                        IOUtil.close((Closeable)destination);
                        return true;
                    }
                    IOUtil.close((Closeable)destination);
                    ++n2;
                }
            }
            catch (OperationCanceledException ex) {
                this.restoreDescriptors(p2BundlePool, localDescriptors);
                throw ex;
            }
            catch (Error err) {
                this.restoreDescriptors(p2BundlePool, localDescriptors);
                throw err;
            }
            catch (Exception ex) {
                this.restoreDescriptors(p2BundlePool, localDescriptors);
                P2CorePlugin.INSTANCE.log(ex);
            }
            return false;
        }

        private void restoreDescriptors(IFileArtifactRepository p2BundlePool, IArtifactDescriptor[] oldDescriptors) {
            if (oldDescriptors != null && oldDescriptors.length != 0) {
                try {
                    p2BundlePool.addDescriptors(oldDescriptors, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception ex) {
                    P2CorePlugin.INSTANCE.log(ex);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BundlePool
    implements Comparable<BundlePool> {
        private final AgentAnalyzer analyzer;
        private final File location;
        private final Set<URI> repositoryURIs = new LinkedHashSet<URI>();
        private final List<Profile> profiles = new ArrayList<Profile>();
        private final Map<IArtifactKey, Artifact> artifacts = new HashMap<IArtifactKey, Artifact>();
        private final Set<Artifact> unusedArtifacts = new HashSet<Artifact>();
        private final Set<Artifact> damagedArtifacts = new HashSet<Artifact>();
        private int damagedArtifactsPercent;
        private Artifact[] artifactsArray;
        private Artifact[] unusedArtifactsArray;
        private Artifact[] damagedArtifactsArray;
        private IFileArtifactRepository p2BundlePool;

        public BundlePool(AgentAnalyzer analyzer, File location) {
            this.analyzer = analyzer;
            this.location = location;
        }

        public AgentAnalyzer getAnalyzer() {
            return this.analyzer;
        }

        public File getLocation() {
            return this.location;
        }

        public Set<URI> getRepositoryURIs() {
            return this.repositoryURIs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getProfilesCount() {
            BundlePool bundlePool = this;
            synchronized (bundlePool) {
                return this.profiles.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Profile[] getProfiles() {
            List<Profile> list = this.profiles;
            synchronized (list) {
                return this.profiles.toArray(new Profile[this.profiles.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getArtifactCount() {
            BundlePool bundlePool = this;
            synchronized (bundlePool) {
                return this.artifacts.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Artifact[] getArtifacts() {
            BundlePool bundlePool = this;
            synchronized (bundlePool) {
                if (this.artifactsArray == null) {
                    this.artifactsArray = this.artifacts.values().toArray(new Artifact[this.artifacts.size()]);
                    Arrays.sort(this.artifactsArray);
                }
                return this.artifactsArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Artifact getArtifact(IArtifactKey key) {
            BundlePool bundlePool = this;
            synchronized (bundlePool) {
                return this.artifacts.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getUnusedArtifactsCount() {
            BundlePool bundlePool = this;
            synchronized (bundlePool) {
                return this.unusedArtifacts.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Artifact[] getUnusedArtifacts() {
            BundlePool bundlePool = this;
            synchronized (bundlePool) {
                if (this.unusedArtifactsArray == null) {
                    this.unusedArtifactsArray = this.unusedArtifacts.toArray(new Artifact[this.unusedArtifacts.size()]);
                    Arrays.sort(this.unusedArtifactsArray);
                }
                return this.unusedArtifactsArray;
            }
        }

        public int getDamagedArtifactsPercent() {
            return this.damagedArtifactsPercent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getDamagedArtifactsCount() {
            Set<Artifact> set = this.damagedArtifacts;
            synchronized (set) {
                return this.damagedArtifacts.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Artifact[] getDamagedArtifacts() {
            BundlePool bundlePool = this;
            synchronized (bundlePool) {
                if (this.damagedArtifactsArray == null) {
                    this.damagedArtifactsArray = this.damagedArtifacts.toArray(new Artifact[this.damagedArtifacts.size()]);
                    Arrays.sort(this.damagedArtifactsArray);
                }
                return this.damagedArtifactsArray;
            }
        }

        @Override
        public int compareTo(BundlePool o) {
            return this.location.getAbsolutePath().compareTo(o.getLocation().getAbsolutePath());
        }

        public String toString() {
            return this.location.toString();
        }

        synchronized IFileArtifactRepository getP2BundlePool(IProgressMonitor monitor) {
            if (this.p2BundlePool == null) {
                try {
                    IArtifactRepositoryManager repositoryManager = this.analyzer.agent.getArtifactRepositoryManager();
                    this.p2BundlePool = (IFileArtifactRepository)repositoryManager.loadRepository(this.location.toURI(), monitor);
                }
                catch (ProvisionException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            return this.p2BundlePool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Profile addProfile(IProfile p2Profile, String installFolder) {
            Profile profile = new Profile(this, p2Profile, installFolder == null ? null : new File(installFolder));
            this.repositoryURIs.addAll(profile.getRepositoryURIs());
            BundlePool bundlePool = this;
            synchronized (bundlePool) {
                this.profiles.add(profile);
                Collections.sort(this.profiles);
            }
            return profile;
        }

        Job analyze() {
            Job job = new Job("Analyzing bundle pool " + this.location){

                protected IStatus run(IProgressMonitor monitor) {
                    BundlePool.this.analyze(monitor);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            return job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void analyze(IProgressMonitor monitor) {
            Random random = new Random(System.currentTimeMillis());
            IFileArtifactRepository p2BundlePool = this.getP2BundlePool(monitor);
            for (IArtifactKey key : P2Util.asIterable(p2BundlePool.query((IQuery)ArtifactKeyQuery.ALL_KEYS, monitor))) {
                P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                File file = p2BundlePool.getArtifactFile(key);
                Artifact artifact = new Artifact(this, key, file);
                BundlePool bundlePool = this;
                synchronized (bundlePool) {
                    this.artifacts.put(key, artifact);
                    this.artifactsArray = null;
                }
                if (random.nextInt(100) >= 2) continue;
                this.analyzer.bundlePoolChanged(this, false, false);
            }
            this.analyzer.bundlePoolChanged(this, true, false);
            Profile[] profileArray = this.getProfiles();
            int n = profileArray.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                profile.analyze(monitor);
                ++n2;
            }
            this.analyzer.analyzerChanged(this.analyzer);
            this.analyzeUnusedArtifacts(monitor);
            this.analyzeDamagedArtifacts(monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void analyzeUnusedArtifacts(IProgressMonitor monitor) {
            Artifact[] artifactArray = this.getArtifacts();
            int n = artifactArray.length;
            int n2 = 0;
            while (n2 < n) {
                Artifact artifact = artifactArray[n2];
                P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                if (this.analyzeUnusedArtifact(artifact, monitor)) {
                    BundlePool bundlePool = this;
                    synchronized (bundlePool) {
                        this.unusedArtifacts.add(artifact);
                        this.unusedArtifactsArray = null;
                    }
                    this.analyzer.bundlePoolChanged(this, false, false);
                }
                ++n2;
            }
            this.analyzer.bundlePoolChanged(this, true, false);
        }

        private boolean analyzeUnusedArtifact(Artifact artifact, IProgressMonitor monitor) {
            Profile[] profileArray = this.getProfiles();
            int n = profileArray.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                if (profile.getArtifacts().contains(artifact)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void analyzeDamagedArtifacts(IProgressMonitor monitor) {
            Artifact[] artifacts = this.getArtifacts();
            int total = artifacts.length;
            int i = 0;
            Artifact[] artifactArray = artifacts;
            int n = artifacts.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    Artifact artifact = artifactArray[n2];
                    P2CorePlugin.checkCancelation((IProgressMonitor)monitor);
                    int percent = ++i * 100 / total;
                    if (percent != this.damagedArtifactsPercent) {
                        this.damagedArtifactsPercent = percent;
                        this.analyzer.bundlePoolChanged(this, false, false);
                    }
                    Comparable<Artifact> comparable = artifact;
                    synchronized (comparable) {
                        IArtifactKey key = artifact.getKey();
                        if (this.getArtifact(key) == null) {
                            break block10;
                        }
                    }
                    monitor.subTask("Validating " + artifact);
                    if (BundlePool.isDamaged(artifact)) {
                        comparable = this;
                        synchronized (comparable) {
                            this.damagedArtifacts.add(artifact);
                            this.damagedArtifactsArray = null;
                        }
                        this.analyzer.bundlePoolChanged(this, false, false);
                        artifact.setDamaged();
                        this.analyzer.artifactChanged(artifact);
                    }
                }
                ++n2;
            }
            this.analyzer.bundlePoolChanged(this, false, false);
        }

        /*
         * Exception decompiling
         */
        private static boolean isDamaged(Artifact artifact) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static interface Handler {
        public void analyzerChanged(AgentAnalyzer var1);

        public void bundlePoolChanged(BundlePool var1, boolean var2, boolean var3);

        public void profileChanged(Profile var1);

        public void artifactChanged(Artifact var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Profile
    implements Comparable<Profile> {
        public static final String ECLIPSE = "Eclipse";
        public static final String TARGLET = "Targlet";
        public static final String UNKNOWN = "Unknown";
        @Deprecated
        private static final String PROP_TARGLET_CONTAINER_ID = "targlet.container.id";
        @Deprecated
        private static final String PROP_REPO_LIST = "setup.repo.list";
        private final BundlePool bundlePool;
        private final IProfile p2Profile;
        private final File installFolder;
        private final String type;
        private final Set<URI> repositoryURIs = new LinkedHashSet<URI>();
        private final Set<Artifact> artifacts = new HashSet<Artifact>();
        private final Set<Artifact> damagedArtifacts = new HashSet<Artifact>();
        private Artifact[] damagedArtifactsArray;

        public Profile(BundlePool bundlePool, IProfile p2Profile, File installFolder) {
            this.bundlePool = bundlePool;
            this.p2Profile = p2Profile;
            this.installFolder = installFolder;
            this.type = p2Profile.getProperty(PROP_TARGLET_CONTAINER_ID) != null ? TARGLET : (installFolder != null ? ECLIPSE : UNKNOWN);
            String repoList = p2Profile.getProperty(PROP_REPO_LIST);
            if (repoList != null) {
                StringTokenizer tokenizer = new StringTokenizer(repoList, ",");
                while (tokenizer.hasMoreTokens()) {
                    String uri = tokenizer.nextToken();
                    try {
                        this.repositoryURIs.add(new URI(uri));
                    }
                    catch (URISyntaxException ex) {
                        P2CorePlugin.INSTANCE.log(ex);
                    }
                }
            }
        }

        public BundlePool getBundlePool() {
            return this.bundlePool;
        }

        public String getID() {
            return this.p2Profile.getProfileId();
        }

        public File getInstallFolder() {
            return this.installFolder;
        }

        public String getType() {
            return this.type;
        }

        public Set<URI> getRepositoryURIs() {
            return this.repositoryURIs;
        }

        public Set<Artifact> getArtifacts() {
            return this.artifacts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDamaged() {
            BundlePool bundlePool = this.bundlePool;
            synchronized (bundlePool) {
                return !this.damagedArtifacts.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getDamagedArtifactsCount() {
            BundlePool bundlePool = this.bundlePool;
            synchronized (bundlePool) {
                return this.damagedArtifacts.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Artifact[] getDamagedArtifacts() {
            BundlePool bundlePool = this.bundlePool;
            synchronized (bundlePool) {
                if (this.damagedArtifactsArray == null) {
                    this.damagedArtifactsArray = this.damagedArtifacts.toArray(new Artifact[this.damagedArtifacts.size()]);
                    Arrays.sort(this.damagedArtifactsArray);
                }
                return this.damagedArtifactsArray;
            }
        }

        @Override
        public int compareTo(Profile o) {
            return this.getID().compareTo(o.getID());
        }

        public String toString() {
            return this.getID();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void analyze(IProgressMonitor monitor) {
            for (IInstallableUnit iu : P2Util.asIterable(this.p2Profile.query(QueryUtil.createIUAnyQuery(), monitor))) {
                for (IArtifactKey key : iu.getArtifacts()) {
                    Artifact artifact = this.bundlePool.getArtifact(key);
                    if (artifact == null) continue;
                    BundlePool bundlePool = this.bundlePool;
                    synchronized (bundlePool) {
                        this.artifacts.add(artifact);
                        artifact.addProfile(this);
                    }
                    this.bundlePool.analyzer.profileChanged(this);
                }
            }
        }
    }
}

