/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.oomph.p2.internal.core.P2Index;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.ITargletContainerDescriptor;
import org.eclipse.oomph.targlets.internal.ui.TargletsUIPlugin;
import org.eclipse.oomph.targlets.presentation.TargletEditor;
import org.eclipse.oomph.targlets.provider.TargletItemProviderAdapterFactory;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.pde.ui.target.ITargetLocationEditor;
import org.eclipse.pde.ui.target.ITargetLocationUpdater;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class TargletContainerUI
implements IAdapterFactory,
ITargetLocationEditor,
ITargetLocationUpdater {
    private static final Class<?>[] ADAPTERS = new Class[]{ITreeContentProvider.class, ILabelProvider.class, ITargetLocationEditor.class, ITargetLocationUpdater.class};
    private static final Object[] NO_CHILDREN = new Object[0];
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final AdapterFactoryContentProvider contentProvider;
    private final AdapterFactoryLabelProvider labelProvider;

    public TargletContainerUI() {
        this.adapterFactory.addAdapterFactory((AdapterFactory)new TargletItemProviderAdapterFactory(true));
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory);
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    }

    public Class[] getAdapterList() {
        return ADAPTERS;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof ITargletContainer) {
            if (adapterType == ITreeContentProvider.class) {
                return new ContainerContentProvider();
            }
            if (adapterType == ILabelProvider.class) {
                return new ContainerLabelProvider();
            }
            if (adapterType == ITargetLocationEditor.class) {
                return this;
            }
            if (adapterType == ITargetLocationUpdater.class) {
                return this;
            }
        }
        return null;
    }

    public boolean canEdit(ITargetDefinition target, ITargetLocation targetLocation) {
        return targetLocation instanceof ITargletContainer;
    }

    public IWizard getEditWizard(ITargetDefinition target, ITargetLocation targetLocation) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TargletEditor.open((IWorkbenchPage)page, (String)((ITargletContainer)targetLocation).getID());
        TargletContainerUI.simulateEscapeKey();
        TargletContainerUI.simulateEscapeKey();
        return null;
    }

    public boolean canUpdate(ITargetDefinition target, ITargetLocation targetLocation) {
        return targetLocation instanceof ITargletContainer;
    }

    public IStatus update(ITargetDefinition target, ITargetLocation targetLocation, IProgressMonitor monitor) {
        return ((ITargletContainer)targetLocation).updateProfile(monitor);
    }

    private static void simulateEscapeKey() {
        Display display = UIUtil.getDisplay();
        Event event = new Event();
        event.type = 1;
        event.character = (char)27;
        display.post(event);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
        event.type = 2;
        display.post(event);
        display.post(event);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContainerContentProvider
    implements ITreeContentProvider {
        private StatusWrapper missingIUInfo;

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ITargletContainer) {
                ITargletContainer location = (ITargletContainer)element;
                ArrayList<Object> children = new ArrayList<Object>();
                ITargletContainerDescriptor descriptor = location.getDescriptor();
                if (descriptor != null) {
                    ITargletContainerDescriptor.UpdateProblem updateProblem = descriptor.getUpdateProblem();
                    if (updateProblem != null) {
                        IStatus status = updateProblem.toStatus();
                        children.add(new StatusWrapper(status));
                        if (descriptor.getWorkingDigest() != null) {
                            children.add(new StatusWrapper("Content is available from the last working profile"));
                        }
                        try {
                            if (updateProblem instanceof ITargletContainerDescriptor.UpdateProblem.MissingIU) {
                                if (this.missingIUInfo == null) {
                                    ITargletContainerDescriptor.UpdateProblem.MissingIU missingIU = (ITargletContainerDescriptor.UpdateProblem.MissingIU)updateProblem;
                                    VersionRange range = new VersionRange(missingIU.getRange());
                                    HashSet<P2Index.Repository> repositories = new HashSet<P2Index.Repository>();
                                    Map simpleResult = P2Index.INSTANCE.lookupCapabilities(missingIU.getNamespace(), missingIU.getName());
                                    this.collectRepositories(simpleResult, range, repositories);
                                    Map composedResult = P2Index.INSTANCE.generateCapabilitiesFromComposedRepositories(simpleResult);
                                    this.collectRepositories(composedResult, range, repositories);
                                    if (!repositories.isEmpty()) {
                                        this.missingIUInfo = new StatusWrapper("Found " + repositories.size() + " " + "repositories that satisfy " + missingIU.getNamespace() + "/" + missingIU.getName() + " " + missingIU.getRange());
                                        for (P2Index.Repository repository : repositories) {
                                            this.missingIUInfo.addChild(new StatusWrapper(repository.getLocation() + "  (" + (repository.isComposed() ? "composed" : "simple") + ": " + repository.getCapabilityCount() + ")"));
                                        }
                                    }
                                }
                                children.add(this.missingIUInfo);
                            }
                        }
                        catch (Exception ex) {
                            TargletsUIPlugin.INSTANCE.log(ex);
                        }
                    } else {
                        for (Object targlet : location.getTarglets()) {
                            children.add(new Wrapper(targlet));
                        }
                    }
                }
                return children.toArray(new Object[children.size()]);
            }
            return NO_CHILDREN;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object getParent(Object element) {
            return null;
        }

        private void collectRepositories(Map<P2Index.Repository, Set<Version>> result, VersionRange range, Set<P2Index.Repository> repositories) {
            block0: for (Map.Entry<P2Index.Repository, Set<Version>> entry : result.entrySet()) {
                for (Version version : entry.getValue()) {
                    if (!range.isIncluded(version)) continue;
                    repositories.add(entry.getKey());
                    continue block0;
                }
            }
        }
    }

    private static class ContainerLabelProvider
    extends StyledBundleLabelProvider {
        public ContainerLabelProvider() {
            super(true, false);
        }

        public Image getImage(Object element) {
            if (element instanceof ITargletContainer) {
                ITargletContainerDescriptor.UpdateProblem updateProblem;
                ITargletContainer location = (ITargletContainer)element;
                String key = "targlet_container";
                ITargletContainerDescriptor descriptor = location.getDescriptor();
                if (descriptor != null && (updateProblem = descriptor.getUpdateProblem()) != null) {
                    key = String.valueOf(key) + "_problem";
                }
                return TargletsUIPlugin.INSTANCE.getSWTImage(key);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ITargletContainer) {
                return ((ITargletContainer)element).toString();
            }
            return super.getText(element);
        }
    }

    private static final class StatusWrapper
    implements ITreeContentProvider,
    ILabelProvider {
        private final int severity;
        private final String message;
        private final List<StatusWrapper> children = new ArrayList<StatusWrapper>();

        public StatusWrapper(int severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public StatusWrapper(IStatus delegate) {
            this(delegate.getSeverity(), delegate.getMessage());
            IStatus[] iStatusArray = delegate.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.children.add(new StatusWrapper(child));
                ++n2;
            }
        }

        public StatusWrapper(String message) {
            this(1, message);
        }

        public void addChild(StatusWrapper child) {
            this.children.add(child);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            return this.children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return !this.children.isEmpty();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return UIUtil.getStatusImage((int)this.severity);
        }

        public String getText(Object element) {
            return this.message;
        }

        public String toString() {
            return this.message;
        }
    }

    private final class Wrapper
    implements ITreeContentProvider,
    ILabelProvider {
        private final Object wrappedObject;

        public Wrapper(Object wrappedObject) {
            this.wrappedObject = wrappedObject;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            TargletContainerUI.this.contentProvider.inputChanged(viewer, oldInput, newInput);
        }

        public Object[] getElements(Object object) {
            return this.getChildren(this.wrappedObject);
        }

        public Object[] getChildren(Object object) {
            Object[] children = TargletContainerUI.this.contentProvider.getChildren(this.wrappedObject);
            int i = 0;
            while (i < children.length) {
                children[i] = new Wrapper(children[i]);
                ++i;
            }
            return children;
        }

        public boolean hasChildren(Object object) {
            return TargletContainerUI.this.contentProvider.hasChildren(this.wrappedObject);
        }

        public Object getParent(Object object) {
            return TargletContainerUI.this.contentProvider.getParent(this.wrappedObject);
        }

        public void addListener(ILabelProviderListener listener) {
            TargletContainerUI.this.labelProvider.addListener(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            TargletContainerUI.this.labelProvider.removeListener(listener);
        }

        public void dispose() {
            TargletContainerUI.this.labelProvider.dispose();
        }

        public boolean isLabelProperty(Object object, String id) {
            return TargletContainerUI.this.labelProvider.isLabelProperty(this.wrappedObject, id);
        }

        public Image getImage(Object object) {
            return TargletContainerUI.this.labelProvider.getImage(this.wrappedObject);
        }

        public String getText(Object object) {
            return TargletContainerUI.this.labelProvider.getText(this.wrappedObject);
        }
    }
}

