/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core.listeners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.TargletContainerEvent;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.targlets.internal.core.listeners.FileUpdater;
import org.eclipse.oomph.targlets.internal.core.listeners.WorkspaceUpdateListener;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PomModulesUpdater
extends WorkspaceUpdateListener {
    public static final String ANNOTATION = "http:/www.eclipse.org/oomph/targlets/PomModulesUpdater";
    public static final String ANNOTATION_LOCATION = "location";
    private static final Pattern MODULES_PATTERN = Pattern.compile("([ \\t]*)<modules>.*?</modules>", 32);

    @Override
    protected void handleTargletContainerEvent(TargletContainerEvent.ProfileUpdateSucceededEvent profileUpdateSucceededEvent, TargletContainerEvent.WorkspaceUpdateFinishedEvent workspaceUpdateFinishedEvent, IProgressMonitor monitor) throws Exception {
        ITargletContainer targletContainer = profileUpdateSucceededEvent.getSource();
        for (Targlet targlet : targletContainer.getTarglets()) {
            String location;
            Annotation annotation = targlet.getAnnotation(ANNOTATION);
            if (annotation == null || StringUtil.isEmpty((String)(location = (String)annotation.getDetails().get((Object)ANNOTATION_LOCATION)))) continue;
            File mainPom = new File(location);
            if (mainPom.isFile()) {
                Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos = profileUpdateSucceededEvent.getWorkspaceIUInfos();
                PomModulesUpdater.updatePomModules(mainPom, workspaceIUInfos, monitor);
                continue;
            }
            TargletsCorePlugin.INSTANCE.log("Not a file: " + mainPom, 2);
        }
    }

    private static void updatePomModules(final File mainPom, final Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos, final IProgressMonitor monitor) throws Exception {
        monitor.subTask("Checking for POM modules updates");
        new FileUpdater(){

            protected String createNewContents(String oldContents, String encoding, String nl) {
                Matcher matcher = MODULES_PATTERN.matcher(oldContents);
                if (matcher.find()) {
                    String start = oldContents.substring(0, matcher.start(0));
                    String end = oldContents.substring(matcher.end(0));
                    String indent = matcher.group(1);
                    StringBuilder builder = new StringBuilder();
                    builder.append(start);
                    builder.append(indent);
                    builder.append("<modules>");
                    builder.append(nl);
                    List modules = PomModulesUpdater.analyzeProjects(mainPom, workspaceIUInfos, monitor);
                    for (String module : modules) {
                        builder.append(indent);
                        builder.append(indent);
                        builder.append("<module>");
                        builder.append(module);
                        builder.append("</module>");
                        builder.append(nl);
                    }
                    builder.append(indent);
                    builder.append("</modules>");
                    builder.append(end);
                    return builder.toString();
                }
                return null;
            }

            protected void setContents(URI uri, String encoding, String contents) throws IOException {
                monitor.subTask("Updating " + (uri.isPlatformResource() ? uri.toPlatformString(true) : uri.toFileString()));
                super.setContents(uri, encoding, contents);
            }
        }.update(mainPom);
    }

    private static List<String> analyzeProjects(File mainPom, Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos, IProgressMonitor monitor) {
        URI mainURI = URI.createFileURI((String)mainPom.getAbsolutePath());
        ArrayList<String> modules = new ArrayList<String>();
        for (WorkspaceIUInfo info : workspaceIUInfos.values()) {
            TargletsCorePlugin.checkCancelation((IProgressMonitor)monitor);
            File folder = info.getLocation();
            File pom = new File(folder, "pom.xml");
            if (!pom.isFile()) continue;
            URI uri = URI.createFileURI((String)folder.getAbsolutePath()).deresolve(mainURI);
            modules.add(uri.toString());
        }
        Collections.sort(modules);
        return modules;
    }
}

