/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.util.stream.DoubleStream;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.factory.set.primitive.ImmutableDoubleSetFactory;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableDoubleEmptySet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableDoubleSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

public enum ImmutableDoubleSetFactoryImpl implements ImmutableDoubleSetFactory
{
    INSTANCE;


    @Override
    public ImmutableDoubleSet empty() {
        return ImmutableDoubleEmptySet.INSTANCE;
    }

    @Override
    public ImmutableDoubleSet of() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleSet with() {
        return this.empty();
    }

    @Override
    public ImmutableDoubleSet of(double one) {
        return this.with(one);
    }

    @Override
    public ImmutableDoubleSet with(double one) {
        return new ImmutableDoubleSingletonSet(one);
    }

    @Override
    public ImmutableDoubleSet of(double ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableDoubleSet with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return DoubleHashSet.newSetWith(items).toImmutable();
    }

    @Override
    public ImmutableDoubleSet ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableDoubleSet withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleSet) {
            return (ImmutableDoubleSet)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableDoubleSet ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableDoubleSet withAll(Iterable<Double> iterable) {
        return DoubleSets.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableDoubleSet ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableDoubleSet withAll(DoubleStream items) {
        return this.with(items.toArray());
    }
}

