/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.css.swt.dom;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class ControlSelectedColorCustomization {
    public static final String SELECTION_FOREGROUND_COLOR = "org.eclipse.e4.ui.css.swt.selectionForegroundColor";
    public static final String SELECTION_BACKGROUND_COLOR = "org.eclipse.e4.ui.css.swt.selectionBackgroundColor";
    public static final String SELECTION_BORDER_COLOR = "org.eclipse.e4.ui.css.swt.selectionBorderColor";
    public static final String HOT_BACKGROUND_COLOR = "org.eclipse.e4.ui.css.swt.hotBackgroundColor";
    public static final String HOT_BORDER_COLOR = "org.eclipse.e4.ui.css.swt.hotBorderColor";
    private final Control fControl;
    private final Listener fEraseListener;

    public ControlSelectedColorCustomization(Control control, Listener eraseListener) {
        this.fControl = control;
        this.fEraseListener = eraseListener;
    }

    private void setEraseListener(Control control) {
        control.removeListener(40, this.fEraseListener);
        control.addListener(40, this.fEraseListener);
    }

    public void setSelectionForegroundColor(Color color) {
        this.fControl.setData(SELECTION_FOREGROUND_COLOR, (Object)color);
        this.setEraseListener(this.fControl);
    }

    public Color getSelectionForegroundColor() {
        return ControlSelectedColorCustomization.getSelectionForegroundColor(this.fControl);
    }

    public static Color getSelectionForegroundColor(Control control) {
        Object data = control.getData(SELECTION_FOREGROUND_COLOR);
        if (data instanceof Color) {
            return (Color)data;
        }
        return null;
    }

    public void setSelectionBackgroundColor(Color color) {
        this.fControl.setData(SELECTION_BACKGROUND_COLOR, (Object)color);
        this.setEraseListener(this.fControl);
    }

    public Color getSelectionBackgroundColor() {
        return ControlSelectedColorCustomization.getSelectionBackgroundColor(this.fControl);
    }

    public static Color getSelectionBackgroundColor(Control control) {
        Object data = control.getData(SELECTION_BACKGROUND_COLOR);
        if (data instanceof Color) {
            return (Color)data;
        }
        return null;
    }

    public void setSelectionBorderColor(Color color) {
        this.fControl.setData(SELECTION_BORDER_COLOR, (Object)color);
        this.setEraseListener(this.fControl);
    }

    public Color getSelectionBorderColor() {
        return ControlSelectedColorCustomization.getSelectionBorderColor(this.fControl);
    }

    public static Color getSelectionBorderColor(Control control) {
        Object data = control.getData(SELECTION_BORDER_COLOR);
        if (data instanceof Color) {
            return (Color)data;
        }
        return null;
    }

    public void setHotBackgroundColor(Color color) {
        this.fControl.setData(HOT_BACKGROUND_COLOR, (Object)color);
        this.setEraseListener(this.fControl);
    }

    public Color getHotBackgroundColor() {
        return ControlSelectedColorCustomization.getHotBackgroundColor(this.fControl);
    }

    public static Color getHotBackgroundColor(Control fControl) {
        Object data = fControl.getData(HOT_BACKGROUND_COLOR);
        if (data instanceof Color) {
            return (Color)data;
        }
        return null;
    }

    public void setHotBorderColor(Color color) {
        this.fControl.setData(HOT_BORDER_COLOR, (Object)color);
        this.setEraseListener(this.fControl);
    }

    public Color getHotBorderColor() {
        return ControlSelectedColorCustomization.getHotBorderColor(this.fControl);
    }

    public static Color getHotBorderColor(Control control) {
        Object data = control.getData(HOT_BORDER_COLOR);
        if (data instanceof Color) {
            return (Color)data;
        }
        return null;
    }
}

