/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.event.FreezeEvent;
import org.eclipse.nebula.widgets.nattable.freeze.event.UnfreezeEvent;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class FreezeHelper {
    public static void freeze(FreezeLayer freezeLayer, ViewportLayer viewportLayer, PositionCoordinate topLeftPosition, PositionCoordinate bottomRightPosition) {
        if (freezeLayer == null || viewportLayer == null) {
            throw new IllegalArgumentException("freezeLayer and viewportLayer can not be null!");
        }
        if (topLeftPosition != null && bottomRightPosition != null) {
            freezeLayer.setTopLeftPosition(topLeftPosition.columnPosition, topLeftPosition.rowPosition);
            freezeLayer.setBottomRightPosition(bottomRightPosition.columnPosition, bottomRightPosition.rowPosition);
            IUniqueIndexLayer scrollableLayer = viewportLayer.getScrollableLayer();
            int originX = bottomRightPosition.columnPosition == scrollableLayer.getColumnCount() - 1 ? scrollableLayer.getWidth() : scrollableLayer.getStartXOfColumnPosition(bottomRightPosition.columnPosition + 1);
            int originY = bottomRightPosition.rowPosition == scrollableLayer.getRowCount() - 1 ? scrollableLayer.getHeight() : scrollableLayer.getStartYOfRowPosition(bottomRightPosition.rowPosition + 1);
            viewportLayer.setMinimumOrigin(originX, originY);
            viewportLayer.setOriginX(0);
            viewportLayer.setOriginY(0);
            viewportLayer.fireLayerEvent(new FreezeEvent(viewportLayer));
        }
    }

    public static void unfreeze(FreezeLayer freezeLayer, ViewportLayer viewportLayer) {
        if (freezeLayer == null || viewportLayer == null) {
            throw new IllegalArgumentException("freezeLayer and viewportLayer can not be null!");
        }
        FreezeHelper.resetViewport(freezeLayer, viewportLayer);
        freezeLayer.setTopLeftPosition(-1, -1);
        freezeLayer.setBottomRightPosition(-1, -1);
        viewportLayer.fireLayerEvent(new UnfreezeEvent(viewportLayer));
    }

    public static void resetViewport(FreezeLayer freezeLayer, ViewportLayer viewportLayer) {
        PositionCoordinate topLeftPosition = freezeLayer.getTopLeftPosition();
        viewportLayer.resetOrigin(viewportLayer.getScrollableLayer().getStartXOfColumnPosition(Math.max(0, topLeftPosition.columnPosition)), viewportLayer.getScrollableLayer().getStartYOfRowPosition(Math.max(0, topLeftPosition.rowPosition)));
    }
}

