/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.action;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.search.CellValueAsStringComparator;
import org.eclipse.nebula.widgets.nattable.search.gui.SearchDialog;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;

public class SearchAction
implements IKeyAction {
    private static Context activeContext;
    private static SearchDialog dialog;
    private Context context;

    public SearchAction() {
        this(null, null, true);
    }

    public SearchAction(NatTable natTable, IDialogSettings dialogSettings) {
        this(natTable, dialogSettings, false);
        if (natTable == null) {
            throw new IllegalArgumentException();
        }
    }

    private SearchAction(NatTable natTable, IDialogSettings dialogSettings, boolean modal) {
        this.context = new Context(natTable, dialogSettings, modal);
        if (natTable != null) {
            natTable.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    SearchAction.this.setActiveContext();
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }
    }

    protected void setActiveContext() {
        if (dialog != null && !this.isEquivalentToActiveContext()) {
            dialog.close();
            dialog = null;
        }
        activeContext = this.context;
        if (dialog != null) {
            dialog.setInput(this.context.natTable, this.context.dialogSettings);
        }
    }

    private boolean isEquivalentToActiveContext() {
        if (this.context.modal) {
            return this.context.equals(activeContext);
        }
        if (activeContext.modal) {
            return false;
        }
        return !SearchAction.activeContext.natTable.isDisposed() && this.context.natTable.getShell().equals(SearchAction.activeContext.natTable.getShell()) && this.context.dialogSettings.equals(SearchAction.activeContext.dialogSettings);
    }

    @Override
    public void run(NatTable natTable, KeyEvent event) {
        this.context.natTable = natTable;
        this.setActiveContext();
        if (dialog == null) {
            dialog = new SearchDialog(this.context.natTable.getShell(), new CellValueAsStringComparator(), this.context.modal ? 0 : 65536);
            dialog.setInput(this.context.natTable, this.context.dialogSettings);
        }
        dialog.open();
    }

    private static class Context {
        NatTable natTable;
        IDialogSettings dialogSettings;
        private boolean modal;

        Context(NatTable natTable, IDialogSettings dialogSettings, boolean modal) {
            this.natTable = natTable;
            this.dialogSettings = dialogSettings;
            this.modal = modal;
        }
    }
}

