/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.EditableRule;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.DataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.DefaultNumericDataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.PricingTypeBean;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataListFixture;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.action.ToggleCheckBoxColumnAction;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.PricingTypeBeanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultGridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ColumnHeaderCheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.CellPainterMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EditableGridExample
extends AbstractNatExample {
    public static final String ASK_PRICE_CONFIG_LABEL = "askPriceConfigLabel";
    public static final String SECURITY_ID_CONFIG_LABEL = "SecurityIdConfigLabel";
    public static final String SECURITY_ID_EDITOR = "SecurityIdEditor";
    public static final String BID_PRICE_CONFIG_LABEL = "bidPriceConfigLabel";
    public static final String LOT_SIZE_CONFIG_LABEL = "lotSizeConfigLabel";
    public static final String SPREAD_CONFIG_LABEL = "spreadConfigLabel";
    public static final String FORMAT_DATE_CONFIG_LABEL = "formatDateConfigLabel";
    public static final String FORMAT_DOUBLE_2_PLACES_CONFIG_LABEL = "formatDouble2PlacesConfigLabel";
    public static final String FORMAT_DOUBLE_6_PLACES_CONFIG_LABEL = "formatDouble6PlacesConfigLabel";
    public static final String FORMAT_IN_MILLIONS_CONFIG_LABEL = "formatInMilliosConfigLabel";
    public static final String FORMAT_PRICING_TYPE_CONFIG_LABEL = "formatPricingTypeConfigLabel";
    public static final String ALIGN_CELL_CONTENTS_LEFT_CONFIG_LABEL = "alignCellContentsLeftConfigLabel";
    public static final String ALIGN_CELL_CONTENTS_RIGHT_CONFIG_LABEL = "alignCellContentsRightConfigLabel";
    public static final String CHECK_BOX_CONFIG_LABEL = "checkBox";
    public static final String CHECK_BOX_EDITOR_CONFIG_LABEL = "checkBoxEditor";
    public static final String COMBO_BOX_CONFIG_LABEL = "comboBox";
    public static final String COMBO_BOX_EDITOR_CONFIG_LABEL = "comboBoxEditor";

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(new EditableGridExample());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates various edit and styling functionality. All of the functionality in the DefaultGridExample is available here. Also note that:\n\n* CUSTOM ALIGNMENT: All numeric fields are right-aligned, and the Security Description field is left-aligned.\n* CUSTOM FORMATTING: The Bid and Ask fields are formatted to 2 decimal places normally, but in edit mode they are formatted to 6 decimal places.\n* EDITABLE/NON-EDITABLE FIELDS: Spread is a non-editable calculated field that is formatted to 6 decimal places.\n* SINGLE AND MULTI-CELL EDIT for text, checkbox, and combo box fields. Note that in order to invoke multi-cell edit, all of the selected cells must have the same editor type and be editable.\n* VALIDATION: The ISIN field has validation enabled which requires data to be in the form ABC123 (first three alpha characters, afterwards numeric). If the validation rule is violated, the characters are highlighted in red and the editor will not allow you to enter the value. Also note that if an ISIN field and a different text field are selected for multi-cell edit, the multi-cell editor will require a value that is valid for all selected cells.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        DefaultGridLayer gridLayer = new DefaultGridLayer(RowDataListFixture.getList(), RowDataListFixture.getPropertyNames(), RowDataListFixture.getPropertyToLabelMap());
        DataLayer columnHeaderDataLayer = (DataLayer)gridLayer.getColumnHeaderDataLayer();
        columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        DataLayer bodyDataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        IDataProvider dataProvider = bodyDataLayer.getDataProvider();
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
        natTable.addConfiguration((IConfiguration)EditableGridExample.editableGridConfiguration(columnLabelAccumulator, dataProvider));
        ColumnHeaderCheckBoxPainter columnHeaderCheckBoxPainter = new ColumnHeaderCheckBoxPainter((IUniqueIndexLayer)bodyDataLayer);
        BeveledBorderDecorator column9HeaderPainter = new BeveledBorderDecorator((ICellPainter)new CellPainterDecorator((ICellPainter)new TextPainter(), CellEdgeEnum.RIGHT, (ICellPainter)columnHeaderCheckBoxPainter));
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration((ICellPainter)column9HeaderPainter, columnHeaderCheckBoxPainter, bodyDataLayer){
            private final /* synthetic */ ICellPainter val$column9HeaderPainter;
            private final /* synthetic */ ColumnHeaderCheckBoxPainter val$columnHeaderCheckBoxPainter;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            {
                this.val$column9HeaderPainter = iCellPainter;
                this.val$columnHeaderCheckBoxPainter = columnHeaderCheckBoxPainter;
                this.val$bodyDataLayer = dataLayer;
            }

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.val$column9HeaderPainter, "NORMAL", "COLUMN_9");
            }

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerFirstSingleClickBinding((IMouseEventMatcher)new CellPainterMouseEventMatcher("COLUMN_HEADER", 1, (ICellPainter)this.val$columnHeaderCheckBoxPainter), (IMouseAction)new ToggleCheckBoxColumnAction(this.val$columnHeaderCheckBoxPainter, (IUniqueIndexLayer)this.val$bodyDataLayer));
            }
        });
        natTable.configure();
        return natTable;
    }

    public static AbstractRegistryConfiguration editableGridConfiguration(final ColumnOverrideLabelAccumulator columnLabelAccumulator, final IDataProvider dataProvider) {
        return new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                EditableGridExample.registerConfigLabelsOnColumns(columnLabelAccumulator);
                EditableGridExample.registerISINValidator(configRegistry);
                EditableGridExample.registerAskPriceValidator(configRegistry, dataProvider);
                EditableGridExample.registerBidPriceValidator(configRegistry);
                EditableGridExample.registerSecurityDescriptionCellStyle(configRegistry);
                EditableGridExample.registerPricingCellStyle(configRegistry);
                EditableGridExample.registerPriceFormatter(configRegistry);
                EditableGridExample.registerDateFormatter(configRegistry);
                EditableGridExample.registerLotSizeFormatter(configRegistry);
                EditableGridExample.registerCheckBoxEditor(configRegistry, (ICellPainter)new CheckBoxPainter(), (ICellEditor)new CheckBoxCellEditor());
                EditableGridExample.registerComboBox(configRegistry, (ICellPainter)new ComboBoxPainter(), (ICellEditor)new ComboBoxCellEditor(Arrays.asList(new PricingTypeBean("MN"), new PricingTypeBean("AT"))));
                EditableGridExample.registerEditableRules(configRegistry, dataProvider);
            }
        };
    }

    private static void registerConfigLabelsOnColumns(ColumnOverrideLabelAccumulator columnLabelAccumulator) {
        columnLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"security_id"), new String[]{SECURITY_ID_EDITOR, SECURITY_ID_CONFIG_LABEL});
        columnLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"security_description"), new String[]{ALIGN_CELL_CONTENTS_LEFT_CONFIG_LABEL});
        columnLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"issue_date"), new String[]{FORMAT_DATE_CONFIG_LABEL});
        columnLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"pricing_type"), new String[]{COMBO_BOX_CONFIG_LABEL, COMBO_BOX_EDITOR_CONFIG_LABEL, FORMAT_PRICING_TYPE_CONFIG_LABEL});
        columnLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"bid_price"), new String[]{BID_PRICE_CONFIG_LABEL, FORMAT_DOUBLE_6_PLACES_CONFIG_LABEL, FORMAT_DOUBLE_2_PLACES_CONFIG_LABEL, ALIGN_CELL_CONTENTS_RIGHT_CONFIG_LABEL});
        columnLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"ask_price"), new String[]{ASK_PRICE_CONFIG_LABEL, FORMAT_DOUBLE_6_PLACES_CONFIG_LABEL, FORMAT_DOUBLE_2_PLACES_CONFIG_LABEL, ALIGN_CELL_CONTENTS_RIGHT_CONFIG_LABEL});
        columnLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"spread"), new String[]{SPREAD_CONFIG_LABEL, FORMAT_DOUBLE_6_PLACES_CONFIG_LABEL, ALIGN_CELL_CONTENTS_RIGHT_CONFIG_LABEL});
        columnLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"lot_size"), new String[]{LOT_SIZE_CONFIG_LABEL, FORMAT_IN_MILLIONS_CONFIG_LABEL, ALIGN_CELL_CONTENTS_RIGHT_CONFIG_LABEL});
        columnLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"publish_flag"), new String[]{CHECK_BOX_EDITOR_CONFIG_LABEL, CHECK_BOX_CONFIG_LABEL});
    }

    private static void registerSecurityDescriptionCellStyle(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.LEFT);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", ALIGN_CELL_CONTENTS_LEFT_CONFIG_LABEL);
    }

    private static void registerPricingCellStyle(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignmentEnum.RIGHT);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", ALIGN_CELL_CONTENTS_RIGHT_CONFIG_LABEL);
    }

    private static void registerCheckBoxEditor(IConfigRegistry configRegistry, ICellPainter checkBoxCellPainter, ICellEditor checkBoxCellEditor) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)checkBoxCellPainter, "NORMAL", CHECK_BOX_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", CHECK_BOX_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)checkBoxCellEditor, "NORMAL", CHECK_BOX_EDITOR_CONFIG_LABEL);
    }

    private static void registerComboBox(IConfigRegistry configRegistry, ICellPainter comboBoxCellPainter, ICellEditor comboBoxCellEditor) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)comboBoxCellPainter, "NORMAL", COMBO_BOX_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "NORMAL", COMBO_BOX_EDITOR_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)comboBoxCellEditor, "EDIT", COMBO_BOX_EDITOR_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", FORMAT_PRICING_TYPE_CONFIG_LABEL);
    }

    private static void registerISINValidator(IConfigRegistry configRegistry) {
        TextCellEditor textCellEditor = new TextCellEditor();
        textCellEditor.setErrorDecorationEnabled(true);
        textCellEditor.setErrorDecorationText("Security Id must be 3 alpha characters optionally followed by numbers");
        textCellEditor.setDecorationPositionOverride(16512);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)textCellEditor, "NORMAL", SECURITY_ID_EDITOR);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)EditableGridExample.getSecurtityIdValidator(), "EDIT", SECURITY_ID_CONFIG_LABEL);
    }

    private static void registerDateFormatter(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)EditableGridExample.getDateFormatter(), "NORMAL", FORMAT_DATE_CONFIG_LABEL);
    }

    private static void registerAskPriceValidator(IConfigRegistry configRegistry, IDataProvider dataProvider) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)EditableGridExample.getAskPriceValidator(dataProvider), "EDIT", ASK_PRICE_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)EditableGridExample.getAskPriceValidator(dataProvider), "NORMAL", ASK_PRICE_CONFIG_LABEL);
    }

    private static void registerBidPriceValidator(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new DefaultNumericDataValidator(), "EDIT", BID_PRICE_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new DefaultNumericDataValidator(), "NORMAL", BID_PRICE_CONFIG_LABEL);
    }

    private static void registerPriceFormatter(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)EditableGridExample.getDoubleDisplayConverter(2), "NORMAL", FORMAT_DOUBLE_2_PLACES_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)EditableGridExample.getDoubleDisplayConverter(6), "NORMAL", FORMAT_DOUBLE_6_PLACES_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)EditableGridExample.getDoubleDisplayConverter(6), "EDIT", FORMAT_DOUBLE_6_PLACES_CONFIG_LABEL);
    }

    private static void registerEditableRules(IConfigRegistry configRegistry, IDataProvider dataProvider) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", SECURITY_ID_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", COMBO_BOX_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", CHECK_BOX_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)EditableGridExample.getEditRule(dataProvider), "EDIT", ASK_PRICE_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)EditableGridExample.getEditRule(dataProvider), "EDIT", BID_PRICE_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)EditableGridExample.getEditRule(dataProvider), "EDIT", LOT_SIZE_CONFIG_LABEL);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "EDIT", SPREAD_CONFIG_LABEL);
    }

    private static void registerLotSizeFormatter(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)EditableGridExample.getMillionsDisplayConverter(), "NORMAL", FORMAT_IN_MILLIONS_CONFIG_LABEL);
    }

    private static IEditableRule getEditRule(final IDataProvider dataProvider) {
        return new EditableRule(){

            public boolean isEditable(int columnIndex, int rowIndex) {
                int columnIndexOfPublishFlag = RowDataListFixture.getColumnIndexOfProperty((String)"publish_flag");
                return (Boolean)dataProvider.getDataValue(columnIndexOfPublishFlag, rowIndex);
            }
        };
    }

    private static IDisplayConverter getDoubleDisplayConverter(final int decimalPlaces) {
        return new DisplayConverter(){
            NumberFormat numberFormatter = NumberFormat.getInstance();

            public Object canonicalToDisplayValue(Object canonicalValue) {
                if (canonicalValue == null) {
                    return "";
                }
                this.numberFormatter.setMaximumFractionDigits(decimalPlaces);
                this.numberFormatter.setMinimumFractionDigits(decimalPlaces);
                return this.numberFormatter.format(Double.valueOf(canonicalValue.toString()));
            }

            public Object displayToCanonicalValue(Object displayValue) {
                try {
                    return this.numberFormatter.parse((String)displayValue);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
        };
    }

    private static IDisplayConverter getDateFormatter() {
        return new DisplayConverter(){
            private final SimpleDateFormat dateFormatter = new SimpleDateFormat("MM-dd-yy");

            public Object canonicalToDisplayValue(Object canonicalValue) {
                return this.dateFormatter.format((Date)canonicalValue);
            }

            public Object displayToCanonicalValue(Object displayValue) {
                return this.dateFormatter.parse(displayValue.toString(), new ParsePosition(0));
            }
        };
    }

    private static IDisplayConverter getMillionsDisplayConverter() {
        return new DisplayConverter(){
            NumberFormat numberFormatter = new DecimalFormat("###,###,###");

            public Object canonicalToDisplayValue(Object canonicalValue) {
                if (canonicalValue == null) {
                    return null;
                }
                return this.numberFormatter.format(Integer.valueOf(canonicalValue.toString()));
            }

            public Object displayToCanonicalValue(Object displayValue) {
                return this.numberFormatter.parse(displayValue.toString(), new ParsePosition(0)).intValue();
            }
        };
    }

    private static IDataValidator getAskPriceValidator(final IDataProvider dataProvider) {
        return new DataValidator(){

            public boolean validate(int columnIndex, int rowIndex, Object newValue) {
                try {
                    int indexOfBidPrice = RowDataListFixture.getColumnIndexOfProperty((String)"bid_price");
                    double bidPrice = (Double)dataProvider.getDataValue(indexOfBidPrice, rowIndex);
                    double askPrice = Double.valueOf(newValue.toString());
                    return askPrice > bidPrice;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
    }

    private static IDataValidator getSecurtityIdValidator() {
        return new DataValidator(){

            public boolean validate(int columnIndex, int rowIndex, Object newValue) {
                if (newValue == null) {
                    return false;
                }
                String value = (String)newValue;
                if (value.length() > 3) {
                    String alphabeticPart = value.substring(0, 2);
                    String numericPart = value.substring(3, value.length());
                    return this.isAlpha(alphabeticPart) && this.isNumeric(numericPart);
                }
                String alphabeticPart = value.substring(0, value.length());
                return this.isAlpha(alphabeticPart);
            }

            private boolean isAlpha(String str) {
                int i = 0;
                while (i < str.length()) {
                    if (!Character.isLetter(str.charAt(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private boolean isNumeric(String str) {
                int i = 0;
                while (i < str.length()) {
                    if (!Character.isDigit(str.charAt(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
    }
}

