/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._504_Viewport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonWithAddress;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentIndexLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractIndexLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.resize.action.VerticalResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectAllCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.ClientAreaAdapter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.SliderScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.nebula.widgets.nattable.viewport.command.RecalculateScrollBarsCommand;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectColumnCommand;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectRowCommand;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class _5046_MultiScrollExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5046_MultiScrollExample());
    }

    @Override
    public String getDescription() {
        return "This example shows multiple scrollable regions.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        List values = PersonService.getPersonsWithAddress((int)10);
        ContentBodyLayerStack contentBodyLayer = new ContentBodyLayerStack(values);
        StructureBodyLayerStack structureBodyLayer = new StructureBodyLayerStack(values, (IUniqueIndexLayer)contentBodyLayer);
        DefaultColumnHeaderDataProvider contentHeaderDataProvider = new DefaultColumnHeaderDataProvider(contentBodyLayer.propertyNames, contentBodyLayer.propertyToLabelMap);
        DefaultColumnHeaderDataLayer contentHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)contentHeaderDataProvider);
        ColumnHeaderLayer contentColumnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)contentHeaderDataLayer, (ILayer)contentBodyLayer, contentBodyLayer.getSelectionLayer());
        DefaultColumnHeaderDataProvider structureHeaderDataProvider = new DefaultColumnHeaderDataProvider(structureBodyLayer.propertyNames, structureBodyLayer.propertyToLabelMap);
        DefaultColumnHeaderDataLayer structureHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)structureHeaderDataProvider);
        ColumnHeaderLayer structureColumnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)structureHeaderDataLayer, (ILayer)structureBodyLayer, structureBodyLayer.selectionLayer);
        structureColumnHeaderLayer.setVerticalLayerDependency((ILayer)contentColumnHeaderLayer);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)new DefaultRowHeaderDataProvider(contentBodyLayer.bodyDataProvider));
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)contentBodyLayer, null);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)contentHeaderDataProvider, rowHeaderDataLayer.getDataProvider());
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)contentColumnHeaderLayer);
        ExtendedGridLayer gridLayer = new ExtendedGridLayer(contentBodyLayer, (ILayer)contentColumnHeaderLayer, structureBodyLayer, (ILayer)structureColumnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        int leftWidth = 80;
        ClientAreaAdapter leftClientAreaAdapter = new ClientAreaAdapter(structureBodyLayer.getViewportLayer().getClientAreaProvider());
        leftClientAreaAdapter.setWidth(leftWidth);
        structureBodyLayer.getViewportLayer().setClientAreaProvider((IClientAreaProvider)leftClientAreaAdapter);
        structureBodyLayer.getViewportLayer().setVerticalScrollbarEnabled(false);
        contentBodyLayer.getSelectionLayer().setLayerPainter((ILayerPainter)new SelectionLayerPainter(true, false));
        contentColumnHeaderLayer.setLayerPainter((ILayerPainter)new CellLayerPainter(true, false));
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite composite = new Composite((Composite)sc, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        NatTable natTable = new NatTable(composite, (ILayer)gridLayer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        natTable.setLayoutData((Object)gridData);
        this.createSplitSliders(composite, gridLayer, rowHeaderLayer.getWidth());
        sc.setContent((Control)composite);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.updateScrolledCompositeSize(sc, gridLayer);
        natTable.addOverlayPainter(new IOverlayPainter((ILayer)rowHeaderLayer, gridLayer){
            private final /* synthetic */ ILayer val$rowHeaderLayer;
            private final /* synthetic */ ExtendedGridLayer val$gridLayer;
            {
                this.val$rowHeaderLayer = iLayer;
                this.val$gridLayer = extendedGridLayer;
            }

            public void paintOverlay(GC gc, ILayer layer) {
                Color beforeColor = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_GRAY);
                int viewportBorderX = this.val$rowHeaderLayer.getWidth() + this.val$gridLayer.getStructureBody().getWidth() - 1;
                gc.drawLine(viewportBorderX, 0, viewportBorderX, layer.getHeight() - 1);
                gc.setForeground(beforeColor);
            }
        });
        natTable.getUiBindingRegistry().registerFirstMouseMoveBinding((IMouseEventMatcher)new ClientAreaResizeMatcher(gridLayer), (IMouseAction)new VerticalResizeCursorAction());
        natTable.getUiBindingRegistry().registerFirstMouseDragMode((IMouseEventMatcher)new ClientAreaResizeMatcher(gridLayer), (IDragMode)new ClientAreaResizeDragMode(gridLayer, sc));
        return natTable;
    }

    private void updateScrolledCompositeSize(ScrolledComposite sc, ExtendedGridLayer gridLayer) {
        sc.setMinSize(gridLayer.getRowHeaderLayer().getWidth() + gridLayer.getStructureBody().getWidth() + 100, gridLayer.getContentHeader().getHeight() + 20);
    }

    private void createSplitSliders(Composite natTableParent, final ExtendedGridLayer gridLayer, final int fixedHeaderWidth) {
        Composite sliderComposite = new Composite(natTableParent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 17;
        sliderComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        sliderComposite.setLayout((Layout)gridLayout);
        Composite sliderLeftComposite = new Composite(sliderComposite, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int width = ((ClientAreaAdapter)gridLayer.getStructureBody().getViewportLayer().getClientAreaProvider()).getWidth() + fixedHeaderWidth;
                return new Point(width, 17);
            }
        };
        sliderLeftComposite.setLayout((Layout)new FillLayout());
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        sliderLeftComposite.setLayoutData((Object)gridData);
        Slider sliderLeft = new Slider(sliderLeftComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        sliderLeft.setLayoutData((Object)gridData);
        gridLayer.getStructureBody().getViewportLayer().setHorizontalScroller((IScroller)new SliderScroller(sliderLeft));
        Slider sliderRight = new Slider(sliderComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        sliderRight.setLayoutData((Object)gridData);
        gridLayer.getContentBody().getViewportLayer().setHorizontalScroller((IScroller)new SliderScroller(sliderRight));
    }

    class ClientAreaResizeDragMode
    implements IDragMode {
        ExtendedGridLayer gridLayer;
        ScrolledComposite sc;

        public ClientAreaResizeDragMode(ExtendedGridLayer gridLayer, ScrolledComposite sc) {
            this.gridLayer = gridLayer;
            this.sc = sc;
        }

        public void mouseDown(NatTable natTable, MouseEvent event) {
        }

        public void mouseMove(NatTable natTable, MouseEvent event) {
        }

        public void mouseUp(NatTable natTable, MouseEvent event) {
            int baseWidth = this.gridLayer.getStructureBody().bodyDataLayer.getWidth();
            int newWidth = event.x - this.gridLayer.getRowHeaderLayer().getWidth();
            if (newWidth < 0) {
                newWidth = 1;
            } else if (newWidth > baseWidth) {
                newWidth = baseWidth;
            }
            ((ClientAreaAdapter)this.gridLayer.getStructureBody().getViewportLayer().getClientAreaProvider()).setWidth(newWidth);
            this.gridLayer.getStructureBody().getViewportLayer().invalidateHorizontalStructure();
            this.gridLayer.getStructureBody().getViewportLayer().doCommand((ILayerCommand)new RecalculateScrollBarsCommand());
            this.gridLayer.getContentBody().getViewportLayer().invalidateHorizontalStructure();
            this.gridLayer.getContentBody().getViewportLayer().doCommand((ILayerCommand)new RecalculateScrollBarsCommand());
            natTable.redraw();
            natTable.getParent().layout(true, true);
            _5046_MultiScrollExample.this.updateScrolledCompositeSize(this.sc, this.gridLayer);
        }
    }

    class ClientAreaResizeMatcher
    extends MouseEventMatcher {
        ExtendedGridLayer gridLayer;

        public ClientAreaResizeMatcher(ExtendedGridLayer gridLayer) {
            this.gridLayer = gridLayer;
        }

        public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
            int viewportBorderX = this.gridLayer.getRowHeaderLayer().getWidth() + this.gridLayer.getStructureBody().getWidth();
            return regionLabels != null && regionLabels.hasLabel("COLUMN_HEADER") && event.x >= viewportBorderX && event.x <= viewportBorderX + 4;
        }
    }

    class ContentBodyLayerStack
    extends AbstractIndexLayerTransform {
        public final String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        public final Map<String, String> propertyToLabelMap = new HashMap<String, String>();
        private final IDataProvider bodyDataProvider;
        private final DataLayer bodyDataLayer;
        private final SelectionLayer selectionLayer;
        private final ViewportLayer viewportLayer;

        public ContentBodyLayerStack(List<PersonWithAddress> values) {
            this.propertyToLabelMap.put("firstName", "Firstname");
            this.propertyToLabelMap.put("lastName", "Lastname");
            this.propertyToLabelMap.put("gender", "Gender");
            this.propertyToLabelMap.put("married", "Married");
            this.propertyToLabelMap.put("birthday", "Birthday");
            ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(this.propertyNames);
            this.bodyDataProvider = new ListDataProvider(values, (IColumnAccessor)columnPropertyAccessor);
            this.bodyDataLayer = new DataLayer(this.bodyDataProvider);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.bodyDataLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((IUniqueIndexLayer)this.viewportLayer);
        }

        public ViewportLayer getViewportLayer() {
            return this.viewportLayer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }
    }

    class ExtendedGridLayer
    extends CompositeLayer {
        public ExtendedGridLayer(ContentBodyLayerStack contentBodyLayer, ILayer contentColumnHeaderLayer, StructureBodyLayerStack structureBodyLayer, ILayer structureColumnHeaderLayer, ILayer rowHeaderLayer, ILayer cornerLayer) {
            super(3, 2);
            this.setChildLayer("CORNER", cornerLayer, 0, 0);
            this.setChildLayer("ROW_HEADER", rowHeaderLayer, 0, 1);
            this.setChildLayer("COLUMN_HEADER", structureColumnHeaderLayer, 1, 0);
            this.setChildLayer("BODY", (ILayer)structureBodyLayer, 1, 1);
            this.setChildLayer("COLUMN_HEADER", contentColumnHeaderLayer, 2, 0);
            this.setChildLayer("BODY", (ILayer)contentBodyLayer, 2, 1);
        }

        public StructureBodyLayerStack getStructureBody() {
            return (StructureBodyLayerStack)this.getChildLayerByLayoutCoordinate(1, 1);
        }

        public ContentBodyLayerStack getContentBody() {
            return (ContentBodyLayerStack)this.getChildLayerByLayoutCoordinate(2, 1);
        }

        public ILayer getStructureHeader() {
            return this.getChildLayerByLayoutCoordinate(1, 0);
        }

        public ILayer getContentHeader() {
            return this.getChildLayerByLayoutCoordinate(2, 0);
        }

        public ILayer getRowHeaderLayer() {
            return this.getChildLayerByLayoutCoordinate(0, 1);
        }

        protected boolean doCommandOnChildLayers(ILayerCommand command) {
            if (this.doCommandOnChildLayer(command, (ILayer)this.getContentBody())) {
                return true;
            }
            if (this.doCommandOnChildLayer(command, (ILayer)this.getStructureBody())) {
                return true;
            }
            if (this.doCommandOnChildLayer(command, this.getContentHeader())) {
                return true;
            }
            if (this.doCommandOnChildLayer(command, this.getStructureHeader())) {
                return true;
            }
            if (this.doCommandOnChildLayer(command, this.getRowHeaderLayer())) {
                return true;
            }
            return this.doCommandOnChildLayer(command, this.getChildLayerByLayoutCoordinate(0, 0));
        }

        private boolean doCommandOnChildLayer(ILayerCommand command, ILayer childLayer) {
            ILayerCommand childCommand = command.cloneCommand();
            return childLayer.doCommand(childCommand);
        }

        public boolean doCommand(ILayerCommand command) {
            if (command instanceof ViewportSelectRowCommand || command instanceof ClearAllSelectionsCommand || command instanceof SelectAllCommand) {
                this.doCommandOnChildLayer(command, (ILayer)this.getContentBody());
                this.doCommandOnChildLayer(command, (ILayer)this.getStructureBody());
                return true;
            }
            if (command instanceof SelectCellCommand) {
                int layout = this.getLayoutXByColumnPosition(((SelectCellCommand)command).getColumnPosition());
                if (layout == 2) {
                    this.doCommandOnChildLayer((ILayerCommand)new ClearAllSelectionsCommand(), (ILayer)this.getStructureBody());
                } else {
                    this.doCommandOnChildLayer((ILayerCommand)new ClearAllSelectionsCommand(), (ILayer)this.getContentBody());
                }
            } else if (command instanceof ViewportSelectColumnCommand) {
                int layout = this.getLayoutXByColumnPosition(((ViewportSelectColumnCommand)command).getColumnPosition());
                if (layout == 2) {
                    this.doCommandOnChildLayer((ILayerCommand)new ClearAllSelectionsCommand(), (ILayer)this.getStructureBody());
                } else {
                    this.doCommandOnChildLayer((ILayerCommand)new ClearAllSelectionsCommand(), (ILayer)this.getContentBody());
                }
            }
            return super.doCommand(command);
        }
    }

    class StructureBodyLayerStack
    extends AbstractIndexLayerTransform {
        public final String[] propertyNames = new String[]{"address.street", "address.housenumber", "address.postalCode", "address.city"};
        public final Map<String, String> propertyToLabelMap = new HashMap<String, String>();
        private final IDataProvider bodyDataProvider;
        private final DataLayer bodyDataLayer;
        private final SelectionLayer selectionLayer;
        private final ViewportLayer viewportLayer;

        public StructureBodyLayerStack(List<PersonWithAddress> values, IUniqueIndexLayer verticalDependency) {
            this.propertyToLabelMap.put("address.street", "Street");
            this.propertyToLabelMap.put("address.housenumber", "Housenumber");
            this.propertyToLabelMap.put("address.postalCode", "Postal Code");
            this.propertyToLabelMap.put("address.city", "City");
            ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(this.propertyNames);
            this.bodyDataProvider = new ListDataProvider(values, (IColumnAccessor)columnPropertyAccessor);
            this.bodyDataLayer = new DataLayer(this.bodyDataProvider);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.bodyDataLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((IUniqueIndexLayer)new DimensionallyDependentIndexLayer((IUniqueIndexLayer)this.viewportLayer, (IUniqueIndexLayer)this.viewportLayer, verticalDependency));
        }

        public ViewportLayer getViewportLayer() {
            return this.viewportLayer;
        }
    }
}

