/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._504_Viewport;

import java.util.HashMap;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.resize.action.VerticalResizeCursorAction;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayerPainter;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.util.ClientAreaAdapter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.SliderScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.nebula.widgets.nattable.viewport.command.RecalculateScrollBarsCommand;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class _5045_ScrollableRowHeaderExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5045_ScrollableRowHeaderExample());
    }

    @Override
    public String getDescription() {
        return "This example shows a scrollable row header.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider bodyDataProvider = new ListDataProvider(PersonService.getPersons((int)10), (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DataLayer rowDataLayer = new DataLayer(new IDataProvider((IDataProvider)bodyDataProvider){
            private final /* synthetic */ IDataProvider val$bodyDataProvider;
            {
                this.val$bodyDataProvider = iDataProvider;
            }

            public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            }

            public int getRowCount() {
                return this.val$bodyDataProvider.getRowCount();
            }

            public Object getDataValue(int columnIndex, int rowIndex) {
                return "Lorem ipsum dolor";
            }

            public int getColumnCount() {
                return 1;
            }
        });
        rowDataLayer.setDefaultColumnWidth(150);
        ViewportLayer rowViewport = new ViewportLayer((IUniqueIndexLayer)rowDataLayer);
        RowHeaderLayer scrollableRowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowViewport, (ILayer)viewportLayer, selectionLayer);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)new DefaultRowHeaderDataLayer((IDataProvider)new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider)), (ILayer)viewportLayer, selectionLayer);
        final CompositeLayer compositeLayer = new CompositeLayer(2, 1);
        compositeLayer.setChildLayer("ROW_HEADER", (ILayer)rowHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("ROW_HEADER", (ILayer)scrollableRowHeaderLayer, 1, 0);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, rowDataLayer.getDataProvider());
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)compositeLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)compositeLayer, (ILayer)cornerLayer);
        selectionLayer.setLayerPainter((ILayerPainter)new SelectionLayerPainter(true, false));
        columnHeaderLayer.setLayerPainter((ILayerPainter)new CellLayerPainter(true, false));
        int leftWidth = 100;
        ClientAreaAdapter leftClientAreaAdapter = new ClientAreaAdapter(rowViewport.getClientAreaProvider());
        leftClientAreaAdapter.setWidth(leftWidth);
        rowViewport.setClientAreaProvider((IClientAreaProvider)leftClientAreaAdapter);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        NatTable natTable = new NatTable(composite, (ILayer)gridLayer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        natTable.setLayoutData((Object)gridData);
        this.createSplitSliders(composite, rowViewport, rowHeaderLayer.getWidth(), viewportLayer);
        natTable.addOverlayPainter(new IOverlayPainter(){

            public void paintOverlay(GC gc, ILayer layer) {
                Color beforeColor = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_GRAY);
                int viewportBorderX = compositeLayer.getWidth() - 1;
                gc.drawLine(viewportBorderX, 0, viewportBorderX, layer.getHeight() - 1);
                gc.setForeground(beforeColor);
            }
        });
        natTable.getUiBindingRegistry().registerFirstMouseMoveBinding((IMouseEventMatcher)new ClientAreaResizeMatcher((ILayer)compositeLayer), (IMouseAction)new VerticalResizeCursorAction());
        natTable.getUiBindingRegistry().registerFirstMouseDragMode((IMouseEventMatcher)new ClientAreaResizeMatcher((ILayer)compositeLayer), (IDragMode)new ClientAreaResizeDragMode((ILayer)compositeLayer, (ILayer)rowDataLayer, leftClientAreaAdapter, rowViewport, viewportLayer));
        return natTable;
    }

    private void createSplitSliders(Composite natTableParent, final ViewportLayer left, final int fixedHeaderWidth, ViewportLayer right) {
        Composite sliderComposite = new Composite(natTableParent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 17;
        sliderComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        sliderComposite.setLayout((Layout)gridLayout);
        Composite sliderLeftComposite = new Composite(sliderComposite, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int width = ((ClientAreaAdapter)left.getClientAreaProvider()).getWidth() + fixedHeaderWidth;
                return new Point(width, 17);
            }
        };
        sliderLeftComposite.setLayout((Layout)new FillLayout());
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        sliderLeftComposite.setLayoutData((Object)gridData);
        Slider sliderLeft = new Slider(sliderLeftComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        sliderLeft.setLayoutData((Object)gridData);
        left.setHorizontalScroller((IScroller)new SliderScroller(sliderLeft));
        Slider sliderRight = new Slider(sliderComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        sliderRight.setLayoutData((Object)gridData);
        right.setHorizontalScroller((IScroller)new SliderScroller(sliderRight));
    }

    class ClientAreaResizeDragMode
    implements IDragMode {
        ILayer baseLayer;
        ClientAreaAdapter clientAreaAdapter;
        ViewportLayer[] viewportLayer;
        int diff = 0;

        public ClientAreaResizeDragMode(ILayer resizable, ILayer baseLayer, ClientAreaAdapter clientAreaAdapter, ViewportLayer ... viewportLayer) {
            this.baseLayer = baseLayer;
            this.clientAreaAdapter = clientAreaAdapter;
            this.viewportLayer = viewportLayer;
            this.diff = resizable.getWidth() - clientAreaAdapter.getWidth();
        }

        public void mouseDown(NatTable natTable, MouseEvent event) {
        }

        public void mouseMove(NatTable natTable, MouseEvent event) {
        }

        public void mouseUp(NatTable natTable, MouseEvent event) {
            int newWidth = event.x - this.diff;
            if (newWidth < 0) {
                newWidth = 1;
            } else if (newWidth > this.baseLayer.getWidth()) {
                newWidth = this.baseLayer.getWidth();
            }
            this.clientAreaAdapter.setWidth(newWidth);
            ViewportLayer[] viewportLayerArray = this.viewportLayer;
            int n = this.viewportLayer.length;
            int n2 = 0;
            while (n2 < n) {
                ViewportLayer vp = viewportLayerArray[n2];
                vp.invalidateHorizontalStructure();
                vp.doCommand((ILayerCommand)new RecalculateScrollBarsCommand());
                ++n2;
            }
            natTable.redraw();
            natTable.getParent().layout(true, true);
        }
    }

    class ClientAreaResizeMatcher
    extends MouseEventMatcher {
        ILayer rowHeaderLayer;

        public ClientAreaResizeMatcher(ILayer rowHeaderLayer) {
            this.rowHeaderLayer = rowHeaderLayer;
        }

        public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
            return regionLabels != null && regionLabels.hasLabel("COLUMN_HEADER") && event.x > this.rowHeaderLayer.getWidth() - 5 && event.x < this.rowHeaderLayer.getWidth() + 5;
        }
    }
}

