/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.validation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.mylyn.wikitext.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.validation.ValidationRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StandaloneMarkupValidator {
    private static Map<ClassLoader, Map<String, StandaloneMarkupValidator>> validatorCacheByClassLoader = new WeakHashMap<ClassLoader, Map<String, StandaloneMarkupValidator>>();
    private List<ValidationRule> rules = new ArrayList<ValidationRule>();
    private ClassLoader classLoader;
    private boolean immutable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StandaloneMarkupValidator getValidator(String markupLanguage) {
        ClassLoader classLoader = StandaloneMarkupValidator.computeClassLoader();
        Class<StandaloneMarkupValidator> clazz = StandaloneMarkupValidator.class;
        synchronized (StandaloneMarkupValidator.class) {
            StandaloneMarkupValidator validator;
            Map<String, StandaloneMarkupValidator> validatorByMarkupLanguage = validatorCacheByClassLoader.get(classLoader);
            if (validatorByMarkupLanguage == null) {
                validatorByMarkupLanguage = new HashMap<String, StandaloneMarkupValidator>();
                validatorCacheByClassLoader.put(classLoader, validatorByMarkupLanguage);
            }
            if ((validator = validatorByMarkupLanguage.get(markupLanguage)) == null) {
                validator = new StandaloneMarkupValidator();
                validator.computeRules(markupLanguage);
                validator.setImmutable();
                validatorByMarkupLanguage.put(markupLanguage, validator);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return validator;
        }
    }

    private static ClassLoader computeClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        return StandaloneMarkupValidator.class.getClassLoader();
    }

    private void setImmutable() {
        if (!this.immutable) {
            this.immutable = true;
            this.rules = Collections.unmodifiableList(this.rules);
        }
    }

    public List<ValidationProblem> validate(String markup) {
        return this.validate(markup, 0, markup.length());
    }

    public List<ValidationProblem> validate(String markup, int offset, int length) {
        if (length == 0 || this.rules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        for (ValidationRule rule : this.rules) {
            problems.addAll(rule.findProblems(markup, offset, length));
        }
        if (!problems.isEmpty()) {
            Collections.sort(problems);
        }
        return problems;
    }

    public List<ValidationRule> getRules() {
        return this.rules;
    }

    public void computeRules(String markupLanguage) {
        try {
            Enumeration<URL> resources = this.getClassLoader().getResources("plugin.xml");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.computeRules(markupLanguage, url);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void computeRules(String markupLanguage, URL url) {
        try (InputStream in = url.openStream();){
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            Document pluginXml = dbf.newDocumentBuilder().parse(in);
            this.computeRules(markupLanguage, pluginXml);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void computeRules(String markupLanguage, Document pluginXml) {
        for (Node child = pluginXml.getDocumentElement().getFirstChild(); child != null; child = child.getNextSibling()) {
            Element element;
            String point;
            if (child.getNodeType() != 1 || !child.getLocalName().equals("extension") || !"org.eclipse.mylyn.wikitext.ui.markupValidationRule".equals(point = (element = (Element)child).getAttribute("point"))) continue;
            for (Node vrNode = child.getFirstChild(); vrNode != null; vrNode = vrNode.getNextSibling()) {
                Element rule;
                if (vrNode.getNodeType() != 1 || !vrNode.getLocalName().equals("rule") || !markupLanguage.equals((rule = (Element)vrNode).getAttribute("markupLanguage"))) continue;
                String className = rule.getAttribute("class");
                try {
                    Class<?> validationRuleClass = Class.forName(className, true, this.getClassLoader());
                    this.rules.add((ValidationRule)validationRuleClass.newInstance());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return StandaloneMarkupValidator.computeClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (this.immutable) {
            throw new IllegalStateException();
        }
        this.classLoader = classLoader;
    }
}

