/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.external.ExternalParsersConfigReaderMetKeys;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ExternalParsersConfigReader
implements ExternalParsersConfigReaderMetKeys {
    public static List<ExternalParser> read(InputStream stream) throws TikaException, IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(stream));
            return ExternalParsersConfigReader.read(document);
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("Unable to create an XML parser", e);
        }
        catch (SAXException e) {
            throw new TikaException("Invalid parser configuration", e);
        }
    }

    public static List<ExternalParser> read(Document document) throws TikaException, IOException {
        return ExternalParsersConfigReader.read(document.getDocumentElement());
    }

    public static List<ExternalParser> read(Element element) throws TikaException, IOException {
        ArrayList<ExternalParser> parsers = new ArrayList<ExternalParser>();
        if (element != null && element.getTagName().equals("external-parsers")) {
            NodeList nodes = element.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                ExternalParser p;
                Element child;
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && (child = (Element)node).getTagName().equals("parser") && (p = ExternalParsersConfigReader.readParser(child)) != null) {
                    parsers.add(p);
                }
                ++i;
            }
        } else {
            throw new MimeTypeException("Not a <external-parsers/> configuration document: " + element.getTagName());
        }
        return parsers;
    }

    private static ExternalParser readParser(Element parserDef) throws TikaException {
        ExternalParser parser = new ExternalParser();
        NodeList children = parserDef.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                if (child.getTagName().equals("check")) {
                    boolean present = ExternalParsersConfigReader.readCheckTagAndCheck(child);
                    if (!present) {
                        return null;
                    }
                } else if (child.getTagName().equals("command")) {
                    parser.setCommand(ExternalParsersConfigReader.getString(child));
                } else if (child.getTagName().equals("mime-types")) {
                    parser.setSupportedTypes(ExternalParsersConfigReader.readMimeTypes(child));
                } else if (child.getTagName().equals("metadata")) {
                    parser.setMetadataExtractionPatterns(ExternalParsersConfigReader.readMetadataPatterns(child));
                }
            }
            ++i;
        }
        return parser;
    }

    private static Set<MediaType> readMimeTypes(Element mimeTypes) {
        HashSet<MediaType> types = new HashSet<MediaType>();
        NodeList children = mimeTypes.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element child;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && (child = (Element)node).getTagName().equals("mime-type")) {
                types.add(MediaType.parse(ExternalParsersConfigReader.getString(child)));
            }
            ++i;
        }
        return types;
    }

    private static Map<Pattern, String> readMetadataPatterns(Element metadataDef) {
        HashMap<Pattern, String> metadata = new HashMap<Pattern, String>();
        NodeList children = metadataDef.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element child;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && (child = (Element)node).getTagName().equals("match")) {
                String metadataKey = child.getAttribute("key");
                Pattern pattern = Pattern.compile(ExternalParsersConfigReader.getString(child));
                metadata.put(pattern, metadataKey);
            }
            ++i;
        }
        return metadata;
    }

    private static boolean readCheckTagAndCheck(Element checkDef) {
        String command = null;
        ArrayList<Integer> errorVals = new ArrayList<Integer>();
        NodeList children = checkDef.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                if (child.getTagName().equals("command")) {
                    command = ExternalParsersConfigReader.getString(child);
                }
                if (child.getTagName().equals("error-codes")) {
                    String errs = ExternalParsersConfigReader.getString(child);
                    StringTokenizer st = new StringTokenizer(errs);
                    while (st.hasMoreElements()) {
                        try {
                            String s = st.nextToken();
                            errorVals.add(Integer.parseInt(s));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
        if (command != null) {
            int[] errVals = new int[errorVals.size()];
            int i2 = 0;
            while (i2 < errVals.length) {
                errVals[i2] = (Integer)errorVals.get(i2);
                ++i2;
            }
            return ExternalParser.check(command, errVals);
        }
        return true;
    }

    private static String getString(Element element) {
        StringBuffer s = new StringBuffer();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 3) {
                s.append(node.getNodeValue());
            }
            ++i;
        }
        return s.toString();
    }
}

