/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.internal.token;

import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.tracwiki.TracWikiLanguage;

public class SourceLinkReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "(source:([^\\s@#]+)(?:@(\\d+))?(?:#L(\\d+))?)";
    }

    protected int getPatternGroupCount() {
        return 4;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new LinkReplacementTokenProcessor();
    }

    private static class LinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private LinkReplacementTokenProcessor() {
        }

        public void emit() {
            String text = this.group(1);
            String source = this.group(2);
            String revision = this.group(3);
            String line = this.group(4);
            String href = ((TracWikiLanguage)this.markupLanguage).toSourceBrowserHref(source, revision, line);
            this.builder.link(href, text);
        }
    }
}

